/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServiceListFluent;
import io.fabric8.kubernetes.api.model.ServiceListFluentImpl;
import java.util.Objects;

public class ServiceListBuilder
extends ServiceListFluentImpl<ServiceListBuilder>
implements VisitableBuilder<ServiceList, ServiceListBuilder> {
    ServiceListFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceListBuilder() {
        this(true);
    }

    public ServiceListBuilder(Boolean validationEnabled) {
        this(new ServiceList(), validationEnabled);
    }

    public ServiceListBuilder(ServiceListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceListBuilder(ServiceListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceList(), validationEnabled);
    }

    public ServiceListBuilder(ServiceListFluent<?> fluent, ServiceList instance) {
        this(fluent, instance, true);
    }

    public ServiceListBuilder(ServiceListFluent<?> fluent, ServiceList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ServiceListBuilder(ServiceList instance) {
        this(instance, (Boolean)true);
    }

    public ServiceListBuilder(ServiceList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ServiceList build() {
        ServiceList buildable = new ServiceList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceListBuilder that = (ServiceListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

