/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpec;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpecBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceQuotaStatus;
import io.fabric8.kubernetes.api.model.ResourceQuotaStatusBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaStatusFluentImpl;
import java.util.Objects;

public class ResourceQuotaFluentImpl<A extends ResourceQuotaFluent<A>>
extends BaseFluent<A>
implements ResourceQuotaFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ResourceQuotaSpecBuilder spec;
    private ResourceQuotaStatusBuilder status;

    public ResourceQuotaFluentImpl() {
    }

    public ResourceQuotaFluentImpl(ResourceQuota instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ResourceQuotaFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ResourceQuotaFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ResourceQuotaFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ResourceQuotaFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ResourceQuotaFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ResourceQuotaSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ResourceQuotaSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ResourceQuotaSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new ResourceQuotaSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ResourceQuotaFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ResourceQuotaFluent.SpecNested<A> withNewSpecLike(ResourceQuotaSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ResourceQuotaFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ResourceQuotaFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ResourceQuotaSpecBuilder().build());
    }

    @Override
    public ResourceQuotaFluent.SpecNested<A> editOrNewSpecLike(ResourceQuotaSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ResourceQuotaStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ResourceQuotaStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ResourceQuotaStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new ResourceQuotaStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public ResourceQuotaFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ResourceQuotaFluent.StatusNested<A> withNewStatusLike(ResourceQuotaStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ResourceQuotaFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ResourceQuotaFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ResourceQuotaStatusBuilder().build());
    }

    @Override
    public ResourceQuotaFluent.StatusNested<A> editOrNewStatusLike(ResourceQuotaStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceQuotaFluentImpl that = (ResourceQuotaFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends ResourceQuotaStatusFluentImpl<ResourceQuotaFluent.StatusNested<N>>
    implements ResourceQuotaFluent.StatusNested<N>,
    Nested<N> {
        private final ResourceQuotaStatusBuilder builder;

        StatusNestedImpl(ResourceQuotaStatus item) {
            this.builder = new ResourceQuotaStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ResourceQuotaStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceQuotaFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ResourceQuotaSpecFluentImpl<ResourceQuotaFluent.SpecNested<N>>
    implements ResourceQuotaFluent.SpecNested<N>,
    Nested<N> {
        private final ResourceQuotaSpecBuilder builder;

        SpecNestedImpl(ResourceQuotaSpec item) {
            this.builder = new ResourceQuotaSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ResourceQuotaSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceQuotaFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ResourceQuotaFluent.MetadataNested<N>>
    implements ResourceQuotaFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceQuotaFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

