/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EphemeralVolumeSource;
import io.fabric8.kubernetes.api.model.EphemeralVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimTemplate;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimTemplateBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimTemplateFluentImpl;
import java.util.Objects;

public class EphemeralVolumeSourceFluentImpl<A extends EphemeralVolumeSourceFluent<A>>
extends BaseFluent<A>
implements EphemeralVolumeSourceFluent<A> {
    private Boolean readOnly;
    private PersistentVolumeClaimTemplateBuilder volumeClaimTemplate;

    public EphemeralVolumeSourceFluentImpl() {
    }

    public EphemeralVolumeSourceFluentImpl(EphemeralVolumeSource instance) {
        this.withReadOnly(instance.getReadOnly());
        this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public A withNewReadOnly(String arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    public A withNewReadOnly(boolean arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public PersistentVolumeClaimTemplate getVolumeClaimTemplate() {
        return this.volumeClaimTemplate != null ? this.volumeClaimTemplate.build() : null;
    }

    @Override
    public PersistentVolumeClaimTemplate buildVolumeClaimTemplate() {
        return this.volumeClaimTemplate != null ? this.volumeClaimTemplate.build() : null;
    }

    @Override
    public A withVolumeClaimTemplate(PersistentVolumeClaimTemplate volumeClaimTemplate) {
        this._visitables.get((Object)"volumeClaimTemplate").remove(this.volumeClaimTemplate);
        if (volumeClaimTemplate != null) {
            this.volumeClaimTemplate = new PersistentVolumeClaimTemplateBuilder(volumeClaimTemplate);
            this._visitables.get((Object)"volumeClaimTemplate").add(this.volumeClaimTemplate);
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeClaimTemplate() {
        return this.volumeClaimTemplate != null;
    }

    @Override
    public EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplate() {
        return new VolumeClaimTemplateNestedImpl();
    }

    @Override
    public EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplateLike(PersistentVolumeClaimTemplate item) {
        return new VolumeClaimTemplateNestedImpl(item);
    }

    @Override
    public EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<A> editVolumeClaimTemplate() {
        return this.withNewVolumeClaimTemplateLike(this.getVolumeClaimTemplate());
    }

    @Override
    public EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplate() {
        return this.withNewVolumeClaimTemplateLike(this.getVolumeClaimTemplate() != null ? this.getVolumeClaimTemplate() : new PersistentVolumeClaimTemplateBuilder().build());
    }

    @Override
    public EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplateLike(PersistentVolumeClaimTemplate item) {
        return this.withNewVolumeClaimTemplateLike(this.getVolumeClaimTemplate() != null ? this.getVolumeClaimTemplate() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EphemeralVolumeSourceFluentImpl that = (EphemeralVolumeSourceFluentImpl)o;
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        return !(this.volumeClaimTemplate != null ? !this.volumeClaimTemplate.equals(that.volumeClaimTemplate) : that.volumeClaimTemplate != null);
    }

    public int hashCode() {
        return Objects.hash(this.readOnly, this.volumeClaimTemplate, super.hashCode());
    }

    public class VolumeClaimTemplateNestedImpl<N>
    extends PersistentVolumeClaimTemplateFluentImpl<EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<N>>
    implements EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<N>,
    Nested<N> {
        private final PersistentVolumeClaimTemplateBuilder builder;

        VolumeClaimTemplateNestedImpl(PersistentVolumeClaimTemplate item) {
            this.builder = new PersistentVolumeClaimTemplateBuilder(this, item);
        }

        VolumeClaimTemplateNestedImpl() {
            this.builder = new PersistentVolumeClaimTemplateBuilder(this);
        }

        @Override
        public N and() {
            return (N)EphemeralVolumeSourceFluentImpl.this.withVolumeClaimTemplate(this.builder.build());
        }

        @Override
        public N endVolumeClaimTemplate() {
            return this.and();
        }
    }
}

