/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.APIServiceSpec;
import io.fabric8.kubernetes.api.model.APIServiceSpecFluent;
import io.fabric8.kubernetes.api.model.APIServiceSpecFluentImpl;
import java.util.Objects;

public class APIServiceSpecBuilder
extends APIServiceSpecFluentImpl<APIServiceSpecBuilder>
implements VisitableBuilder<APIServiceSpec, APIServiceSpecBuilder> {
    APIServiceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public APIServiceSpecBuilder() {
        this(true);
    }

    public APIServiceSpecBuilder(Boolean validationEnabled) {
        this(new APIServiceSpec(), validationEnabled);
    }

    public APIServiceSpecBuilder(APIServiceSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public APIServiceSpecBuilder(APIServiceSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new APIServiceSpec(), validationEnabled);
    }

    public APIServiceSpecBuilder(APIServiceSpecFluent<?> fluent, APIServiceSpec instance) {
        this(fluent, instance, true);
    }

    public APIServiceSpecBuilder(APIServiceSpecFluent<?> fluent, APIServiceSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCaBundle(instance.getCaBundle());
        fluent.withGroup(instance.getGroup());
        fluent.withGroupPriorityMinimum(instance.getGroupPriorityMinimum());
        fluent.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
        fluent.withService(instance.getService());
        fluent.withVersion(instance.getVersion());
        fluent.withVersionPriority(instance.getVersionPriority());
        this.validationEnabled = validationEnabled;
    }

    public APIServiceSpecBuilder(APIServiceSpec instance) {
        this(instance, (Boolean)true);
    }

    public APIServiceSpecBuilder(APIServiceSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCaBundle(instance.getCaBundle());
        this.withGroup(instance.getGroup());
        this.withGroupPriorityMinimum(instance.getGroupPriorityMinimum());
        this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
        this.withService(instance.getService());
        this.withVersion(instance.getVersion());
        this.withVersionPriority(instance.getVersionPriority());
        this.validationEnabled = validationEnabled;
    }

    public APIServiceSpec build() {
        APIServiceSpec buildable = new APIServiceSpec(this.fluent.getCaBundle(), this.fluent.getGroup(), this.fluent.getGroupPriorityMinimum(), this.fluent.isInsecureSkipTLSVerify(), this.fluent.getService(), this.fluent.getVersion(), this.fluent.getVersionPriority());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIServiceSpecBuilder that = (APIServiceSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

