/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm;

import java.lang.instrument.Instrumentation;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.Callable;
import org.github.jamm.MemoryLayoutSpecification;
import org.github.jamm.MemoryMeterListener;
import org.github.jamm.NoopMemoryMeterListener;
import org.github.jamm.TreePrinter;
import org.github.jamm.Unmetered;

public class MemoryMeter {
    private static final String outerClassReference = "this\\$[0-9]+";
    private static Instrumentation instrumentation;
    private final Callable<Set<Object>> trackerProvider;
    private final boolean includeFullBufferSize;
    private final Guess guess;
    private final boolean ignoreOuterClassReference;
    private final boolean ignoreKnownSingletons;
    private final boolean ignoreNonStrongReferences;
    private final MemoryMeterListener.Factory listenerFactory;

    public static void premain(String options, Instrumentation inst) {
        instrumentation = inst;
    }

    public static void agentmain(String options, Instrumentation inst) {
        instrumentation = inst;
    }

    public static boolean hasInstrumentation() {
        return instrumentation != null;
    }

    public MemoryMeter() {
        this(new Callable<Set<Object>>(){

            @Override
            public Set<Object> call() throws Exception {
                return Collections.newSetFromMap(new IdentityHashMap());
            }
        }, true, Guess.NEVER, false, false, false, NoopMemoryMeterListener.FACTORY);
    }

    private MemoryMeter(Callable<Set<Object>> trackerProvider, boolean includeFullBufferSize, Guess guess, boolean ignoreOuterClassReference, boolean ignoreKnownSingletons, boolean ignoreNonStrongReferences, MemoryMeterListener.Factory listenerFactory) {
        this.trackerProvider = trackerProvider;
        this.includeFullBufferSize = includeFullBufferSize;
        this.guess = guess;
        this.ignoreOuterClassReference = ignoreOuterClassReference;
        this.ignoreKnownSingletons = ignoreKnownSingletons;
        this.ignoreNonStrongReferences = ignoreNonStrongReferences;
        this.listenerFactory = listenerFactory;
    }

    public MemoryMeter withTrackerProvider(Callable<Set<Object>> trackerProvider) {
        return new MemoryMeter(trackerProvider, this.includeFullBufferSize, this.guess, this.ignoreOuterClassReference, this.ignoreKnownSingletons, this.ignoreNonStrongReferences, this.listenerFactory);
    }

    public MemoryMeter omitSharedBufferOverhead() {
        return new MemoryMeter(this.trackerProvider, false, this.guess, this.ignoreOuterClassReference, this.ignoreKnownSingletons, this.ignoreNonStrongReferences, this.listenerFactory);
    }

    public MemoryMeter withGuessing(Guess guess) {
        return new MemoryMeter(this.trackerProvider, this.includeFullBufferSize, guess, this.ignoreOuterClassReference, this.ignoreKnownSingletons, this.ignoreNonStrongReferences, this.listenerFactory);
    }

    public MemoryMeter ignoreOuterClassReference() {
        return new MemoryMeter(this.trackerProvider, this.includeFullBufferSize, this.guess, true, this.ignoreKnownSingletons, this.ignoreNonStrongReferences, this.listenerFactory);
    }

    public MemoryMeter ignoreKnownSingletons() {
        return new MemoryMeter(this.trackerProvider, this.includeFullBufferSize, this.guess, this.ignoreOuterClassReference, true, this.ignoreNonStrongReferences, this.listenerFactory);
    }

    public MemoryMeter ignoreNonStrongReferences() {
        return new MemoryMeter(this.trackerProvider, this.includeFullBufferSize, this.guess, this.ignoreOuterClassReference, this.ignoreKnownSingletons, true, this.listenerFactory);
    }

    public MemoryMeter enableDebug() {
        return this.enableDebug(Integer.MAX_VALUE);
    }

    public MemoryMeter enableDebug(int depth) {
        if (depth <= 0) {
            throw new IllegalArgumentException(String.format("the depth must be greater than zero (was %s).", depth));
        }
        return new MemoryMeter(this.trackerProvider, this.includeFullBufferSize, this.guess, this.ignoreOuterClassReference, this.ignoreKnownSingletons, this.ignoreNonStrongReferences, new TreePrinter.Factory(depth));
    }

    public long measure(Object object) {
        switch (this.guess) {
            case ALWAYS_UNSAFE: {
                return MemoryLayoutSpecification.sizeOfWithUnsafe(object);
            }
            case ALWAYS_SPEC: {
                return MemoryLayoutSpecification.sizeOf(object);
            }
        }
        if (instrumentation == null) {
            switch (this.guess) {
                case NEVER: {
                    throw new IllegalStateException("Instrumentation is not set; Jamm must be set as -javaagent");
                }
                case FALLBACK_UNSAFE: {
                    if (!MemoryLayoutSpecification.hasUnsafe()) {
                        throw new IllegalStateException("Instrumentation is not set and sun.misc.Unsafe could not be obtained; Jamm must be set as -javaagent, or the SecurityManager must permit access to sun.misc.Unsafe");
                    }
                }
                case FALLBACK_BEST: {
                    if (MemoryLayoutSpecification.hasUnsafe()) {
                        return MemoryLayoutSpecification.sizeOfWithUnsafe(object);
                    }
                }
                case FALLBACK_SPEC: {
                    return MemoryLayoutSpecification.sizeOf(object);
                }
            }
        }
        return instrumentation.getObjectSize(object);
    }

    public long measureDeep(Object object) {
        Set<Object> tracker;
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.ignoreClass(object.getClass())) {
            return 0L;
        }
        try {
            tracker = this.trackerProvider.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MemoryMeterListener listener = this.listenerFactory.newInstance();
        tracker.add(object);
        listener.started(object);
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.push(object);
        long total = 0L;
        while (!stack.isEmpty()) {
            Object current = stack.pop();
            assert (current != null);
            long size = this.measure(current);
            listener.objectMeasured(current, size);
            total += size;
            if (current instanceof Object[]) {
                this.addArrayChildren((Object[])current, stack, tracker, listener);
                continue;
            }
            if (current instanceof ByteBuffer && !this.includeFullBufferSize) {
                total += (long)((ByteBuffer)current).remaining();
                continue;
            }
            Object referent = this.ignoreNonStrongReferences && current instanceof Reference ? ((Reference)current).get() : null;
            this.addFieldChildren(current, stack, tracker, referent, listener);
        }
        listener.done(total);
        return total;
    }

    public long countChildren(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        MemoryMeterListener listener = this.listenerFactory.newInstance();
        Set<Object> tracker = Collections.newSetFromMap(new IdentityHashMap());
        tracker.add(object);
        listener.started(object);
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.push(object);
        long total = 0L;
        while (!stack.isEmpty()) {
            Object current = stack.pop();
            assert (current != null);
            ++total;
            listener.objectCounted(current);
            if (current instanceof Object[]) {
                this.addArrayChildren((Object[])current, stack, tracker, listener);
                continue;
            }
            Object referent = this.ignoreNonStrongReferences && current instanceof Reference ? ((Reference)current).get() : null;
            this.addFieldChildren(current, stack, tracker, referent, listener);
        }
        listener.done(total);
        return total;
    }

    private void addFieldChildren(Object current, Deque<Object> stack, Set<Object> tracker, Object ignorableChild, MemoryMeterListener listener) {
        for (Class<?> cls = current.getClass(); cls != null; cls = cls.getSuperclass()) {
            for (Field field : cls.getDeclaredFields()) {
                Object child;
                if (field.getType().isPrimitive() || Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(Unmetered.class) || this.ignoreOuterClassReference && field.getName().matches(outerClassReference) || this.ignoreClass(field.getType())) continue;
                field.setAccessible(true);
                try {
                    child = field.get(current);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (child == ignorableChild || child == null || tracker.contains(child)) continue;
                stack.push(child);
                tracker.add(child);
                listener.fieldAdded(current, field.getName(), child);
            }
        }
    }

    private boolean ignoreClass(Class<?> cls) {
        return this.ignoreKnownSingletons && (cls.equals(Class.class) || Enum.class.isAssignableFrom(cls)) || this.isAnnotationPresent(cls);
    }

    private boolean isAnnotationPresent(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        if (cls.isAnnotationPresent(Unmetered.class)) {
            return true;
        }
        Class<?>[] interfaces = cls.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!this.isAnnotationPresent(cls.getInterfaces()[i])) continue;
            return true;
        }
        return this.isAnnotationPresent(cls.getSuperclass());
    }

    private void addArrayChildren(Object[] current, Deque<Object> stack, Set<Object> tracker, MemoryMeterListener listener) {
        for (int i = 0; i < current.length; ++i) {
            Class<?> childCls;
            Object child = current[i];
            if (child == null || tracker.contains(child) || this.ignoreClass(childCls = child.getClass())) continue;
            stack.push(child);
            tracker.add(child);
            listener.fieldAdded(current, Integer.toString(i), child);
        }
    }

    public static enum Guess {
        NEVER,
        FALLBACK_SPEC,
        FALLBACK_UNSAFE,
        FALLBACK_BEST,
        ALWAYS_SPEC,
        ALWAYS_UNSAFE;

    }
}

