/*
 * Decompiled with CFR 0.152.
 */
package javinator9889.localemanager.localemanager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import java.util.Locale;
import javinator9889.localemanager.utils.Utils;

public class LocaleManager {
    private final SharedPreferences mPreferences;

    public LocaleManager(@NonNull Context context) {
        this.mPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    public LocaleManager(@NonNull SharedPreferences customSharedPreferences) {
        this.mPreferences = customSharedPreferences;
    }

    public String getLanguage() {
        return this.mPreferences.getString("userLanguage", "sys");
    }

    public Context setLocale(Context context) {
        return this.updateLocaleResources(context, this.getLanguage());
    }

    @NonNull
    public Context setNewLocale(@NonNull Context context, @NonNull String language) {
        return this.setNewLocaleCustomLanguage(context, language);
    }

    @NonNull
    public Context setNewLocaleCustomLanguage(@NonNull Context context, @NonNull String language) {
        this.persistLanguage(language);
        return this.updateLocaleResources(context, language);
    }

    @NonNull
    private Context updateLocaleResources(@NonNull Context context, @NonNull String language) {
        Configuration systemConfig = Resources.getSystem().getConfiguration();
        Locale locale = language.equals("sys") ? Utils.getSystemLocale(systemConfig) : new Locale(language);
        Locale.setDefault(locale);
        Resources resources = context.getResources();
        Configuration config = new Configuration(resources.getConfiguration());
        if (Utils.isAtLeastAndroidVersion(17)) {
            config.setLocale(locale);
            context = context.createConfigurationContext(config);
        } else {
            config.locale = locale;
            resources.updateConfiguration(config, resources.getDisplayMetrics());
        }
        return context;
    }

    @SuppressLint(value={"ApplySharedPref"})
    private void persistLanguage(@NonNull String language) {
        this.mPreferences.edit().putString("userLanguage", language).commit();
    }
}

