/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.Context;
import android.os.Binder;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001d\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0018H\u0002J\u0012\u0010'\u001a\u00020\u00162\b\u0010#\u001a\u0004\u0018\u00010$H\u0007J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u0004H\u0002J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u0004H\u0002J\u0006\u0010,\u001a\u00020\u0018J\u0006\u0010-\u001a\u00020\u001aJ\u0006\u0010.\u001a\u00020\u001aJ\"\u0010/\u001a\u0004\u0018\u00010\u00042\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0004H\u0002J\u000e\u00105\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$J\u0006\u00106\u001a\u00020\u001aJ\u0006\u00107\u001a\u00020\u001eJ\u0006\u00108\u001a\u00020\u001eJ\u000e\u00109\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$J\u0006\u0010:\u001a\u00020\u001eJ\u000e\u0010;\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020\u0018J\u001e\u0010;\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\u00182\u0006\u0010>\u001a\u00020\u0018J\u0006\u0010?\u001a\u00020\u001eJ\u0006\u0010@\u001a\u00020\u001eJ\u0006\u0010A\u001a\u00020\u001eJ\u0006\u0010B\u001a\u00020\u001eJ\u0006\u0010C\u001a\u00020\u001eJ\u0006\u0010D\u001a\u00020\u001eJ\u0006\u0010E\u001a\u00020\u001eJ\u0006\u0010F\u001a\u00020\u001eJ\u0006\u0010G\u001a\u00020\u001eJ\u001b\u0010H\u001a\u00020\u001e2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0002\u00a2\u0006\u0002\u0010JJ\u000e\u0010K\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$J\u0006\u0010L\u001a\u00020\u001eJ\u0006\u0010M\u001a\u00020\u001eJ\u0006\u0010N\u001a\u00020\u001eJ\u0006\u0010O\u001a\u00020\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lando/toolkit/OSUtils;", "", "()V", "BRAND", "", "CPU_FILE_PATH_0", "CPU_FILE_PATH_1", "CPU_FILE_PATH_2", "CPU_FILTER", "Ljava/io/FileFilter;", "ESSENTIAL", "FLYME", "KEY_FLYME_VERSION_NAME", "KEY_MIUI_VERSION_NAME", "MEIZUBOARD", "", "[Ljava/lang/String;", "POWER_PROFILE_CLASS", "TAG", "ZTEC2016", "ZUKZ1", "sBatteryCapacity", "", "sCpuCoreCount", "", "sExtraStorageSize", "", "sFlymeVersionName", "sInnerStorageSize", "sIsTabletChecked", "", "sIsTabletValue", "sMiuiVersionName", "sTotalMemory", "_isTablet", "context", "Landroid/content/Context;", "checkOp", "op", "getBatteryCapacity", "getCoresFromCPUFiles", "path", "getCoresFromFile", "file", "getCpuCoreCount", "getExtraStorageSize", "getInnerStorageSize", "getLowerCaseName", "p", "Ljava/util/Properties;", "get", "Ljava/lang/reflect/Method;", "key", "getTotalMemory", "getTotalStorageSize", "hasExtraStorage", "isEssentialPhone", "isFloatWindowOpAllowed", "isFlyme", "isFlymeLowerThan", "majorVersion", "minorVersion", "patchVersion", "isHuawei", "isMIUI", "isMIUIV5", "isMIUIV6", "isMIUIV7", "isMIUIV8", "isMIUIV9", "isMeizu", "isOppo", "isPhone", "boards", "([Ljava/lang/String;)Z", "isTablet", "isVivo", "isXiaomi", "isZTKC2016", "isZUKZ1", "ando_toolkit_release"})
public final class OSUtils {
    @NotNull
    public static final OSUtils INSTANCE = new OSUtils();
    @NotNull
    private static final String TAG = "QMUIDeviceHelper";
    @NotNull
    private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
    @NotNull
    private static final String KEY_FLYME_VERSION_NAME = "ro.build.display.id";
    @NotNull
    private static final String FLYME = "flyme";
    @NotNull
    private static final String ZTEC2016 = "zte c2016";
    @NotNull
    private static final String ZUKZ1 = "zuk z1";
    @NotNull
    private static final String ESSENTIAL = "essential";
    @NotNull
    private static final String[] MEIZUBOARD;
    @NotNull
    private static final String POWER_PROFILE_CLASS = "com.android.internal.os.PowerProfile";
    @NotNull
    private static final String CPU_FILE_PATH_0 = "/sys/devices/system/cpu/";
    @NotNull
    private static final String CPU_FILE_PATH_1 = "/sys/devices/system/cpu/possible";
    @NotNull
    private static final String CPU_FILE_PATH_2 = "/sys/devices/system/cpu/present";
    @NotNull
    private static final FileFilter CPU_FILTER;
    @Nullable
    private static String sMiuiVersionName;
    @Nullable
    private static String sFlymeVersionName;
    private static boolean sIsTabletChecked;
    private static boolean sIsTabletValue;
    @NotNull
    private static final String BRAND;
    private static long sTotalMemory;
    private static long sInnerStorageSize;
    private static long sExtraStorageSize;
    private static double sBatteryCapacity;
    private static int sCpuCoreCount;

    private OSUtils() {
    }

    private final boolean _isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public final boolean isTablet(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (sIsTabletChecked) {
            return sIsTabletValue;
        }
        sIsTabletValue = this._isTablet(context);
        sIsTabletChecked = true;
        return sIsTabletValue;
    }

    public final boolean isFlyme() {
        CharSequence charSequence = sFlymeVersionName;
        boolean bl = false;
        boolean bl2 = false;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && ((charSequence = sFlymeVersionName) == null ? false : (bl = StringsKt.contains$default((CharSequence)charSequence, (CharSequence)FLYME, (boolean)false, (int)2, null)));
    }

    public final boolean isMIUI() {
        CharSequence charSequence = sMiuiVersionName;
        boolean bl = false;
        boolean bl2 = false;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    public final boolean isMIUIV5() {
        return Intrinsics.areEqual((Object)"v5", (Object)sMiuiVersionName);
    }

    public final boolean isMIUIV6() {
        return Intrinsics.areEqual((Object)"v6", (Object)sMiuiVersionName);
    }

    public final boolean isMIUIV7() {
        return Intrinsics.areEqual((Object)"v7", (Object)sMiuiVersionName);
    }

    public final boolean isMIUIV8() {
        return Intrinsics.areEqual((Object)"v8", (Object)sMiuiVersionName);
    }

    public final boolean isMIUIV9() {
        return Intrinsics.areEqual((Object)"v9", (Object)sMiuiVersionName);
    }

    public final boolean isFlymeLowerThan(int majorVersion) {
        return this.isFlymeLowerThan(majorVersion, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isFlymeLowerThan(int majorVersion, int minorVersion, int patchVersion) {
        boolean isLower = false;
        CharSequence charSequence = sFlymeVersionName;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            try {
                Pattern pattern = Pattern.compile("(\\d+\\.){2}\\d");
                Matcher matcher = pattern.matcher(sFlymeVersionName);
                Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"pattern.matcher(sFlymeVersionName)");
                Matcher matcher2 = matcher;
                if (matcher2.find()) {
                    CharSequence charSequence2 = matcher2.group();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"matcher.group()");
                    String versionString = charSequence2;
                    charSequence2 = versionString;
                    boolean bl3 = false;
                    if (charSequence2.length() > 0) {
                        String[] version;
                        void $this$toTypedArray$iv;
                        Object object = versionString;
                        String string = "\\.";
                        int n = 0;
                        string = new Regex(string);
                        n = 0;
                        boolean bl4 = false;
                        object = string.split((CharSequence)object, n);
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                        if (stringArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        object = version = stringArray;
                        boolean bl5 = false;
                        String[] stringArray2 = object;
                        bl4 = false;
                        if (!(stringArray2.length == 0)) {
                            object = version[0];
                            bl5 = false;
                            if (Integer.parseInt((String)object) < majorVersion) {
                                isLower = true;
                            }
                        }
                        if (version.length >= 2 && minorVersion > 0) {
                            object = version[1];
                            bl5 = false;
                            if (Integer.parseInt((String)object) < majorVersion) {
                                isLower = true;
                            }
                        }
                        if (version.length >= 3 && patchVersion > 0) {
                            object = version[2];
                            bl5 = false;
                            if (Integer.parseInt((String)object) < majorVersion) {
                                isLower = true;
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.isMeizu() && isLower;
    }

    public final boolean isMeizu() {
        return this.isPhone(MEIZUBOARD) || this.isFlyme();
    }

    public final boolean isXiaomi() {
        String string = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MANUFACTURER");
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        boolean bl = false;
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
        return Intrinsics.areEqual((Object)string2, (Object)"xiaomi");
    }

    public final boolean isVivo() {
        return StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"vivo", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"bbk", (boolean)false, (int)2, null);
    }

    public final boolean isOppo() {
        return StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"oppo", (boolean)false, (int)2, null);
    }

    public final boolean isHuawei() {
        return StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"huawei", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"honor", (boolean)false, (int)2, null);
    }

    public final boolean isEssentialPhone() {
        return StringsKt.contains$default((CharSequence)BRAND, (CharSequence)ESSENTIAL, (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isZUKZ1() {
        String board = Build.MODEL;
        if (board == null) return false;
        String string = board;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        boolean bl = false;
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)ZUKZ1, (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isZTKC2016() {
        String board = Build.MODEL;
        if (board == null) return false;
        String string = board;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        boolean bl = false;
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)ZTEC2016, (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final boolean isPhone(String[] boards) {
        String[] stringArray = Build.BOARD;
        if (stringArray == null) {
            return false;
        }
        String[] board = stringArray;
        for (String board1 : boards) {
            if (!Intrinsics.areEqual((Object)board, (Object)board1)) continue;
            return true;
        }
        return false;
    }

    public final long getTotalMemory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (sTotalMemory != -1L) {
            return sTotalMemory;
        }
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager activityManager = (ActivityManager)object;
        activityManager.getMemoryInfo(memoryInfo);
        sTotalMemory = memoryInfo.totalMem;
        return sTotalMemory;
    }

    public final long getInnerStorageSize() {
        if (sInnerStorageSize != -1L) {
            return sInnerStorageSize;
        }
        File file = Environment.getDataDirectory();
        if (file == null) {
            return 0L;
        }
        File dataDir = file;
        sInnerStorageSize = dataDir.getTotalSpace();
        return sInnerStorageSize;
    }

    public final boolean hasExtraStorage() {
        return Intrinsics.areEqual((Object)"mounted", (Object)Environment.getExternalStorageState());
    }

    public final long getExtraStorageSize() {
        if (sExtraStorageSize != -1L) {
            return sExtraStorageSize;
        }
        if (!this.hasExtraStorage()) {
            return 0L;
        }
        File path = Environment.getExternalStorageDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSizeLong();
        long availableBlocks = stat.getBlockCountLong();
        sExtraStorageSize = blockSize * availableBlocks;
        return sExtraStorageSize;
    }

    public final long getTotalStorageSize() {
        return this.getInnerStorageSize() + this.getExtraStorageSize();
    }

    public final int getCpuCoreCount() {
        if (sCpuCoreCount != -1) {
            return sCpuCoreCount;
        }
        int cores = 0;
        try {
            cores = this.getCoresFromFile(CPU_FILE_PATH_1);
            if (cores == 0) {
                cores = this.getCoresFromFile(CPU_FILE_PATH_2);
            }
            if (cores == 0) {
                cores = this.getCoresFromCPUFiles(CPU_FILE_PATH_0);
            }
        }
        catch (Exception e) {
            cores = 0;
        }
        if (cores == 0) {
            cores = 1;
        }
        sCpuCoreCount = cores;
        return cores;
    }

    private final int getCoresFromCPUFiles(String path) {
        int n;
        File[] list = new File(path).listFiles(CPU_FILTER);
        File[] fileArray = list;
        return fileArray == null ? 0 : (n = fileArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int getCoresFromFile(String file) {
        int n;
        Object fileContents;
        InputStream ins;
        block9: {
            int n2;
            Object object;
            block8: {
                ins = null;
                try {
                    int n3;
                    block11: {
                        block10: {
                            ins = new FileInputStream(file);
                            BufferedReader buf = new BufferedReader(new InputStreamReader(ins, StandardCharsets.UTF_8));
                            fileContents = buf.readLine();
                            buf.close();
                            if (fileContents == null) break block10;
                            CharSequence charSequence = (CharSequence)fileContents;
                            object = new Regex("0-[\\d]+$");
                            n3 = 0;
                            if (object.matches(charSequence)) break block11;
                        }
                        n2 = 0;
                        object = ins;
                        break block8;
                    }
                    object = fileContents;
                    n3 = 2;
                    boolean bl = false;
                    String string = ((String)object).substring(n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                    String num = string;
                    object = num;
                    n3 = 0;
                    n = Integer.parseInt((String)object) + 1;
                    fileContents = ins;
                    break block9;
                }
                catch (IOException e) {
                    n = 0;
                    return n;
                }
            }
            ((InputStream)object).close();
            return n2;
        }
        ((InputStream)fileContents).close();
        return n;
        finally {
            InputStream inputStream = ins;
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public final boolean isFloatWindowOpAllowed(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.checkOp(context, 24);
    }

    @SuppressLint(value={"PrivateApi"})
    public final double getBatteryCapacity(@Nullable Context context) {
        double ret;
        double d;
        if (!(sBatteryCapacity == -1.0)) {
            return sBatteryCapacity;
        }
        try {
            Class<?> cls = Class.forName(POWER_PROFILE_CLASS);
            Object[] objectArray = new Class[]{Context.class};
            Constructor<?> constructor = cls.getConstructor((Class<?>[])objectArray);
            objectArray = new Object[]{context};
            Object instance = constructor.newInstance(objectArray);
            Method method = cls.getMethod("getBatteryCapacity", new Class[0]);
            Object object = method.invoke(instance, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
            }
            d = (Double)object;
        }
        catch (Exception ignore) {
            d = -1.0;
        }
        sBatteryCapacity = ret = d;
        return sBatteryCapacity;
    }

    private final boolean checkOp(Context context, int op) {
        Object object = context.getSystemService("appops");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.AppOpsManager");
        }
        AppOpsManager manager = (AppOpsManager)object;
        try {
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, String.class};
            Method method = manager.getClass().getDeclaredMethod("checkOp", classArray);
            Object[] objectArray = new Object[]{op, Binder.getCallingUid(), context.getPackageName()};
            Object object2 = method.invoke((Object)manager, objectArray);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            int property = (Integer)object2;
            return property == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private final String getLowerCaseName(Properties p, Method get, String key) {
        Object object;
        Object[] objectArray;
        String name = p.getProperty(key);
        if (name == null) {
            try {
                objectArray = new Object[]{key};
                object = get.invoke(null, objectArray);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                name = (String)object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (name != null) {
            object = name;
            objectArray = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getDefault()");
            boolean bl = false;
            String string = ((String)object).toLowerCase((Locale)objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase(locale)");
            name = string;
        }
        return name;
    }

    private static final boolean CPU_FILTER$lambda-0(File pathname) {
        return Pattern.matches("cpu[0-9]", pathname.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        Object object = new String[]{"m9", "M9", "mx", "MX"};
        MEIZUBOARD = object;
        CPU_FILTER = OSUtils::CPU_FILTER$lambda-0;
        object = Build.BRAND;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"BRAND");
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        boolean bl = false;
        String string = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase(locale)");
        BRAND = string;
        sTotalMemory = -1L;
        sInnerStorageSize = -1L;
        sExtraStorageSize = -1L;
        sBatteryCapacity = -1.0;
        sCpuCoreCount = -1;
        Properties properties = new Properties();
        if (Build.VERSION.SDK_INT < 26) {
            FileInputStream fileInputStream;
            FileInputStream fileInputStream2 = null;
            try {
                fileInputStream2 = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
                properties.load(fileInputStream2);
                fileInputStream = fileInputStream2;
            }
            catch (Exception exception) {
                FileInputStream fileInputStream3 = fileInputStream2;
                if (fileInputStream3 != null) {
                    fileInputStream3.close();
                }
                catch (Throwable throwable) {
                    FileInputStream fileInputStream4 = fileInputStream2;
                    if (fileInputStream4 != null) {
                        fileInputStream4.close();
                    }
                    throw throwable;
                }
            }
            fileInputStream.close();
        }
        Class<?> clzSystemProperties = null;
        try {
            clzSystemProperties = Class.forName("android.os.SystemProperties");
            Class[] classArray = new Class[]{String.class};
            Method getMethod = clzSystemProperties.getDeclaredMethod("get", classArray);
            Intrinsics.checkNotNullExpressionValue((Object)getMethod, (String)"getMethod");
            sMiuiVersionName = INSTANCE.getLowerCaseName(properties, getMethod, KEY_MIUI_VERSION_NAME);
            sFlymeVersionName = INSTANCE.getLowerCaseName(properties, getMethod, KEY_FLYME_VERSION_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

