/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.core.app.NotificationManagerCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\t"}, d2={"Lando/toolkit/NotifyUtils;", "", "()V", "isNotificationEnabled", "", "context", "Landroid/content/Context;", "openNotifyPermissionSetting", "", "ando_toolkit_release"})
public final class NotifyUtils {
    @NotNull
    public static final NotifyUtils INSTANCE = new NotifyUtils();

    private NotifyUtils() {
    }

    public final boolean isNotificationEnabled(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)notificationManagerCompat, (String)"from(context)");
        NotificationManagerCompat manager = notificationManagerCompat;
        return Build.VERSION.SDK_INT >= 26 ? manager.areNotificationsEnabled() && manager.getImportance() != 0 : manager.areNotificationsEnabled();
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public final void openNotifyPermissionSetting(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            Intent intent = new Intent();
            intent.addFlags(0x10000000);
            if (Build.VERSION.SDK_INT >= 26) {
                intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
                intent.putExtra("android.provider.extra.CHANNEL_ID", context.getApplicationInfo().uid);
                context.startActivity(intent);
                return;
            }
            if (Build.VERSION.SDK_INT >= 21) {
                intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                intent.putExtra("app_package", context.getPackageName());
                intent.putExtra("app_uid", context.getApplicationInfo().uid);
                context.startActivity(intent);
                return;
            }
            if (Build.VERSION.SDK_INT == 19) {
                intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                intent.addCategory("android.intent.category.DEFAULT");
                intent.setData(Uri.parse((String)Intrinsics.stringPlus((String)"package:", (Object)context.getPackageName())));
                context.startActivity(intent);
                return;
            }
            if (Build.VERSION.SDK_INT >= 9) {
                intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                intent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
                context.startActivity(intent);
                return;
            }
            intent.setAction("android.intent.action.VIEW");
            intent.setClassName("com.android.settings", "com.android.setting.InstalledAppDetails");
            intent.putExtra("com.android.settings.ApplicationPkgName", context.getPackageName());
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

