/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lando/toolkit/ProcessUtils;", "", "()V", "currentProcessNameByFile", "", "getCurrentProcessNameByFile", "()Ljava/lang/String;", "getCurrentProcessName", "context", "Landroid/content/Context;", "getCurrentProcessNameByAms", "getCurrentProcessNameByReflect", "ando_toolkit_release"})
public final class ProcessUtils {
    @NotNull
    public static final ProcessUtils INSTANCE;

    @Nullable
    public final String getCurrentProcessName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String name = this.getCurrentProcessNameByFile();
        if (!TextUtils.isEmpty((CharSequence)name)) {
            return name;
        }
        name = this.getCurrentProcessNameByAms(context);
        if (!TextUtils.isEmpty((CharSequence)name)) {
            return name;
        }
        name = this.getCurrentProcessNameByReflect(context);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final String getCurrentProcessNameByFile() {
        block17: {
            reader = null;
            try {
                file = new File("/proc/" + Process.myPid() + "/" + "cmdline");
                reader = new BufferedReader(new FileReader(file));
                processName = reader.readLine();
                if (!TextUtils.isEmpty((CharSequence)processName)) {
                    v0 = processName;
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"processName");
                    $this$trim$iv = v0;
                    $i$f$trim = false;
                    $this$trim$iv$iv = $this$trim$iv;
                    $i$f$trim = false;
                    startIndex$iv$iv = 0;
                    endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        index$iv$iv = startFound$iv$iv == false ? startIndex$iv$iv : endIndex$iv$iv;
                        it = $this$trim$iv$iv.charAt(index$iv$iv);
                        $i$a$-trim-ProcessUtils$currentProcessNameByFile$1 = false;
                        v1 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    v2 = $this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1).toString();
                } else {
                    v2 = "";
                }
                var2_2 = v2;
                ** try [egrp 1[TRYBLOCK] [0 : 234->242)] { 
            }
            catch (Exception e) {
                e.printStackTrace();
                var2_2 = "";
                break block17;
            }
            finally {
                try {
                    v3 = reader;
                    if (v3 != null) {
                        v3.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
lbl-1000:
            // 1 sources

            {
                reader.close();
            }
lbl39:
            // 1 sources

            catch (IOException e) {
                e.printStackTrace();
            }
            {
            }
        }
        return var2_2;
    }

    private final String getCurrentProcessNameByAms(Context context) {
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager activityManager = (ActivityManager)object;
        if (activityManager == null) {
            return "";
        }
        ActivityManager am = activityManager;
        List info = am.getRunningAppProcesses();
        if (info == null || info.size() == 0) {
            return "";
        }
        int pid = Process.myPid();
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            if (aInfo.pid != pid || aInfo.processName == null) continue;
            String string = aInfo.processName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"aInfo.processName");
            return string;
        }
        return "";
    }

    private final String getCurrentProcessNameByReflect(Context context) {
        String processName = "";
        try {
            Field loadedApkField;
            Context context2 = context.getApplicationContext();
            if (context2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.Application");
            }
            Application app = (Application)context2;
            Field field = loadedApkField = app.getClass().getField("mLoadedApk");
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"loadedApkField");
            field.setAccessible(true);
            Object loadedApk = loadedApkField.get(app);
            Field activityThreadField = null;
            if (loadedApk != null) {
                Field field2 = activityThreadField = loadedApk.getClass().getDeclaredField("mActivityThread");
                Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"activityThreadField");
                field2.setAccessible(true);
                Object activityThread = activityThreadField.get(loadedApk);
                Method getProcessName = null;
                if (activityThread != null) {
                    getProcessName = activityThread.getClass().getDeclaredMethod("getProcessName", new Class[0]);
                    Object object = getProcessName.invoke(activityThread, new Object[0]);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    processName = (String)object;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processName;
    }

    private ProcessUtils() {
    }

    static {
        ProcessUtils processUtils;
        INSTANCE = processUtils = new ProcessUtils();
    }
}

