/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit.immersion;

import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0016\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bJ \u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0016\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0004J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0016\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u000bJ\u0016\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lando/toolkit/immersion/FlymeStatusBar;", "", "()V", "SYSTEM_UI_FLAG_LIGHT_STATUS_BAR", "", "mSetStatusBarColorIcon", "Ljava/lang/reflect/Method;", "mSetStatusBarDarkIcon", "mStatusBarColorFiled", "Ljava/lang/reflect/Field;", "changeMeizuFlag", "", "winParams", "Landroid/view/WindowManager$LayoutParams;", "flagName", "", "on", "isBlackColor", "color", "level", "setStatusBarColor", "", "window", "Landroid/view/Window;", "setStatusBarDarkIcon", "activity", "Landroid/app/Activity;", "dark", "flag", "view", "Landroid/view/View;", "toGrey", "rgb", "ando_toolkit_release"})
public final class FlymeStatusBar {
    private static Method mSetStatusBarColorIcon;
    private static Method mSetStatusBarDarkIcon;
    private static Field mStatusBarColorFiled;
    private static int SYSTEM_UI_FLAG_LIGHT_STATUS_BAR;
    @NotNull
    public static final FlymeStatusBar INSTANCE;

    public final boolean isBlackColor(int color, int level) {
        return this.toGrey(color) < level;
    }

    public final int toGrey(int rgb) {
        int blue = rgb & 0xFF;
        int green = (rgb & 0xFF00) >> 8;
        int red = (rgb & 0xFF0000) >> 16;
        return red * 38 + green * 75 + blue * 15 >> 7;
    }

    public final void setStatusBarDarkIcon(@NotNull Activity activity, int color) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (mSetStatusBarColorIcon != null) {
            try {
                Method method = mSetStatusBarColorIcon;
                if (method != null) {
                    method.invoke((Object)activity, color);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else {
            boolean whiteColor = this.isBlackColor(color, 50);
            if (mStatusBarColorFiled != null) {
                this.setStatusBarDarkIcon(activity, whiteColor, whiteColor);
                Window window = activity.getWindow();
                Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
                this.setStatusBarDarkIcon(window, color);
            } else {
                this.setStatusBarDarkIcon(activity, whiteColor);
            }
        }
    }

    public final void setStatusBarDarkIcon(@NotNull Window window, int color) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        try {
            this.setStatusBarColor(window, color);
            if (Build.VERSION.SDK_INT > 22) {
                View view = window.getDecorView();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
                this.setStatusBarDarkIcon(view, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void setStatusBarDarkIcon(@NotNull Activity activity, boolean dark) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.setStatusBarDarkIcon(activity, dark, true);
    }

    private final boolean changeMeizuFlag(WindowManager.LayoutParams winParams, String flagName, boolean on) {
        try {
            int meizuFlags;
            Field f2;
            Field f;
            Field field = f = winParams.getClass().getDeclaredField(flagName);
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"f");
            field.setAccessible(true);
            int bits = f.getInt(winParams);
            Field field2 = f2 = winParams.getClass().getDeclaredField("meizuFlags");
            Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"f2");
            field2.setAccessible(true);
            int oldFlags = meizuFlags = f2.getInt(winParams);
            int n = meizuFlags = on ? meizuFlags | bits : meizuFlags & ~bits;
            if (oldFlags != meizuFlags) {
                f2.setInt(winParams, meizuFlags);
                return true;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private final void setStatusBarDarkIcon(View view, boolean dark) {
        int oldVis;
        int newVis = oldVis = view.getSystemUiVisibility();
        int n = newVis = dark ? newVis | SYSTEM_UI_FLAG_LIGHT_STATUS_BAR : newVis & ~SYSTEM_UI_FLAG_LIGHT_STATUS_BAR;
        if (newVis != oldVis) {
            view.setSystemUiVisibility(newVis);
        }
    }

    private final void setStatusBarColor(Window window, int color) {
        WindowManager.LayoutParams winParams = window.getAttributes();
        if (mStatusBarColorFiled != null) {
            try {
                Integer oldColor;
                Field field = mStatusBarColorFiled;
                Integer n = oldColor = field != null ? Integer.valueOf(field.getInt(winParams)) : null;
                if (n == null || n != color) {
                    Field field2 = mStatusBarColorFiled;
                    if (field2 != null) {
                        field2.set(winParams, color);
                    }
                    window.setAttributes(winParams);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public final void setStatusBarDarkIcon(@NotNull Window window, boolean dark) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (Build.VERSION.SDK_INT < 23) {
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)layoutParams, (String)"window.attributes");
            this.changeMeizuFlag(layoutParams, "MEIZU_FLAG_DARK_STATUS_BAR_ICON", dark);
        } else {
            View decorView;
            View view = decorView = window.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"decorView");
            this.setStatusBarDarkIcon(view, dark);
            this.setStatusBarColor(window, 0);
        }
    }

    private final void setStatusBarDarkIcon(Activity activity, boolean dark, boolean flag) {
        if (mSetStatusBarDarkIcon != null) {
            try {
                Method method = mSetStatusBarDarkIcon;
                if (method != null) {
                    method.invoke((Object)activity, dark);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else if (flag) {
            Window window = activity.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
            this.setStatusBarDarkIcon(window, dark);
        }
    }

    private FlymeStatusBar() {
    }

    static {
        FlymeStatusBar flymeStatusBar;
        INSTANCE = flymeStatusBar = new FlymeStatusBar();
        try {
            mSetStatusBarColorIcon = Activity.class.getMethod("setStatusBarDarkIcon", Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            mSetStatusBarDarkIcon = Activity.class.getMethod("setStatusBarDarkIcon", Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            mStatusBarColorFiled = WindowManager.LayoutParams.class.getField("statusBarColor");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        try {
            Field field = View.class.getField("SYSTEM_UI_FLAG_LIGHT_STATUS_BAR");
            SYSTEM_UI_FLAG_LIGHT_STATUS_BAR = field.getInt(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }
}

