/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit.ext;

import android.app.Activity;
import android.content.res.Resources;
import android.graphics.Rect;
import android.view.Window;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lando/toolkit/ext/DimensionUtils;", "", "()V", "getNavBarHeight", "", "getStatusBarHeight", "getStatusBarHeightDecor", "activity", "Landroid/app/Activity;", "ando_toolkit_release"})
public final class DimensionUtils {
    @NotNull
    public static final DimensionUtils INSTANCE;

    public final int getNavBarHeight() {
        Resources res = Resources.getSystem();
        int resourceId = res.getIdentifier("navigation_bar_height", "dimen", "android");
        return resourceId != 0 ? res.getDimensionPixelSize(resourceId) : 0;
    }

    public final int getStatusBarHeight() {
        Resources res = Resources.getSystem();
        int resourceId = res.getIdentifier("status_bar_height", "dimen", "android");
        return resourceId > 0 ? res.getDimensionPixelSize(resourceId) : 0;
    }

    public final int getStatusBarHeightDecor(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Rect localRect = new Rect();
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        window.getDecorView().getWindowVisibleDisplayFrame(localRect);
        return localRect.top;
    }

    private DimensionUtils() {
    }

    static {
        DimensionUtils dimensionUtils;
        INSTANCE = dimensionUtils = new DimensionUtils();
    }
}

