/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import android.os.storage.StorageManager;
import android.text.TextUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lando/toolkit/UsbUtils;", "", "()V", "getStoragePaths", "", "", "cxt", "Landroid/content/Context;", "(Landroid/content/Context;)[Ljava/lang/String;", "ando_toolkit_release"})
public final class UsbUtils {
    @NotNull
    public static final UsbUtils INSTANCE;

    @NotNull
    public final String[] getStoragePaths(@NotNull Context cxt) {
        List pathsList;
        block7: {
            Intrinsics.checkNotNullParameter((Object)cxt, (String)"cxt");
            pathsList = new ArrayList();
            Object object = cxt.getSystemService("storage");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.os.storage.StorageManager");
            }
            StorageManager storageManager = (StorageManager)object;
            try {
                Method method;
                Method method2 = method = StorageManager.class.getDeclaredMethod("getVolumePaths", new Class[0]);
                Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
                method2.setAccessible(true);
                Object result = method.invoke((Object)storageManager, new Object[0]);
                if (result instanceof Object[]) {
                    StatFs statFs = null;
                    Object[] objectArray = (Object[])result;
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        Object r;
                        Object object2 = r = objectArray[i];
                        if (object2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        String path = (String)object2;
                        if (TextUtils.isEmpty((CharSequence)path) || !new File(path).exists() || (statFs = new StatFs(path)).getBlockCount() * statFs.getBlockSize() == 0) continue;
                        pathsList.add(path);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                File externalFolder = Environment.getExternalStorageDirectory();
                if (externalFolder == null) break block7;
                String string = externalFolder.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"externalFolder.absolutePath");
                pathsList.add(string);
            }
        }
        Collection $this$toTypedArray$iv = pathsList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    private UsbUtils() {
    }

    static {
        UsbUtils usbUtils;
        INSTANCE = usbUtils = new UsbUtils();
    }
}

