/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.ArrayRes;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u0004J\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0004J\u001c\u0010\u000f\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0001\u0010\f\u001a\u00020\u0004H\u0007J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u0012\u001a\u00020\u0004J\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0005\u001a\u00020\u0004J)\u0010\u0019\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u001b\u001a\u0002H\u001a2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u0002H\u001a\u0018\u00010\u001d\u00a2\u0006\u0002\u0010\u001eJ \u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\tJ\"\u0010\"\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010#\u001a\u00020\u00042\b\b\u0002\u0010!\u001a\u00020\u0018J\u001a\u0010$\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010#\u001a\u00020\u0004H\u0007J\"\u0010$\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010#\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0007J\"\u0010%\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010#\u001a\u00020\u00042\b\b\u0002\u0010!\u001a\u00020\u0004J\u001a\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010#\u001a\u00020\u0004J&\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010#\u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010'H\u0002J\u0016\u0010(\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0004J\u001e\u0010(\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0007J \u0010)\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00042\b\b\u0002\u0010\u0015\u001a\u00020\u0004J\u0018\u0010*\u001a\u00020+2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010#\u001a\u00020\u0004J\u001c\u0010*\u001a\u00020+2\n\u0010,\u001a\u00060-R\u00020.2\b\b\u0001\u0010#\u001a\u00020\u0004J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010'\u00a8\u00064"}, d2={"Lando/toolkit/ThemeUtils;", "", "()V", "adjustAlpha", "", "color", "factor", "", "getActionTextColorStateList", "Landroid/content/res/ColorStateList;", "context", "Landroid/content/Context;", "colorId", "getActionTextStateList", "newPrimaryColor", "getColor", "getColorArray", "", "array", "getColorFromAttrRes", "attrRes", "defaultValue", "getDisabledColor", "isColorDark", "", "isIn", "T", "find", "ary", "", "(Ljava/lang/Object;[Ljava/lang/Object;)Z", "resolveActionTextColorStateList", "colorAttr", "fallback", "resolveBoolean", "attr", "resolveColor", "resolveDimension", "resolveDrawable", "Landroid/graphics/drawable/Drawable;", "resolveFloat", "resolveInt", "resolveString", "", "theme", "Landroid/content/res/Resources$Theme;", "Landroid/content/res/Resources;", "setBackgroundCompat", "", "view", "Landroid/view/View;", "d", "ando_toolkit_release"})
public final class ThemeUtils {
    @NotNull
    public static final ThemeUtils INSTANCE;

    @ColorInt
    public final int getDisabledColor(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int primaryColor = this.resolveColor(context, 16842806);
        int disabledColor = this.isColorDark(primaryColor) ? -16777216 : -1;
        return this.adjustAlpha(disabledColor, 0.3f);
    }

    @ColorInt
    public final int adjustAlpha(@ColorInt int color, float factor) {
        int alpha = MathKt.roundToInt((float)((float)Color.alpha((int)color) * factor));
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    @ColorInt
    public final int resolveColor(@NotNull Context context, @AttrRes int attr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.resolveColor(context, attr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ColorInt
    public final int resolveColor(@NotNull Context context, @AttrRes int attr, int fallback) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr});
        try {
            n = a.getColor(0, fallback);
        }
        finally {
            a.recycle();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getColorFromAttrRes(int attrRes, int defaultValue, @NotNull Context context) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TypedArray a = context.obtainStyledAttributes(new int[]{attrRes});
        try {
            n = a.getColor(0, defaultValue);
        }
        finally {
            a.recycle();
        }
        return n;
    }

    public final float resolveFloat(@NotNull Context context, int attrRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(attrRes, typedValue, true);
        return typedValue.getFloat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int resolveInt(@NotNull Context context, int attrRes, int defaultValue) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TypedArray a = context.obtainStyledAttributes(new int[]{attrRes});
        try {
            n = a.getInt(0, defaultValue);
        }
        finally {
            a.recycle();
        }
        return n;
    }

    public static /* synthetic */ int resolveInt$default(ThemeUtils themeUtils, Context context, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return themeUtils.resolveInt(context, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float resolveFloat(@NotNull Context context, int attrRes, float defaultValue) {
        float f;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TypedArray a = context.obtainStyledAttributes(new int[]{attrRes});
        try {
            f = a.getFloat(0, defaultValue);
        }
        finally {
            a.recycle();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ColorStateList resolveActionTextColorStateList(@NotNull Context context, @AttrRes int colorAttr, @NotNull ColorStateList fallback) {
        ColorStateList colorStateList;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{colorAttr});
        try {
            ColorStateList colorStateList2;
            TypedValue typedValue;
            if (a.peekValue(0) == null) {
                ColorStateList colorStateList3 = fallback;
                return colorStateList3;
            }
            TypedValue value = typedValue;
            if (value.type >= 28 && value.type <= 31) {
                colorStateList2 = this.getActionTextStateList(context, value.data);
            } else {
                ColorStateList stateList = a.getColorStateList(0);
                colorStateList2 = stateList;
                if (colorStateList2 == null) {
                    colorStateList2 = fallback;
                }
            }
            colorStateList = colorStateList2;
        }
        finally {
            a.recycle();
        }
        return colorStateList;
    }

    @NotNull
    public final ColorStateList getActionTextColorStateList(@NotNull Context context, @ColorRes int colorId) {
        ColorStateList colorStateList;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TypedValue value = new TypedValue();
        context.getResources().getValue(colorId, value, true);
        if (value.type >= 28 && value.type <= 31) {
            colorStateList = this.getActionTextStateList(context, value.data);
        } else {
            ColorStateList colorStateList2 = Build.VERSION.SDK_INT <= 22 ? context.getResources().getColorStateList(colorId) : context.getColorStateList(colorId);
            colorStateList = colorStateList2;
            Intrinsics.checkNotNullExpressionValue((Object)colorStateList2, (String)"if (Build.VERSION.SDK_IN\u2026st(colorId)\n            }");
        }
        return colorStateList;
    }

    @ColorInt
    public final int getColor(@Nullable Context context, @ColorRes int colorId) {
        int n;
        Context context2 = context;
        if (context2 != null) {
            Context context3 = context2;
            boolean bl = false;
            boolean bl2 = false;
            Context it = context3;
            boolean bl3 = false;
            n = ContextCompat.getColor((Context)it, (int)colorId);
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public final String resolveString(@NotNull Context context, @AttrRes int attr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TypedValue v = new TypedValue();
        context.getTheme().resolveAttribute(attr, v, true);
        CharSequence charSequence = v.string;
        if (charSequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        return (String)charSequence;
    }

    @NotNull
    public final String resolveString(@NotNull Resources.Theme theme, @AttrRes int attr) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        TypedValue v = new TypedValue();
        theme.resolveAttribute(attr, v, true);
        CharSequence charSequence = v.string;
        if (charSequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        return (String)charSequence;
    }

    @Nullable
    public final Drawable resolveDrawable(@NotNull Context context, @AttrRes int attr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.resolveDrawable(context, attr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Drawable resolveDrawable(Context context, @AttrRes int attr, Drawable fallback) {
        Drawable drawable;
        TypedArray array = context.getTheme().obtainStyledAttributes(new int[]{attr});
        try {
            Drawable drawable2 = null;
            if (Build.VERSION.SDK_INT >= 21) {
                drawable2 = array.getDrawable(0);
            } else {
                int id2 = array.getResourceId(0, -1);
                if (id2 != -1) {
                    drawable2 = AppCompatResources.getDrawable((Context)context, (int)id2);
                }
            }
            if (drawable2 == null && fallback != null) {
                drawable2 = fallback;
            }
            drawable = drawable2;
        }
        finally {
            array.recycle();
        }
        return drawable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int resolveDimension(@NotNull Context context, @AttrRes int attr, int fallback) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr});
        try {
            n = a.getDimensionPixelSize(0, fallback);
        }
        finally {
            a.recycle();
        }
        return n;
    }

    public static /* synthetic */ int resolveDimension$default(ThemeUtils themeUtils, Context context, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        return themeUtils.resolveDimension(context, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean resolveBoolean(@NotNull Context context, @AttrRes int attr, boolean fallback) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr});
        try {
            bl = a.getBoolean(0, fallback);
        }
        finally {
            a.recycle();
        }
        return bl;
    }

    public static /* synthetic */ boolean resolveBoolean$default(ThemeUtils themeUtils, Context context, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return themeUtils.resolveBoolean(context, n, bl);
    }

    public final boolean isColorDark(@ColorInt int color) {
        double darkness = 1.0 - (0.299 * (double)Color.red((int)color) + 0.587 * (double)Color.green((int)color) + 0.114 * (double)Color.blue((int)color)) / (double)255;
        return darkness >= 0.5;
    }

    public final void setBackgroundCompat(@NotNull View view, @Nullable Drawable d) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(d);
        } else {
            view.setBackground(d);
        }
    }

    @NotNull
    public final ColorStateList getActionTextStateList(@NotNull Context context, int newPrimaryColor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int color = newPrimaryColor;
        int fallBackButtonColor = this.resolveColor(context, 16842806);
        if (color == 0) {
            color = fallBackButtonColor;
        }
        int[][] states = new int[][]{{-16842910}, new int[0]};
        int[] colors = new int[]{this.adjustAlpha(color, 0.4f), color};
        return new ColorStateList(states, colors);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final int[] getColorArray(@NotNull Context context, @ArrayRes int array) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (array == 0) {
            return null;
        }
        TypedArray ta = context.getResources().obtainTypedArray(array);
        int[] colors = new int[ta.length()];
        int n = 0;
        int n2 = ta.length();
        while (n < n2) {
            void i;
            colors[i] = ta.getColor((int)i, 0);
            ++i;
        }
        ta.recycle();
        return colors;
    }

    public final <T> boolean isIn(T find, @Nullable T[] ary) {
        block4: {
            block3: {
                if (ary == null) break block3;
                T[] TArray = ary;
                int n = 0;
                if (!(TArray.length == 0)) break block4;
            }
            return false;
        }
        for (T item : ary) {
            if (!Intrinsics.areEqual(item, find)) continue;
            return true;
        }
        return false;
    }

    private ThemeUtils() {
    }

    static {
        ThemeUtils themeUtils;
        INSTANCE = themeUtils = new ThemeUtils();
    }
}

