/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;

public class FixedCountDownTimer {
    private static final long SECOND_MILLIS = 1000L;
    private final long mMillisInFuture;
    private final long mCountdownInterval;
    private long mStopTimeInFuture;
    private long mMillisUntilFinished;
    private boolean mCancelled = false;
    private boolean mPaused = false;
    private boolean mIsRunning = false;
    private Listener mListener;
    private static final int MSG = 1;
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            FixedCountDownTimer fixedCountDownTimer = FixedCountDownTimer.this;
            synchronized (fixedCountDownTimer) {
                if (FixedCountDownTimer.this.mCancelled) {
                    return;
                }
                if (FixedCountDownTimer.this.mPaused) {
                    this.removeMessages(1);
                    return;
                }
                long millisLeft = FixedCountDownTimer.this.mStopTimeInFuture - SystemClock.elapsedRealtime();
                if (millisLeft <= 0L) {
                    FixedCountDownTimer.this.onFinish();
                } else {
                    long delay;
                    long lastTickStart = SystemClock.elapsedRealtime();
                    FixedCountDownTimer.this.onTick(millisLeft);
                    long lastTickDuration = SystemClock.elapsedRealtime() - lastTickStart;
                    if (millisLeft < FixedCountDownTimer.this.mCountdownInterval) {
                        delay = millisLeft - lastTickDuration;
                        if (delay < 0L) {
                            delay = 0L;
                        }
                    } else {
                        for (delay = FixedCountDownTimer.this.mCountdownInterval - lastTickDuration; delay < 0L; delay += FixedCountDownTimer.this.mCountdownInterval) {
                        }
                    }
                    this.sendMessageDelayed(this.obtainMessage(1), delay);
                }
            }
        }
    };

    public FixedCountDownTimer(long millisInFuture, long countDownInterval) {
        this.mMillisInFuture = millisInFuture;
        this.mCountdownInterval = countDownInterval;
    }

    public void setListener(Listener l) {
        this.mListener = l;
    }

    public final synchronized FixedCountDownTimer start() {
        this.mCancelled = false;
        if (this.mMillisInFuture <= 0L) {
            this.onFinish();
            return this;
        }
        this.mStopTimeInFuture = SystemClock.elapsedRealtime() + this.mMillisInFuture;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
        this.mIsRunning = true;
        this.mPaused = false;
        return this;
    }

    public final synchronized void pause() {
        this.mMillisUntilFinished = this.mStopTimeInFuture - SystemClock.elapsedRealtime();
        this.mIsRunning = false;
        this.mPaused = true;
    }

    public synchronized long resume() {
        this.mStopTimeInFuture = SystemClock.elapsedRealtime() + this.mMillisUntilFinished;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
        this.mIsRunning = true;
        this.mPaused = false;
        return this.mMillisUntilFinished;
    }

    public final synchronized void cancel() {
        this.mHandler.removeMessages(1);
        this.mCancelled = true;
        this.mIsRunning = false;
        this.mPaused = false;
    }

    private void onTick(long millisUntilFinished) {
        if (this.mListener != null) {
            long fixedMillisUntilFinished = millisUntilFinished + (1000L - millisUntilFinished % 1000L);
            Log.w((String)"123", (String)("millisUntilFinished=" + millisUntilFinished + "; fixedMillisUntilFinished=" + fixedMillisUntilFinished));
            this.mListener.onTick(fixedMillisUntilFinished);
        }
    }

    private void onFinish() {
        this.mIsRunning = false;
        if (this.mListener != null) {
            this.mListener.onFinish();
        }
    }

    public boolean isPaused() {
        return this.mPaused;
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    public static interface Listener {
        public void onTick(long var1);

        public void onFinish();
    }
}

