/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import ando.toolkit.AppUtils;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.Intent;
import android.net.Uri;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\b\u0010\r\u001a\u0004\u0018\u00010\u0006J\b\u0010\u000e\u001a\u0004\u0018\u00010\tJ\b\u0010\u000f\u001a\u0004\u0018\u00010\f\u00a8\u0006\u0010"}, d2={"Lando/toolkit/ClipboardUtils;", "", "()V", "copyIntent", "", "intent", "Landroid/content/Intent;", "copyText", "text", "", "copyUri", "uri", "Landroid/net/Uri;", "getIntent", "getText", "getUri", "ando_toolkit_release"})
public final class ClipboardUtils {
    @NotNull
    public static final ClipboardUtils INSTANCE;

    public final void copyText(@Nullable CharSequence text) {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("clipboard");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager cm = (ClipboardManager)object;
        cm.setPrimaryClip(ClipData.newPlainText((CharSequence)"text", (CharSequence)text));
    }

    @Nullable
    public final CharSequence getText() {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("clipboard");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager cm = (ClipboardManager)object;
        ClipData clip = cm.getPrimaryClip();
        return clip != null && clip.getItemCount() > 0 ? clip.getItemAt(0).coerceToText(AppUtils.INSTANCE.getContext()) : null;
    }

    public final void copyUri(@Nullable Uri uri) {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("clipboard");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager cm = (ClipboardManager)object;
        cm.setPrimaryClip(ClipData.newUri((ContentResolver)AppUtils.INSTANCE.getContext().getContentResolver(), (CharSequence)"uri", (Uri)uri));
    }

    @Nullable
    public final Uri getUri() {
        Uri uri;
        Object object = AppUtils.INSTANCE.getContext().getSystemService("clipboard");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager cm = (ClipboardManager)object;
        ClipData clip = cm.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            ClipData.Item item = clip.getItemAt(0);
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"clip.getItemAt(0)");
            uri = item.getUri();
        } else {
            uri = null;
        }
        return uri;
    }

    public final void copyIntent(@Nullable Intent intent) {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("clipboard");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager cm = (ClipboardManager)object;
        cm.setPrimaryClip(ClipData.newIntent((CharSequence)"intent", (Intent)intent));
    }

    @Nullable
    public final Intent getIntent() {
        Intent intent;
        Object object = AppUtils.INSTANCE.getContext().getSystemService("clipboard");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager cm = (ClipboardManager)object;
        ClipData clip = cm.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            ClipData.Item item = clip.getItemAt(0);
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"clip.getItemAt(0)");
            intent = item.getIntent();
        } else {
            intent = null;
        }
        return intent;
    }

    private ClipboardUtils() {
    }

    static {
        ClipboardUtils clipboardUtils;
        INSTANCE = clipboardUtils = new ClipboardUtils();
    }
}

