/*
 * Decompiled with CFR 0.152.
 */
package idv.jasonwang.imageutils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;

public class ImageShapeUtils {
    public static Bitmap clipToCircle(Bitmap bitmap, float borderWidth, int borderColor) {
        Bitmap outputBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        int radius = Math.min(rect.centerX(), rect.centerY());
        Canvas canvas = new Canvas(outputBitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setDither(true);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawCircle((float)rect.centerX(), (float)rect.centerY(), (float)radius, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        if (borderWidth <= 0.0f) {
            return outputBitmap;
        }
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(borderColor);
        paint.setStrokeWidth(borderWidth);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
        canvas.drawCircle((float)rect.centerX(), (float)rect.centerY(), (float)radius - borderWidth / 2.0f + 0.5f, paint);
        return outputBitmap;
    }
}

