/*
 * Decompiled with CFR 0.152.
 */
package idv.jasonwang.imageutils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageCompressUtils {
    public static Bitmap compressBySize(Context context, int res, int targetWidth, int targetHeight) {
        int maxScale;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)context.getResources(), (int)res, (BitmapFactory.Options)options);
        int originalWidth = options.outWidth;
        int originalHeight = options.outHeight;
        int scaleWidth = targetWidth > 0 ? (int)Math.ceil((float)originalWidth / (float)targetWidth) : 0;
        int scaleHeight = targetHeight > 0 ? (int)Math.ceil((float)originalHeight / (float)targetHeight) : 0;
        options.inSampleSize = maxScale = Math.max(scaleWidth, scaleHeight);
        options.inJustDecodeBounds = false;
        BitmapFactory.decodeResource((Resources)context.getResources(), (int)res, (BitmapFactory.Options)options);
        return BitmapFactory.decodeResource((Resources)context.getResources(), (int)res, (BitmapFactory.Options)options);
    }

    public static Bitmap compressBySize(Bitmap bitmap, int targetWidth, int targetHeight) {
        int maxScale;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)outputStream);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        bitmap = BitmapFactory.decodeByteArray((byte[])outputStream.toByteArray(), (int)0, (int)outputStream.toByteArray().length, (BitmapFactory.Options)options);
        int originalWidth = options.outWidth;
        int originalHeight = options.outHeight;
        int scaleWidth = (int)Math.ceil((float)originalWidth / (float)targetWidth);
        int scaleHeight = (int)Math.ceil((float)originalHeight / (float)targetHeight);
        options.inSampleSize = maxScale = Math.max(scaleWidth, scaleHeight);
        options.inJustDecodeBounds = false;
        ImageCompressUtils.recycleBitmap(bitmap);
        return BitmapFactory.decodeByteArray((byte[])outputStream.toByteArray(), (int)0, (int)outputStream.toByteArray().length, (BitmapFactory.Options)options);
    }

    public static Bitmap compressBySize(InputStream inputStream, int targetWidth, int targetHeight) {
        int maxScale;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            return null;
        }
        byte[] data = outputStream.toByteArray();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        int originalWidth = options.outWidth;
        int originalHeight = options.outHeight;
        int scaleWidth = (int)Math.ceil((float)originalWidth / (float)targetWidth);
        int scaleHeight = (int)Math.ceil((float)originalHeight / (float)targetHeight);
        options.inSampleSize = maxScale = Math.max(scaleWidth, scaleHeight);
        options.inJustDecodeBounds = false;
        ImageCompressUtils.recycleBitmap(bitmap);
        return BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
    }

    public static Bitmap compressBySize(String filePath, int targetWidth, int targetHeight) {
        int maxScale;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        options.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int originalWidth = options.outWidth;
        int originalHeight = options.outHeight;
        int scaleWidth = targetWidth > 0 ? (int)Math.ceil((float)originalWidth / (float)targetWidth) : 0;
        int scaleHeight = targetHeight > 0 ? (int)Math.ceil((float)originalHeight / (float)targetHeight) : 0;
        options.inSampleSize = maxScale = Math.max(scaleWidth, scaleHeight);
        options.inJustDecodeBounds = false;
        ImageCompressUtils.recycleBitmap(bitmap);
        return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
    }

    private static void recycleBitmap(Bitmap bitmap) {
        if (bitmap != null && !bitmap.isRecycled()) {
            bitmap.recycle();
            System.gc();
            bitmap = null;
        }
    }
}

