/*
 * Decompiled with CFR 0.152.
 */
package com.larvalabs.svgandroid;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Picture;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.FloatMath;
import android.util.Log;
import com.larvalabs.svgandroid.ParserHelper;
import com.larvalabs.svgandroid.SVG;
import com.larvalabs.svgandroid.SVGColors;
import com.larvalabs.svgandroid.SVGParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SVGParser {
    static final String TAG = "SVGAndroid";
    private static boolean DISALLOW_DOCTYPE_DECL = true;
    private static final Pattern TRANSFORM_SEP = Pattern.compile("[\\s,]*");
    private static final RectF arcRectf = new RectF();
    private static final Matrix arcMatrix = new Matrix();
    private static final Matrix arcMatrix2 = new Matrix();

    public static Path parsePath(String pathString) {
        return SVGParser.doPath(pathString);
    }

    static SVG parse(InputSource data, SVGHandler handler) throws SVGParseException {
        try {
            Picture picture = new Picture();
            handler.setPicture(picture);
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            xr.setContentHandler(handler);
            xr.setFeature("http://xml.org/sax/features/validation", false);
            if (DISALLOW_DOCTYPE_DECL) {
                try {
                    xr.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                }
                catch (SAXNotRecognizedException e) {
                    DISALLOW_DOCTYPE_DECL = false;
                }
            }
            xr.parse(data);
            SVG result = new SVG(picture, handler.bounds);
            if (!Float.isInfinite(handler.limits.top)) {
                result.setLimits(handler.limits);
            }
            return result;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to parse SVG.", (Throwable)e);
            throw new SVGParseException(e);
        }
    }

    private static NumberParse parseNumbers(String s) {
        int n = s.length();
        int p = 0;
        ArrayList<Float> numbers = new ArrayList<Float>();
        boolean skipChar = false;
        boolean prevWasE = false;
        block8: for (int i = 1; i < n; ++i) {
            if (skipChar) {
                skipChar = false;
                continue;
            }
            char c = s.charAt(i);
            switch (c) {
                case ')': 
                case 'A': 
                case 'C': 
                case 'H': 
                case 'L': 
                case 'M': 
                case 'Q': 
                case 'S': 
                case 'T': 
                case 'V': 
                case 'Z': 
                case 'a': 
                case 'c': 
                case 'h': 
                case 'l': 
                case 'm': 
                case 'q': 
                case 's': 
                case 't': 
                case 'v': 
                case 'z': {
                    Float f;
                    String str = s.substring(p, i);
                    if (str.trim().length() > 0) {
                        f = Float.valueOf(Float.parseFloat(str));
                        numbers.add(f);
                    }
                    p = i;
                    return new NumberParse(numbers, p);
                }
                case '-': {
                    if (prevWasE) {
                        prevWasE = false;
                        continue block8;
                    }
                }
                case '\t': 
                case '\n': 
                case ' ': 
                case ',': {
                    Float f;
                    String str = s.substring(p, i);
                    if (str.trim().length() > 0) {
                        f = Float.valueOf(Float.parseFloat(str));
                        numbers.add(f);
                        if (c == '-') {
                            p = i;
                        } else {
                            p = i + 1;
                            skipChar = true;
                        }
                    } else {
                        ++p;
                    }
                    prevWasE = false;
                    continue block8;
                }
                case 'e': {
                    prevWasE = true;
                    continue block8;
                }
                default: {
                    prevWasE = false;
                }
            }
        }
        String last = s.substring(p);
        if (last.length() > 0) {
            try {
                numbers.add(Float.valueOf(Float.parseFloat(last)));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            p = s.length();
        }
        return new NumberParse(numbers, p);
    }

    private static Matrix parseTransform(String s) {
        Matrix matrix = new Matrix();
        while (true) {
            SVGParser.parseTransformItem(s, matrix);
            int rparen = s.indexOf(")");
            if (rparen <= 0 || s.length() <= rparen + 1) break;
            s = TRANSFORM_SEP.matcher(s.substring(rparen + 1)).replaceFirst("");
        }
        return matrix;
    }

    private static Matrix parseTransformItem(String s, Matrix matrix) {
        if (s.startsWith("matrix(")) {
            NumberParse np = SVGParser.parseNumbers(s.substring("matrix(".length()));
            if (np.numbers.size() == 6) {
                Matrix mat = new Matrix();
                mat.setValues(new float[]{((Float)np.numbers.get(0)).floatValue(), ((Float)np.numbers.get(2)).floatValue(), ((Float)np.numbers.get(4)).floatValue(), ((Float)np.numbers.get(1)).floatValue(), ((Float)np.numbers.get(3)).floatValue(), ((Float)np.numbers.get(5)).floatValue(), 0.0f, 0.0f, 1.0f});
                matrix.preConcat(mat);
            }
        } else if (s.startsWith("translate(")) {
            NumberParse np = SVGParser.parseNumbers(s.substring("translate(".length()));
            if (np.numbers.size() > 0) {
                float tx = ((Float)np.numbers.get(0)).floatValue();
                float ty = 0.0f;
                if (np.numbers.size() > 1) {
                    ty = ((Float)np.numbers.get(1)).floatValue();
                }
                matrix.preTranslate(tx, ty);
            }
        } else if (s.startsWith("scale(")) {
            NumberParse np = SVGParser.parseNumbers(s.substring("scale(".length()));
            if (np.numbers.size() > 0) {
                float sx;
                float sy = sx = ((Float)np.numbers.get(0)).floatValue();
                if (np.numbers.size() > 1) {
                    sy = ((Float)np.numbers.get(1)).floatValue();
                }
                matrix.preScale(sx, sy);
            }
        } else if (s.startsWith("skewX(")) {
            NumberParse np = SVGParser.parseNumbers(s.substring("skewX(".length()));
            if (np.numbers.size() > 0) {
                float angle = ((Float)np.numbers.get(0)).floatValue();
                matrix.preSkew((float)Math.tan(angle), 0.0f);
            }
        } else if (s.startsWith("skewY(")) {
            NumberParse np = SVGParser.parseNumbers(s.substring("skewY(".length()));
            if (np.numbers.size() > 0) {
                float angle = ((Float)np.numbers.get(0)).floatValue();
                matrix.preSkew(0.0f, (float)Math.tan(angle));
            }
        } else if (s.startsWith("rotate(")) {
            NumberParse np = SVGParser.parseNumbers(s.substring("rotate(".length()));
            if (np.numbers.size() > 0) {
                float angle = ((Float)np.numbers.get(0)).floatValue();
                float cx = 0.0f;
                float cy = 0.0f;
                if (np.numbers.size() > 2) {
                    cx = ((Float)np.numbers.get(1)).floatValue();
                    cy = ((Float)np.numbers.get(2)).floatValue();
                }
                matrix.preTranslate(-cx, -cy);
                matrix.preRotate(angle);
                matrix.preTranslate(cx, cy);
            }
        } else {
            Log.w((String)TAG, (String)("Invalid transform (" + s + ")"));
        }
        return matrix;
    }

    private static Path doPath(String s) {
        int n = s.length();
        ParserHelper ph = new ParserHelper(s, 0);
        ph.skipWhitespace();
        Path p = new Path();
        float lastX = 0.0f;
        float lastY = 0.0f;
        float lastX1 = 0.0f;
        float lastY1 = 0.0f;
        float subPathStartX = 0.0f;
        float subPathStartY = 0.0f;
        char prevCmd = '\u0000';
        while (ph.pos < n) {
            char cmd = s.charAt(ph.pos);
            switch (cmd) {
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (prevCmd == 'm' || prevCmd == 'M') {
                        cmd = (char)(prevCmd - 1);
                        break;
                    }
                    if ("lhvcsqta".indexOf(Character.toLowerCase(prevCmd)) >= 0) {
                        cmd = prevCmd;
                        break;
                    }
                }
                default: {
                    ph.advance();
                    prevCmd = cmd;
                }
            }
            boolean wasCurve = false;
            switch (cmd) {
                case 'M': 
                case 'm': {
                    float x = ph.nextFloat();
                    float y = ph.nextFloat();
                    if (cmd == 'm') {
                        subPathStartX += x;
                        subPathStartY += y;
                        p.rMoveTo(x, y);
                        lastX += x;
                        lastY += y;
                        break;
                    }
                    subPathStartX = x;
                    subPathStartY = y;
                    p.moveTo(x, y);
                    lastX = x;
                    lastY = y;
                    break;
                }
                case 'Z': 
                case 'z': {
                    p.close();
                    p.moveTo(subPathStartX, subPathStartY);
                    lastX = subPathStartX;
                    lastY = subPathStartY;
                    lastX1 = subPathStartX;
                    lastY1 = subPathStartY;
                    wasCurve = true;
                    break;
                }
                case 'L': 
                case 'T': 
                case 'l': 
                case 't': {
                    float x = ph.nextFloat();
                    float y = ph.nextFloat();
                    if (cmd == 'l') {
                        p.rLineTo(x, y);
                        lastX += x;
                        lastY += y;
                        break;
                    }
                    p.lineTo(x, y);
                    lastX = x;
                    lastY = y;
                    break;
                }
                case 'H': 
                case 'h': {
                    float x = ph.nextFloat();
                    if (cmd == 'h') {
                        p.rLineTo(x, 0.0f);
                        lastX += x;
                        break;
                    }
                    p.lineTo(x, lastY);
                    lastX = x;
                    break;
                }
                case 'V': 
                case 'v': {
                    float y = ph.nextFloat();
                    if (cmd == 'v') {
                        p.rLineTo(0.0f, y);
                        lastY += y;
                        break;
                    }
                    p.lineTo(lastX, y);
                    lastY = y;
                    break;
                }
                case 'C': 
                case 'c': {
                    wasCurve = true;
                    float x1 = ph.nextFloat();
                    float y1 = ph.nextFloat();
                    float x2 = ph.nextFloat();
                    float y2 = ph.nextFloat();
                    float x = ph.nextFloat();
                    float y = ph.nextFloat();
                    if (cmd == 'c') {
                        x1 += lastX;
                        x2 += lastX;
                        x += lastX;
                        y1 += lastY;
                        y2 += lastY;
                        y += lastY;
                    }
                    p.cubicTo(x1, y1, x2, y2, x, y);
                    lastX1 = x2;
                    lastY1 = y2;
                    lastX = x;
                    lastY = y;
                    break;
                }
                case 'Q': 
                case 'S': 
                case 'q': 
                case 's': {
                    wasCurve = true;
                    float x2 = ph.nextFloat();
                    float y2 = ph.nextFloat();
                    float x = ph.nextFloat();
                    float y = ph.nextFloat();
                    if (Character.isLowerCase(cmd)) {
                        x2 += lastX;
                        x += lastX;
                        y2 += lastY;
                        y += lastY;
                    }
                    float x1 = 2.0f * lastX - lastX1;
                    float y1 = 2.0f * lastY - lastY1;
                    p.cubicTo(x1, y1, x2, y2, x, y);
                    lastX1 = x2;
                    lastY1 = y2;
                    lastX = x;
                    lastY = y;
                    break;
                }
                case 'A': 
                case 'a': {
                    float rx = ph.nextFloat();
                    float ry = ph.nextFloat();
                    float theta = ph.nextFloat();
                    int largeArc = ph.nextFlag();
                    int sweepArc = ph.nextFlag();
                    float x = ph.nextFloat();
                    float y = ph.nextFloat();
                    if (cmd == 'a') {
                        x += lastX;
                        y += lastY;
                    }
                    SVGParser.drawArc(p, lastX, lastY, x, y, rx, ry, theta, largeArc, sweepArc);
                    lastX = x;
                    lastY = y;
                    break;
                }
                default: {
                    Log.w((String)TAG, (String)("Invalid path command: " + cmd));
                    ph.advance();
                }
            }
            if (!wasCurve) {
                lastX1 = lastX;
                lastY1 = lastY;
            }
            ph.skipWhitespace();
        }
        return p;
    }

    private static float angle(float x1, float y1, float x2, float y2) {
        return (float)Math.toDegrees(Math.atan2(x1, y1) - Math.atan2(x2, y2)) % 360.0f;
    }

    private static void drawArc(Path p, float lastX, float lastY, float x, float y, float rx, float ry, float theta, int largeArc, int sweepArc) {
        float rys;
        float y1t;
        float y1ts;
        float rxs;
        float yc;
        float xc;
        if (rx == 0.0f || ry == 0.0f) {
            p.lineTo(x, y);
            return;
        }
        if (x == lastX && y == lastY) {
            return;
        }
        rx = Math.abs(rx);
        ry = Math.abs(ry);
        float thrad = theta * (float)Math.PI / 180.0f;
        float st = FloatMath.sin((float)thrad);
        float ct = FloatMath.cos((float)thrad);
        float x1t = ct * (xc = (lastX - x) / 2.0f) + st * (yc = (lastY - y) / 2.0f);
        float x1ts = x1t * x1t;
        float lambda = (x1ts / (rxs = rx * rx) + (y1ts = (y1t = -st * xc + ct * yc) * y1t) / (rys = ry * ry)) * 1.001f;
        if (lambda > 1.0f) {
            float lambdasr = FloatMath.sqrt((float)lambda);
            rxs = (rx *= lambdasr) * rx;
            rys = (ry *= lambdasr) * ry;
        }
        float R = FloatMath.sqrt((float)((rxs * rys - rxs * y1ts - rys * x1ts) / (rxs * y1ts + rys * x1ts))) * (float)(largeArc == sweepArc ? -1 : 1);
        float cxt = R * rx * y1t / ry;
        float cyt = -R * ry * x1t / rx;
        float cx = ct * cxt - st * cyt + (lastX + x) / 2.0f;
        float cy = st * cxt + ct * cyt + (lastY + y) / 2.0f;
        float th1 = SVGParser.angle(1.0f, 0.0f, (x1t - cxt) / rx, (y1t - cyt) / ry);
        float dth = SVGParser.angle((x1t - cxt) / rx, (y1t - cyt) / ry, (-x1t - cxt) / rx, (-y1t - cyt) / ry);
        if (sweepArc == 0 && dth > 0.0f) {
            dth -= 360.0f;
        } else if (sweepArc != 0 && dth < 0.0f) {
            dth += 360.0f;
        }
        if (theta % 360.0f == 0.0f) {
            arcRectf.set(cx - rx, cy - ry, cx + rx, cy + ry);
            p.arcTo(arcRectf, th1, dth);
        } else {
            arcRectf.set(-rx, -ry, rx, ry);
            arcMatrix.reset();
            arcMatrix.postRotate(theta);
            arcMatrix.postTranslate(cx, cy);
            arcMatrix.invert(arcMatrix2);
            p.transform(arcMatrix2);
            p.arcTo(arcRectf, th1, dth);
            p.transform(arcMatrix);
        }
    }

    private static NumberParse getNumberParseAttr(String name, Attributes attributes) {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            if (!attributes.getLocalName(i).equals(name)) continue;
            return SVGParser.parseNumbers(attributes.getValue(i));
        }
        return null;
    }

    private static String getStringAttr(String name, Attributes attributes) {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            if (!attributes.getLocalName(i).equals(name)) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    private static Float getFloatAttr(String name, Attributes attributes) {
        return SVGParser.getFloatAttr(name, attributes, null);
    }

    private static Float getFloatAttr(String name, Attributes attributes, Float defaultValue) {
        String v = SVGParser.getStringAttr(name, attributes);
        return SVGParser.parseFloatValue(v, defaultValue);
    }

    private static Float parseFloatValue(String str, Float defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        if (str.endsWith("px")) {
            str = str.substring(0, str.length() - 2);
        } else if (str.endsWith("%")) {
            str = str.substring(0, str.length() - 1);
            return Float.valueOf(Float.parseFloat(str) / 100.0f);
        }
        return Float.valueOf(Float.parseFloat(str));
    }

    static class SVGHandler
    extends DefaultHandler {
        private Picture picture;
        private Canvas canvas;
        private Float limitsAdjustmentX;
        private Float limitsAdjustmentY;
        Paint strokePaint;
        boolean strokeSet = false;
        Stack<Paint> strokePaintStack = new Stack();
        Stack<Boolean> strokeSetStack = new Stack();
        Paint fillPaint;
        boolean fillSet = false;
        Stack<Paint> fillPaintStack = new Stack();
        Stack<Boolean> fillSetStack = new Stack();
        RectF rect = new RectF();
        RectF bounds = null;
        RectF limits = new RectF(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        Integer searchColor = null;
        Integer replaceColor = null;
        boolean whiteMode = false;
        Integer canvasRestoreCount;
        Stack<Boolean> transformStack = new Stack();
        Stack<Matrix> matrixStack = new Stack();
        HashMap<String, Gradient> gradientMap = new HashMap();
        Gradient gradient = null;
        private final Matrix gradMatrix = new Matrix();
        private boolean hidden = false;
        private int hiddenLevel = 0;
        private boolean boundsMode = false;
        private final RectF tmpLimitRect = new RectF();

        public SVGHandler() {
            this.strokePaint = new Paint();
            this.strokePaint.setAntiAlias(true);
            this.strokePaint.setStyle(Paint.Style.STROKE);
            this.fillPaint = new Paint();
            this.fillPaint.setAntiAlias(true);
            this.fillPaint.setStyle(Paint.Style.FILL);
            this.matrixStack.push(new Matrix());
        }

        void setPicture(Picture picture) {
            this.picture = picture;
        }

        public void setColorSwap(Integer searchColor, Integer replaceColor) {
            this.searchColor = searchColor;
            this.replaceColor = replaceColor;
        }

        public void setWhiteMode(boolean whiteMode) {
            this.whiteMode = whiteMode;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        private boolean doFill(Properties atts, RectF bounding_box) {
            if ("none".equals(atts.getString("display"))) {
                return false;
            }
            if (this.whiteMode) {
                this.fillPaint.setShader(null);
                this.fillPaint.setColor(-1);
                return true;
            }
            String fillString = atts.getString("fill");
            if (fillString != null) {
                if (fillString.startsWith("url(#")) {
                    String id = fillString.substring("url(#".length(), fillString.length() - 1);
                    Gradient g = this.gradientMap.get(id);
                    Shader shader = null;
                    if (g != null) {
                        shader = g.shader;
                    }
                    if (shader != null) {
                        this.fillPaint.setShader(shader);
                        this.gradMatrix.set(g.matrix);
                        if (g.boundingBox && bounding_box != null) {
                            this.gradMatrix.preTranslate(bounding_box.left, bounding_box.top);
                            this.gradMatrix.preScale(bounding_box.width(), bounding_box.height());
                        }
                        shader.setLocalMatrix(this.gradMatrix);
                        return true;
                    }
                    Log.w((String)SVGParser.TAG, (String)("Didn't find shader, using black: " + id));
                    this.fillPaint.setShader(null);
                    this.doColor(atts, -16777216, true, this.fillPaint);
                    return true;
                }
                if (fillString.equalsIgnoreCase("none")) {
                    this.fillPaint.setShader(null);
                    this.fillPaint.setColor(0);
                    return true;
                }
                this.fillPaint.setShader(null);
                Integer color = atts.getColor("fill");
                if (color != null) {
                    this.doColor(atts, color, true, this.fillPaint);
                    return true;
                }
                Log.w((String)SVGParser.TAG, (String)("Unrecognized fill color, using black: " + fillString));
                this.doColor(atts, -16777216, true, this.fillPaint);
                return true;
            }
            if (this.fillSet) {
                return this.fillPaint.getColor() != 0;
            }
            this.fillPaint.setShader(null);
            this.fillPaint.setColor(-16777216);
            return true;
        }

        private boolean doStroke(Properties atts) {
            String linecap;
            if (this.whiteMode) {
                return false;
            }
            if ("none".equals(atts.getString("display"))) {
                return false;
            }
            Float width = atts.getFloat("stroke-width");
            if (width != null) {
                this.strokePaint.setStrokeWidth(width.floatValue());
            }
            if ("round".equals(linecap = atts.getString("stroke-linecap"))) {
                this.strokePaint.setStrokeCap(Paint.Cap.ROUND);
            } else if ("square".equals(linecap)) {
                this.strokePaint.setStrokeCap(Paint.Cap.SQUARE);
            } else if ("butt".equals(linecap)) {
                this.strokePaint.setStrokeCap(Paint.Cap.BUTT);
            }
            String linejoin = atts.getString("stroke-linejoin");
            if ("miter".equals(linejoin)) {
                this.strokePaint.setStrokeJoin(Paint.Join.MITER);
            } else if ("round".equals(linejoin)) {
                this.strokePaint.setStrokeJoin(Paint.Join.ROUND);
            } else if ("bevel".equals(linejoin)) {
                this.strokePaint.setStrokeJoin(Paint.Join.BEVEL);
            }
            this.pathStyleHelper(atts.getString("stroke-dasharray"), atts.getString("stroke-dashoffset"));
            String strokeString = atts.getAttr("stroke");
            if (strokeString != null) {
                if (strokeString.equalsIgnoreCase("none")) {
                    this.strokePaint.setColor(0);
                    return false;
                }
                Integer color = atts.getColor("stroke");
                if (color != null) {
                    this.doColor(atts, color, false, this.strokePaint);
                    return true;
                }
                Log.w((String)SVGParser.TAG, (String)("Unrecognized stroke color, using none: " + strokeString));
                this.strokePaint.setColor(0);
                return false;
            }
            if (this.strokeSet) {
                return this.strokePaint.getColor() != 0;
            }
            this.strokePaint.setColor(0);
            return false;
        }

        private Gradient doGradient(boolean isLinear, Attributes atts) {
            String spreadMethod;
            Gradient gradient = new Gradient();
            gradient.id = SVGParser.getStringAttr("id", atts);
            gradient.isLinear = isLinear;
            if (isLinear) {
                gradient.x1 = SVGParser.getFloatAttr("x1", atts, Float.valueOf(0.0f)).floatValue();
                gradient.x2 = SVGParser.getFloatAttr("x2", atts, Float.valueOf(1.0f)).floatValue();
                gradient.y1 = SVGParser.getFloatAttr("y1", atts, Float.valueOf(0.0f)).floatValue();
                gradient.y2 = SVGParser.getFloatAttr("y2", atts, Float.valueOf(0.0f)).floatValue();
            } else {
                gradient.x = SVGParser.getFloatAttr("cx", atts, Float.valueOf(0.0f)).floatValue();
                gradient.y = SVGParser.getFloatAttr("cy", atts, Float.valueOf(0.0f)).floatValue();
                gradient.radius = SVGParser.getFloatAttr("r", atts, Float.valueOf(0.0f)).floatValue();
            }
            String transform = SVGParser.getStringAttr("gradientTransform", atts);
            if (transform != null) {
                gradient.matrix = SVGParser.parseTransform(transform);
            }
            if ((spreadMethod = SVGParser.getStringAttr("spreadMethod", atts)) == null) {
                spreadMethod = "pad";
            }
            gradient.tilemode = spreadMethod.equals("reflect") ? Shader.TileMode.MIRROR : (spreadMethod.equals("repeat") ? Shader.TileMode.REPEAT : Shader.TileMode.CLAMP);
            String unit = SVGParser.getStringAttr("gradientUnits", atts);
            if (unit == null) {
                unit = "objectBoundingBox";
            }
            gradient.boundingBox = !unit.equals("userSpaceOnUse");
            String xlink = SVGParser.getStringAttr("href", atts);
            if (xlink != null) {
                if (xlink.startsWith("#")) {
                    xlink = xlink.substring(1);
                }
                gradient.xlink = xlink;
            }
            return gradient;
        }

        private void doColor(Properties atts, Integer color, boolean fillMode, Paint paint) {
            int c = 0xFFFFFF & color | 0xFF000000;
            if (this.searchColor != null && this.searchColor == c) {
                c = this.replaceColor;
            }
            paint.setShader(null);
            paint.setColor(c);
            Float opacity = atts.getFloat("opacity");
            if (opacity == null) {
                opacity = atts.getFloat(fillMode ? "fill-opacity" : "stroke-opacity");
            }
            if (opacity == null) {
                paint.setAlpha(255);
            } else {
                paint.setAlpha((int)(255.0f * opacity.floatValue()));
            }
        }

        private void pathStyleHelper(String style, String offset) {
            if (style == null) {
                return;
            }
            if (style.equals("none")) {
                this.strokePaint.setPathEffect(null);
                return;
            }
            StringTokenizer st = new StringTokenizer(style, " ,");
            int count = st.countTokens();
            float[] intervals = new float[(count & 1) == 1 ? count * 2 : count];
            float max = 0.0f;
            float current = 1.0f;
            int i = 0;
            while (st.hasMoreTokens()) {
                intervals[i++] = current = SVGHandler.toFloat(st.nextToken(), current);
                max += current;
            }
            int start = 0;
            while (i < intervals.length) {
                intervals[i] = intervals[start];
                max += intervals[i];
                ++i;
                ++start;
            }
            float off = 0.0f;
            if (offset != null) {
                try {
                    off = Float.parseFloat(offset) % max;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.strokePaint.setPathEffect((PathEffect)new DashPathEffect(intervals, off));
        }

        private static float toFloat(String s, float dflt) {
            float result = dflt;
            try {
                result = Float.parseFloat(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return result;
        }

        private void doLimits2(float x, float y) {
            if (x < this.limits.left) {
                this.limits.left = x;
            }
            if (x > this.limits.right) {
                this.limits.right = x;
            }
            if (y < this.limits.top) {
                this.limits.top = y;
            }
            if (y > this.limits.bottom) {
                this.limits.bottom = y;
            }
        }

        private void doLimits(RectF box, Paint paint) {
            Matrix m = this.matrixStack.peek();
            m.mapRect(this.tmpLimitRect, box);
            float width2 = paint == null ? 0.0f : paint.getStrokeWidth() / 2.0f;
            this.doLimits2(this.tmpLimitRect.left - width2, this.tmpLimitRect.top - width2);
            this.doLimits2(this.tmpLimitRect.right + width2, this.tmpLimitRect.bottom + width2);
        }

        private void doLimits(RectF box) {
            this.doLimits(box, null);
        }

        private void pushTransform(Attributes atts) {
            String transform = SVGParser.getStringAttr("transform", atts);
            boolean pushed = transform != null;
            this.transformStack.push(pushed);
            if (pushed) {
                Matrix matrix = SVGParser.parseTransform(transform);
                this.canvas.save();
                this.canvas.concat(matrix);
                matrix.postConcat(this.matrixStack.peek());
                this.matrixStack.push(matrix);
            }
        }

        private void popTransform() {
            if (this.transformStack.pop().booleanValue()) {
                this.canvas.restore();
                this.matrixStack.pop();
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.strokePaint.setAlpha(255);
            this.fillPaint.setAlpha(255);
            if (this.boundsMode) {
                if (localName.equals("rect")) {
                    Float y;
                    Float x = SVGParser.getFloatAttr("x", atts);
                    if (x == null) {
                        x = Float.valueOf(0.0f);
                    }
                    if ((y = SVGParser.getFloatAttr("y", atts)) == null) {
                        y = Float.valueOf(0.0f);
                    }
                    Float width = SVGParser.getFloatAttr("width", atts);
                    Float height = SVGParser.getFloatAttr("height", atts);
                    this.bounds = new RectF(x.floatValue(), y.floatValue(), x.floatValue() + width.floatValue(), y.floatValue() + height.floatValue());
                }
                return;
            }
            if (localName.equals("svg")) {
                String[] dims;
                this.canvas = null;
                String viewboxStr = SVGParser.getStringAttr("viewBox", atts);
                if (viewboxStr != null && (dims = viewboxStr.split("\\s+")).length == 4) {
                    Float x1 = SVGParser.parseFloatValue(dims[0], null);
                    Float y1 = SVGParser.parseFloatValue(dims[1], null);
                    Float x2 = SVGParser.parseFloatValue(dims[2], null);
                    Float y2 = SVGParser.parseFloatValue(dims[3], null);
                    if (x1 != null && x2 != null && y1 != null && y2 != null) {
                        float width = FloatMath.ceil((float)(x2.floatValue() - x1.floatValue()));
                        float height = FloatMath.ceil((float)(y2.floatValue() - y1.floatValue()));
                        this.canvas = this.picture.beginRecording((int)width, (int)height);
                        this.canvasRestoreCount = this.canvas.save();
                        this.canvas.clipRect(0.0f, 0.0f, width, height);
                        this.limitsAdjustmentX = Float.valueOf(-x1.floatValue());
                        this.limitsAdjustmentY = Float.valueOf(-y1.floatValue());
                        this.canvas.translate(this.limitsAdjustmentX.floatValue(), this.limitsAdjustmentY.floatValue());
                    }
                }
                if (this.canvas == null) {
                    int width = (int)FloatMath.ceil((float)SVGParser.getFloatAttr("width", atts).floatValue());
                    int height = (int)FloatMath.ceil((float)SVGParser.getFloatAttr("height", atts).floatValue());
                    this.canvas = this.picture.beginRecording(width, height);
                    this.canvasRestoreCount = null;
                }
            } else if (!localName.equals("defs")) {
                if (localName.equals("linearGradient")) {
                    this.gradient = this.doGradient(true, atts);
                } else if (localName.equals("radialGradient")) {
                    this.gradient = this.doGradient(false, atts);
                } else if (localName.equals("stop")) {
                    if (this.gradient != null) {
                        Properties props = new Properties(atts);
                        float offset = props.getFloat("offset", 0.0f).floatValue();
                        int color = props.getColor("stop-color");
                        float alpha = props.getFloat("stop-opacity", 1.0f).floatValue();
                        int alphaInt = Math.round(255.0f * alpha);
                        this.gradient.positions.add(Float.valueOf(offset));
                        this.gradient.colors.add(color |= alphaInt << 24);
                    }
                } else if (localName.equals("g")) {
                    if ("bounds".equalsIgnoreCase(SVGParser.getStringAttr("id", atts))) {
                        this.boundsMode = true;
                    }
                    if (this.hidden) {
                        ++this.hiddenLevel;
                    }
                    if ("none".equals(SVGParser.getStringAttr("display", atts)) && !this.hidden) {
                        this.hidden = true;
                        this.hiddenLevel = 1;
                    }
                    this.pushTransform(atts);
                    Properties props = new Properties(atts);
                    this.fillPaintStack.push(new Paint(this.fillPaint));
                    this.strokePaintStack.push(new Paint(this.strokePaint));
                    this.fillSetStack.push(this.fillSet);
                    this.strokeSetStack.push(this.strokeSet);
                    this.doFill(props, null);
                    this.doStroke(props);
                    this.fillSet |= props.getString("fill") != null;
                    this.strokeSet |= props.getString("stroke") != null;
                } else if (!this.hidden && localName.equals("rect")) {
                    Float y;
                    Float x = SVGParser.getFloatAttr("x", atts);
                    if (x == null) {
                        x = Float.valueOf(0.0f);
                    }
                    if ((y = SVGParser.getFloatAttr("y", atts)) == null) {
                        y = Float.valueOf(0.0f);
                    }
                    Float width = SVGParser.getFloatAttr("width", atts);
                    Float height = SVGParser.getFloatAttr("height", atts);
                    Float rx = SVGParser.getFloatAttr("rx", atts, Float.valueOf(0.0f));
                    Float ry = SVGParser.getFloatAttr("ry", atts, Float.valueOf(0.0f));
                    this.pushTransform(atts);
                    Properties props = new Properties(atts);
                    this.rect.set(x.floatValue(), y.floatValue(), x.floatValue() + width.floatValue(), y.floatValue() + height.floatValue());
                    if (this.doFill(props, this.rect)) {
                        this.rect.set(x.floatValue(), y.floatValue(), x.floatValue() + width.floatValue(), y.floatValue() + height.floatValue());
                        if (rx.floatValue() <= 0.0f && ry.floatValue() <= 0.0f) {
                            this.canvas.drawRect(this.rect, this.fillPaint);
                        } else {
                            this.canvas.drawRoundRect(this.rect, rx.floatValue(), ry.floatValue(), this.fillPaint);
                        }
                        this.doLimits(this.rect);
                    }
                    if (this.doStroke(props)) {
                        this.rect.set(x.floatValue(), y.floatValue(), x.floatValue() + width.floatValue(), y.floatValue() + height.floatValue());
                        if (rx.floatValue() <= 0.0f && ry.floatValue() <= 0.0f) {
                            this.canvas.drawRect(this.rect, this.strokePaint);
                        } else {
                            this.canvas.drawRoundRect(this.rect, rx.floatValue(), ry.floatValue(), this.strokePaint);
                        }
                        this.doLimits(this.rect, this.strokePaint);
                    }
                    this.popTransform();
                } else if (!this.hidden && localName.equals("line")) {
                    Float x1 = SVGParser.getFloatAttr("x1", atts);
                    Float x2 = SVGParser.getFloatAttr("x2", atts);
                    Float y1 = SVGParser.getFloatAttr("y1", atts);
                    Float y2 = SVGParser.getFloatAttr("y2", atts);
                    Properties props = new Properties(atts);
                    if (this.doStroke(props)) {
                        this.pushTransform(atts);
                        this.rect.set(x1.floatValue(), y1.floatValue(), x2.floatValue(), y2.floatValue());
                        this.canvas.drawLine(x1.floatValue(), y1.floatValue(), x2.floatValue(), y2.floatValue(), this.strokePaint);
                        this.doLimits(this.rect, this.strokePaint);
                        this.popTransform();
                    }
                } else if (!this.hidden && (localName.equals("circle") || localName.equals("ellipse"))) {
                    Float radiusY;
                    Float radiusX;
                    Float centerX = SVGParser.getFloatAttr("cx", atts);
                    Float centerY = SVGParser.getFloatAttr("cy", atts);
                    if (localName.equals("ellipse")) {
                        radiusX = SVGParser.getFloatAttr("rx", atts);
                        radiusY = SVGParser.getFloatAttr("ry", atts);
                    } else {
                        radiusX = radiusY = SVGParser.getFloatAttr("r", atts);
                    }
                    if (centerX != null && centerY != null && radiusX != null && radiusY != null) {
                        this.pushTransform(atts);
                        Properties props = new Properties(atts);
                        this.rect.set(centerX.floatValue() - radiusX.floatValue(), centerY.floatValue() - radiusY.floatValue(), centerX.floatValue() + radiusX.floatValue(), centerY.floatValue() + radiusY.floatValue());
                        if (this.doFill(props, this.rect)) {
                            this.canvas.drawOval(this.rect, this.fillPaint);
                            this.doLimits(this.rect);
                        }
                        if (this.doStroke(props)) {
                            this.canvas.drawOval(this.rect, this.strokePaint);
                            this.doLimits(this.rect, this.strokePaint);
                        }
                        this.popTransform();
                    }
                } else if (!this.hidden && (localName.equals("polygon") || localName.equals("polyline"))) {
                    NumberParse numbers = SVGParser.getNumberParseAttr("points", atts);
                    if (numbers != null) {
                        Path p = new Path();
                        ArrayList points = numbers.numbers;
                        if (points.size() > 1) {
                            this.pushTransform(atts);
                            Properties props = new Properties(atts);
                            p.moveTo(((Float)points.get(0)).floatValue(), ((Float)points.get(1)).floatValue());
                            for (int i = 2; i < points.size(); i += 2) {
                                float x = ((Float)points.get(i)).floatValue();
                                float y = ((Float)points.get(i + 1)).floatValue();
                                p.lineTo(x, y);
                            }
                            if (localName.equals("polygon")) {
                                p.close();
                            }
                            p.computeBounds(this.rect, false);
                            if (this.doFill(props, this.rect)) {
                                this.canvas.drawPath(p, this.fillPaint);
                                this.doLimits(this.rect);
                            }
                            if (this.doStroke(props)) {
                                this.canvas.drawPath(p, this.strokePaint);
                                this.doLimits(this.rect, this.strokePaint);
                            }
                            this.popTransform();
                        }
                    }
                } else if (!this.hidden && localName.equals("path")) {
                    Path p = SVGParser.doPath(SVGParser.getStringAttr("d", atts));
                    this.pushTransform(atts);
                    Properties props = new Properties(atts);
                    p.computeBounds(this.rect, false);
                    if (this.doFill(props, this.rect)) {
                        this.canvas.drawPath(p, this.fillPaint);
                        this.doLimits(this.rect);
                    }
                    if (this.doStroke(props)) {
                        this.canvas.drawPath(p, this.strokePaint);
                        this.doLimits(this.rect, this.strokePaint);
                    }
                    this.popTransform();
                } else if (!this.hidden) {
                    Log.w((String)SVGParser.TAG, (String)("UNRECOGNIZED SVG COMMAND: " + localName));
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals("svg")) {
                if (this.canvasRestoreCount != null) {
                    this.canvas.restoreToCount(this.canvasRestoreCount.intValue());
                }
                if (this.limitsAdjustmentX != null) {
                    this.limits.left += this.limitsAdjustmentX.floatValue();
                    this.limits.right += this.limitsAdjustmentX.floatValue();
                }
                if (this.limitsAdjustmentY != null) {
                    this.limits.top += this.limitsAdjustmentY.floatValue();
                    this.limits.bottom += this.limitsAdjustmentY.floatValue();
                }
                this.picture.endRecording();
            } else if (localName.equals("linearGradient") || localName.equals("radialGradient")) {
                if (this.gradient.id != null) {
                    Gradient parent;
                    if (this.gradient.xlink != null && (parent = this.gradientMap.get(this.gradient.xlink)) != null) {
                        this.gradient = parent.createChild(this.gradient);
                    }
                    int[] colors = new int[this.gradient.colors.size()];
                    for (int i = 0; i < colors.length; ++i) {
                        colors[i] = this.gradient.colors.get(i);
                    }
                    float[] positions = new float[this.gradient.positions.size()];
                    for (int i = 0; i < positions.length; ++i) {
                        positions[i] = this.gradient.positions.get(i).floatValue();
                    }
                    if (colors.length == 0) {
                        Log.d((String)"BAD", (String)"BAD");
                    }
                    this.gradient.shader = localName.equals("linearGradient") ? new LinearGradient(this.gradient.x1, this.gradient.y1, this.gradient.x2, this.gradient.y2, colors, positions, this.gradient.tilemode) : new RadialGradient(this.gradient.x, this.gradient.y, this.gradient.radius, colors, positions, this.gradient.tilemode);
                    this.gradientMap.put(this.gradient.id, this.gradient);
                }
            } else if (localName.equals("g")) {
                if (this.boundsMode) {
                    this.boundsMode = false;
                }
                if (this.hidden) {
                    --this.hiddenLevel;
                    if (this.hiddenLevel == 0) {
                        this.hidden = false;
                    }
                }
                this.popTransform();
                this.fillPaint = this.fillPaintStack.pop();
                this.fillSet = this.fillSetStack.pop();
                this.strokePaint = this.strokePaintStack.pop();
                this.strokeSet = this.strokeSetStack.pop();
            }
        }
    }

    private static class Properties {
        StyleSet styles = null;
        Attributes atts;

        private Properties(Attributes atts) {
            this.atts = atts;
            String styleAttr = SVGParser.getStringAttr("style", atts);
            if (styleAttr != null) {
                this.styles = new StyleSet(styleAttr);
            }
        }

        public String getAttr(String name) {
            String v = null;
            if (this.styles != null) {
                v = this.styles.getStyle(name);
            }
            if (v == null) {
                v = SVGParser.getStringAttr(name, this.atts);
            }
            return v;
        }

        public String getString(String name) {
            return this.getAttr(name);
        }

        private Integer rgb(int r, int g, int b) {
            return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }

        private int parseNum(String v) throws NumberFormatException {
            if (v.endsWith("%")) {
                v = v.substring(0, v.length() - 1);
                return Math.round(Float.parseFloat(v) / 100.0f * 255.0f);
            }
            return Integer.parseInt(v);
        }

        public Integer getColor(String name) {
            String v = this.getAttr(name);
            if (v == null) {
                return null;
            }
            if (v.startsWith("#")) {
                try {
                    int c = Integer.parseInt(v.substring(1), 16);
                    return v.length() == 4 ? this.hex3Tohex6(c) : c;
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            if (v.startsWith("rgb(") && v.endsWith(")")) {
                String[] values = v.substring(4, v.length() - 1).split(",");
                try {
                    return this.rgb(this.parseNum(values[0]), this.parseNum(values[1]), this.parseNum(values[2]));
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return null;
                }
            }
            return SVGColors.mapColour(v);
        }

        private int hex3Tohex6(int x) {
            return (x & 0xF00) << 8 | (x & 0xF00) << 12 | (x & 0xF0) << 4 | (x & 0xF0) << 8 | (x & 0xF) << 4 | x & 0xF;
        }

        public Float getFloat(String name, float defaultValue) {
            Float v = this.getFloat(name);
            if (v == null) {
                return Float.valueOf(defaultValue);
            }
            return v;
        }

        public Float getFloat(String name) {
            String v = this.getAttr(name);
            if (v == null) {
                return null;
            }
            try {
                return Float.valueOf(Float.parseFloat(v));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    private static class StyleSet {
        HashMap<String, String> styleMap = new HashMap();

        private StyleSet(String string) {
            String[] styles;
            for (String s : styles = string.split(";")) {
                String[] style = s.split(":");
                if (style.length != 2) continue;
                this.styleMap.put(style[0], style[1]);
            }
        }

        public String getStyle(String name) {
            return this.styleMap.get(name);
        }
    }

    private static class Gradient {
        String id;
        String xlink;
        boolean isLinear;
        float x1;
        float y1;
        float x2;
        float y2;
        float x;
        float y;
        float radius;
        ArrayList<Float> positions = new ArrayList();
        ArrayList<Integer> colors = new ArrayList();
        Matrix matrix = null;
        public Shader shader = null;
        public boolean boundingBox = false;
        public Shader.TileMode tilemode;

        private Gradient() {
        }

        public Gradient createChild(Gradient g) {
            Gradient child = new Gradient();
            child.id = g.id;
            child.xlink = this.id;
            child.isLinear = g.isLinear;
            child.x1 = g.x1;
            child.x2 = g.x2;
            child.y1 = g.y1;
            child.y2 = g.y2;
            child.x = g.x;
            child.y = g.y;
            child.radius = g.radius;
            child.positions = this.positions;
            child.colors = this.colors;
            child.matrix = this.matrix;
            if (g.matrix != null) {
                if (this.matrix == null) {
                    child.matrix = g.matrix;
                } else {
                    Matrix m = new Matrix(this.matrix);
                    m.preConcat(g.matrix);
                    child.matrix = m;
                }
            }
            child.boundingBox = g.boundingBox;
            child.shader = g.shader;
            child.tilemode = g.tilemode;
            return child;
        }
    }

    private static class NumberParse {
        private ArrayList<Float> numbers;
        private int nextCmd;

        public NumberParse(ArrayList<Float> numbers, int nextCmd) {
            this.numbers = numbers;
            this.nextCmd = nextCmd;
        }

        public int getNextCmd() {
            return this.nextCmd;
        }

        public float getNumber(int index) {
            return this.numbers.get(index).floatValue();
        }
    }
}

