/*
 * Decompiled with CFR 0.152.
 */
package com.larvalabs.svgandroid;

import java.lang.reflect.Field;

public class ParserHelper {
    private static final Field STRING_CHARS;
    private final char[] s;
    private final int n;
    private char current;
    public int pos;
    private static final double[] pow10;

    public ParserHelper(String str, int pos) {
        try {
            this.s = (char[])STRING_CHARS.get(str);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.pos = pos;
        this.n = this.s.length;
        this.current = this.s[pos];
    }

    private char read() {
        if (this.pos < this.n) {
            ++this.pos;
        }
        if (this.pos == this.n) {
            return '\u0000';
        }
        return this.s[this.pos];
    }

    public void skipWhitespace() {
        while (this.pos < this.n && Character.isWhitespace(this.s[this.pos])) {
            this.advance();
        }
    }

    public void skipNumberSeparator() {
        block3: while (this.pos < this.n) {
            char c = this.s[this.pos];
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': 
                case ',': {
                    this.advance();
                    continue block3;
                }
            }
            return;
        }
    }

    public void advance() {
        this.current = this.read();
    }

    public float parseFloat() {
        int mant = 0;
        int mantDig = 0;
        boolean mantPos = true;
        boolean mantRead = false;
        int exp = 0;
        int expDig = 0;
        int expAdj = 0;
        boolean expPos = true;
        switch (this.current) {
            case '-': {
                mantPos = false;
            }
            case '+': {
                this.current = this.read();
            }
        }
        block4 : switch (this.current) {
            default: {
                return Float.NaN;
            }
            case '.': {
                break;
            }
            case '0': {
                mantRead = true;
                block50: while (true) {
                    this.current = this.read();
                    switch (this.current) {
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break block50;
                        }
                        case '.': 
                        case 'E': 
                        case 'e': {
                            break block4;
                        }
                        default: {
                            return 0.0f;
                        }
                        case '0': {
                            continue block50;
                        }
                    }
                    break;
                }
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                mantRead = true;
                while (true) {
                    if (mantDig < 9) {
                        ++mantDig;
                        mant = mant * 10 + (this.current - 48);
                    } else {
                        ++expAdj;
                    }
                    this.current = this.read();
                    switch (this.current) {
                        default: {
                            break block4;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                    }
                }
            }
        }
        if (this.current == '.') {
            this.current = this.read();
            block17 : switch (this.current) {
                default: {
                    if (mantRead) break;
                    this.reportUnexpectedCharacterError(this.current);
                    return 0.0f;
                }
                case '0': {
                    if (mantDig == 0) {
                        block52: while (true) {
                            this.current = this.read();
                            --expAdj;
                            switch (this.current) {
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    break block52;
                                }
                                default: {
                                    if (mantRead) break block17;
                                    return 0.0f;
                                }
                                case '0': {
                                    continue block52;
                                }
                            }
                            break;
                        }
                    }
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    while (true) {
                        if (mantDig < 9) {
                            ++mantDig;
                            mant = mant * 10 + (this.current - 48);
                            --expAdj;
                        }
                        this.current = this.read();
                        switch (this.current) {
                            default: {
                                break block17;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': 
                        }
                    }
                }
            }
        }
        block28 : switch (this.current) {
            case 'E': 
            case 'e': {
                this.current = this.read();
                switch (this.current) {
                    default: {
                        this.reportUnexpectedCharacterError(this.current);
                        return 0.0f;
                    }
                    case '-': {
                        expPos = false;
                    }
                    case '+': {
                        this.current = this.read();
                        switch (this.current) {
                            default: {
                                this.reportUnexpectedCharacterError(this.current);
                                return 0.0f;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': 
                        }
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                }
                switch (this.current) {
                    case '0': {
                        block54: while (true) {
                            this.current = this.read();
                            switch (this.current) {
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    break block54;
                                }
                                default: {
                                    break block28;
                                }
                                case '0': {
                                    continue block54;
                                }
                            }
                            break;
                        }
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        while (true) {
                            if (expDig < 3) {
                                ++expDig;
                                exp = exp * 10 + (this.current - 48);
                            }
                            this.current = this.read();
                            switch (this.current) {
                                default: {
                                    break block28;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': 
                            }
                        }
                    }
                }
            }
        }
        if (!expPos) {
            exp = -exp;
        }
        exp += expAdj;
        if (!mantPos) {
            mant = -mant;
        }
        return ParserHelper.buildFloat(mant, exp);
    }

    private void reportUnexpectedCharacterError(char c) {
        throw new RuntimeException("Unexpected char '" + c + "'.");
    }

    public static float buildFloat(int mant, int exp) {
        if (exp < -125 || mant == 0) {
            return 0.0f;
        }
        if (exp >= 128) {
            return mant > 0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
        }
        if (exp == 0) {
            return mant;
        }
        if (mant >= 0x4000000) {
            ++mant;
        }
        return (float)(exp > 0 ? (double)mant * pow10[exp] : (double)mant / pow10[-exp]);
    }

    public float nextFloat() {
        this.skipWhitespace();
        float f = this.parseFloat();
        this.skipNumberSeparator();
        return f;
    }

    public int nextFlag() {
        this.skipWhitespace();
        int flag = this.current - 48;
        this.current = this.read();
        this.skipNumberSeparator();
        return flag;
    }

    static {
        try {
            STRING_CHARS = String.class.getDeclaredField("value");
            STRING_CHARS.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        pow10 = new double[128];
        for (int i = 0; i < pow10.length; ++i) {
            ParserHelper.pow10[i] = Math.pow(10.0, i);
        }
    }
}

