/*
 * Decompiled with CFR 0.152.
 */
package com.github.jakemarsden.githooksgradleplugin;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GitHookWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHookWriter.class);
    private final Path hooksDirectory;
    private final String gradleCommand;

    GitHookWriter(Path hooksDirectory, String gradleCommand) {
        this.hooksDirectory = hooksDirectory;
        this.gradleCommand = gradleCommand;
    }

    void writeHook(String hookName, String gradleTask) {
        String script = this.generateScript(gradleTask);
        Path scriptPath = this.hooksDirectory.resolve(hookName);
        LOGGER.info("Writing hook script '{}'", (Object)scriptPath);
        try {
            Files.createDirectories(scriptPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create missing parent(s) for: " + scriptPath, e);
        }
        try {
            Files.write(scriptPath, script.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write to file: " + scriptPath, e);
        }
        if (!scriptPath.toFile().setExecutable(true, false)) {
            throw new UnsupportedOperationException("Failed to set as executable: " + scriptPath);
        }
    }

    private String generateScript(String gradleTask) {
        return "#!/bin/bash\n" + this.gradleCommand + ' ' + gradleTask + '\n';
    }
}

