/*
 * Decompiled with CFR 0.152.
 */
package cn.iwgang.countdownview;

public class DynamicConfig {
    private Builder mBuilder;

    private DynamicConfig(Builder builder) {
        this.mBuilder = builder;
    }

    public Float getTimeTextSize() {
        return this.mBuilder.timeTextSize;
    }

    public Integer getTimeTextColor() {
        return this.mBuilder.timeTextColor;
    }

    public Boolean isTimeTextBold() {
        return this.mBuilder.isTimeTextBold;
    }

    public Float getSuffixTextSize() {
        return this.mBuilder.suffixTextSize;
    }

    public Integer getSuffixTextColor() {
        return this.mBuilder.suffixTextColor;
    }

    public Boolean isSuffixTimeTextBold() {
        return this.mBuilder.isSuffixTextBold;
    }

    public String getSuffix() {
        return this.mBuilder.suffix;
    }

    public String getSuffixDay() {
        return this.mBuilder.suffixDay;
    }

    public String getSuffixHour() {
        return this.mBuilder.suffixHour;
    }

    public String getSuffixMinute() {
        return this.mBuilder.suffixMinute;
    }

    public String getSuffixSecond() {
        return this.mBuilder.suffixSecond;
    }

    public String getSuffixMillisecond() {
        return this.mBuilder.suffixMillisecond;
    }

    public Integer getSuffixGravity() {
        return this.mBuilder.suffixGravity;
    }

    public Float getSuffixLRMargin() {
        return this.mBuilder.suffixLRMargin;
    }

    public Float getSuffixDayLeftMargin() {
        return this.mBuilder.suffixDayLeftMargin;
    }

    public Float getSuffixDayRightMargin() {
        return this.mBuilder.suffixDayRightMargin;
    }

    public Float getSuffixHourLeftMargin() {
        return this.mBuilder.suffixHourLeftMargin;
    }

    public Float getSuffixHourRightMargin() {
        return this.mBuilder.suffixHourRightMargin;
    }

    public Float getSuffixMinuteLeftMargin() {
        return this.mBuilder.suffixMinuteLeftMargin;
    }

    public Float getSuffixMinuteRightMargin() {
        return this.mBuilder.suffixMinuteRightMargin;
    }

    public Float getSuffixSecondLeftMargin() {
        return this.mBuilder.suffixSecondLeftMargin;
    }

    public Float getSuffixSecondRightMargin() {
        return this.mBuilder.suffixSecondRightMargin;
    }

    public Float getSuffixMillisecondLeftMargin() {
        return this.mBuilder.suffixMillisecondLeftMargin;
    }

    public Boolean isConvertDaysToHours() {
        return this.mBuilder.isConvertDaysToHours;
    }

    public Boolean isShowDay() {
        return this.mBuilder.isShowDay;
    }

    public Boolean isShowHour() {
        return this.mBuilder.isShowHour;
    }

    public Boolean isShowMinute() {
        return this.mBuilder.isShowMinute;
    }

    public Boolean isShowSecond() {
        return this.mBuilder.isShowSecond;
    }

    public Boolean isShowMillisecond() {
        return this.mBuilder.isShowMillisecond;
    }

    public BackgroundInfo getBackgroundInfo() {
        return this.mBuilder.backgroundInfo;
    }

    public static class SuffixGravity {
        public static final int TOP = 0;
        public static final int CENTER = 1;
        public static final int BOTTOM = 2;
    }

    public static class BackgroundInfo {
        private boolean hasData = false;
        private Integer color;
        private Float size;
        private Float radius;
        private Boolean isShowDivisionLine;
        private Integer divisionLineColor;
        private Float divisionLineSize;
        private Boolean isShowBorder;
        private Integer borderColor;
        private Float borderRadius;
        private Float borderSize;

        public BackgroundInfo setColor(Integer color) {
            this.hasData = true;
            this.color = color;
            return this;
        }

        public BackgroundInfo setSize(Float size) {
            this.hasData = true;
            this.size = size;
            return this;
        }

        public BackgroundInfo setRadius(Float radius) {
            this.hasData = true;
            this.radius = radius;
            return this;
        }

        public BackgroundInfo setShowTimeBgDivisionLine(Boolean showTimeBgDivisionLine) {
            this.hasData = true;
            this.isShowDivisionLine = showTimeBgDivisionLine;
            return this;
        }

        public BackgroundInfo setDivisionLineSize(Float divisionLineSize) {
            this.hasData = true;
            this.divisionLineSize = divisionLineSize;
            return this;
        }

        public BackgroundInfo setDivisionLineColor(Integer divisionLineColor) {
            this.hasData = true;
            this.divisionLineColor = divisionLineColor;
            return this;
        }

        public BackgroundInfo setShowTimeBgBorder(Boolean showTimeBgBorder) {
            this.hasData = true;
            this.isShowBorder = showTimeBgBorder;
            return this;
        }

        public BackgroundInfo setBorderSize(Float borderSize) {
            this.hasData = true;
            this.borderSize = borderSize;
            return this;
        }

        public BackgroundInfo setBorderColor(Integer borderColor) {
            this.hasData = true;
            this.borderColor = borderColor;
            return this;
        }

        public BackgroundInfo setBorderRadius(Float borderRadius) {
            this.hasData = true;
            this.borderRadius = borderRadius;
            return this;
        }

        public Integer getColor() {
            return this.color;
        }

        public Integer getDivisionLineColor() {
            return this.divisionLineColor;
        }

        public Float getDivisionLineSize() {
            return this.divisionLineSize;
        }

        public Boolean isShowTimeBgDivisionLine() {
            return this.isShowDivisionLine;
        }

        public Float getRadius() {
            return this.radius;
        }

        public Float getSize() {
            return this.size;
        }

        public Boolean isShowTimeBgBorder() {
            return this.isShowBorder;
        }

        public Integer getBorderColor() {
            return this.borderColor;
        }

        public Float getBorderSize() {
            return this.borderSize;
        }

        public Float getBorderRadius() {
            return this.borderRadius;
        }
    }

    public static class Builder {
        private Float timeTextSize;
        private Integer timeTextColor;
        private Boolean isTimeTextBold;
        private Float suffixTextSize;
        private Integer suffixTextColor;
        private Integer suffixGravity;
        private Boolean isSuffixTextBold;
        private Boolean isShowDay;
        private Boolean isShowHour;
        private Boolean isShowMinute;
        private Boolean isShowSecond;
        private Boolean isShowMillisecond;
        private boolean isConvertDaysToHours;
        private BackgroundInfo backgroundInfo;
        private String suffix;
        private String suffixDay;
        private String suffixHour;
        private String suffixMinute;
        private String suffixSecond;
        private String suffixMillisecond;
        private Float suffixLRMargin;
        private Float suffixDayLeftMargin;
        private Float suffixDayRightMargin;
        private Float suffixSecondLeftMargin;
        private Float suffixSecondRightMargin;
        private Float suffixHourLeftMargin;
        private Float suffixHourRightMargin;
        private Float suffixMinuteLeftMargin;
        private Float suffixMinuteRightMargin;
        private Float suffixMillisecondLeftMargin;

        public Builder setTimeTextSize(float size) {
            this.timeTextSize = Float.valueOf(size);
            return this;
        }

        public Builder setTimeTextColor(int color) {
            this.timeTextColor = color;
            return this;
        }

        public Builder setTimeTextBold(boolean isBold) {
            this.isTimeTextBold = isBold;
            return this;
        }

        public Builder setSuffixTextSize(float size) {
            this.suffixTextSize = Float.valueOf(size);
            return this;
        }

        public Builder setSuffixTextColor(int color) {
            this.suffixTextColor = color;
            return this;
        }

        public Builder setSuffixTextBold(boolean isBold) {
            this.isSuffixTextBold = isBold;
            return this;
        }

        public Builder setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder setSuffixDay(String suffix) {
            this.suffixDay = suffix;
            return this;
        }

        public Builder setSuffixHour(String suffix) {
            this.suffixHour = suffix;
            return this;
        }

        public Builder setSuffixMinute(String suffix) {
            this.suffixMinute = suffix;
            return this;
        }

        public Builder setSuffixSecond(String suffix) {
            this.suffixSecond = suffix;
            return this;
        }

        public Builder setSuffixMillisecond(String suffix) {
            this.suffixMillisecond = suffix;
            return this;
        }

        public Builder setSuffixLRMargin(float margin) {
            this.suffixLRMargin = Float.valueOf(margin);
            return this;
        }

        public Builder setSuffixDayLeftMargin(float margin) {
            this.suffixDayLeftMargin = Float.valueOf(margin);
            return this;
        }

        public Builder setSuffixDayRightMargin(float margin) {
            this.suffixDayRightMargin = Float.valueOf(margin);
            return this;
        }

        public Builder setSuffixHourLeftMargin(float margin) {
            this.suffixHourLeftMargin = Float.valueOf(margin);
            return this;
        }

        public Builder setSuffixHourRightMargin(float margin) {
            this.suffixHourRightMargin = Float.valueOf(margin);
            return this;
        }

        public Builder setSuffixMinuteLeftMargin(float margin) {
            this.suffixMinuteLeftMargin = Float.valueOf(margin);
            return this;
        }

        public Builder setSuffixMinuteRightMargin(float margin) {
            this.suffixMinuteRightMargin = Float.valueOf(margin);
            return this;
        }

        public Builder setSuffixSecondLeftMargin(float margin) {
            this.suffixSecondLeftMargin = Float.valueOf(margin);
            return this;
        }

        public Builder setSuffixSecondRightMargin(float margin) {
            this.suffixSecondRightMargin = Float.valueOf(margin);
            return this;
        }

        public Builder setSuffixMillisecondLeftMargin(float margin) {
            this.suffixMillisecondLeftMargin = Float.valueOf(margin);
            return this;
        }

        public Builder setSuffixGravity(int suffixGravity) {
            this.suffixGravity = suffixGravity;
            return this;
        }

        public Builder setConvertDaysToHours(Boolean isConvertDaysToHours) {
            this.isConvertDaysToHours = isConvertDaysToHours;
            return this;
        }

        public Builder setShowDay(Boolean isShowDay) {
            this.isShowDay = isShowDay;
            return this;
        }

        public Builder setShowHour(Boolean isShowHour) {
            this.isShowHour = isShowHour;
            return this;
        }

        public Builder setShowMinute(Boolean isShowMinute) {
            this.isShowMinute = isShowMinute;
            return this;
        }

        public Builder setShowSecond(Boolean isShowSecond) {
            this.isShowSecond = isShowSecond;
            return this;
        }

        public Builder setShowMillisecond(Boolean isShowMillisecond) {
            this.isShowMillisecond = isShowMillisecond;
            return this;
        }

        public Builder setBackgroundInfo(BackgroundInfo backgroundInfo) {
            this.backgroundInfo = backgroundInfo;
            return this;
        }

        private void checkData() {
            if (null != this.timeTextSize && this.timeTextSize.floatValue() <= 0.0f) {
                this.timeTextSize = null;
            }
            if (null != this.suffixTextSize && this.suffixTextSize.floatValue() <= 0.0f) {
                this.suffixTextSize = null;
            }
            if (null != this.backgroundInfo && !this.backgroundInfo.hasData) {
                this.backgroundInfo = null;
            }
            if (null != this.backgroundInfo) {
                Boolean isShowTimeBgBorder;
                Boolean isShowTimeBgDivisionLine = this.backgroundInfo.isShowTimeBgDivisionLine();
                if (null == isShowTimeBgDivisionLine || !isShowTimeBgDivisionLine.booleanValue()) {
                    this.backgroundInfo.setDivisionLineColor(null);
                    this.backgroundInfo.setDivisionLineSize(null);
                }
                if (null == (isShowTimeBgBorder = this.backgroundInfo.isShowTimeBgBorder()) || !isShowTimeBgBorder.booleanValue()) {
                    this.backgroundInfo.setBorderColor(null);
                    this.backgroundInfo.setBorderRadius(null);
                    this.backgroundInfo.setBorderSize(null);
                }
                if (null != this.backgroundInfo.getSize() && this.backgroundInfo.getSize().floatValue() <= 0.0f) {
                    this.backgroundInfo.setSize(null);
                }
            }
            if (null != this.suffixGravity && (this.suffixGravity < 0 || this.suffixGravity > 2)) {
                this.suffixGravity = null;
            }
        }

        public DynamicConfig build() {
            this.checkData();
            return new DynamicConfig(this);
        }
    }
}

