/*
 * Decompiled with CFR 0.152.
 */
package cn.iwgang.countdownview;

import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;

public abstract class CustomCountDownTimer {
    private static final int MSG = 1;
    private final long mMillisInFuture;
    private final long mCountdownInterval;
    private long mStopTimeInFuture;
    private long mPauseTimeInFuture;
    private boolean isStop = false;
    private boolean isPause = false;
    private Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            CustomCountDownTimer customCountDownTimer = CustomCountDownTimer.this;
            synchronized (customCountDownTimer) {
                if (CustomCountDownTimer.this.isStop || CustomCountDownTimer.this.isPause) {
                    return;
                }
                long millisLeft = CustomCountDownTimer.this.mStopTimeInFuture - SystemClock.elapsedRealtime();
                if (millisLeft <= 0L) {
                    CustomCountDownTimer.this.onFinish();
                } else {
                    long delay;
                    long lastTickStart = SystemClock.elapsedRealtime();
                    CustomCountDownTimer.this.onTick(millisLeft);
                    for (delay = lastTickStart + CustomCountDownTimer.this.mCountdownInterval - SystemClock.elapsedRealtime(); delay < 0L; delay += CustomCountDownTimer.this.mCountdownInterval) {
                    }
                    this.sendMessageDelayed(this.obtainMessage(1), delay);
                }
            }
        }
    };

    public CustomCountDownTimer(long millisInFuture, long countDownInterval) {
        if (countDownInterval > 1000L) {
            millisInFuture += 15L;
        }
        this.mMillisInFuture = millisInFuture;
        this.mCountdownInterval = countDownInterval;
    }

    private synchronized CustomCountDownTimer start(long millisInFuture) {
        this.isStop = false;
        if (millisInFuture <= 0L) {
            this.onFinish();
            return this;
        }
        this.mStopTimeInFuture = SystemClock.elapsedRealtime() + millisInFuture;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
        return this;
    }

    public final synchronized void start() {
        this.start(this.mMillisInFuture);
    }

    public final synchronized void stop() {
        this.isStop = true;
        this.mHandler.removeMessages(1);
    }

    public final synchronized void pause() {
        if (this.isStop) {
            return;
        }
        this.isPause = true;
        this.mPauseTimeInFuture = this.mStopTimeInFuture - SystemClock.elapsedRealtime();
        this.mHandler.removeMessages(1);
    }

    public final synchronized void restart() {
        if (this.isStop || !this.isPause) {
            return;
        }
        this.isPause = false;
        this.start(this.mPauseTimeInFuture);
    }

    public abstract void onTick(long var1);

    public abstract void onFinish();
}

