/*
 * Decompiled with CFR 0.152.
 */
package cn.iwgang.countdownview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.View;
import cn.iwgang.countdownview.R;
import cn.iwgang.countdownview.Utils;

class BaseCountdown {
    private static final String DEFAULT_SUFFIX = ":";
    private static final float DEFAULT_SUFFIX_LR_MARGIN = 3.0f;
    public int mDay;
    public int mHour;
    public int mMinute;
    public int mSecond;
    public int mMillisecond;
    public boolean isShowDay;
    public boolean isShowHour;
    public boolean isShowMinute;
    public boolean isShowSecond;
    public boolean isShowMillisecond;
    public boolean isConvertDaysToHours;
    public boolean mHasSetIsShowDay;
    public boolean mHasSetIsShowHour;
    protected Context mContext;
    protected String mSuffix;
    protected String mSuffixDay;
    protected String mSuffixHour;
    protected String mSuffixMinute;
    protected String mSuffixSecond;
    protected String mSuffixMillisecond;
    protected float mSuffixDayTextWidth;
    protected float mSuffixHourTextWidth;
    protected float mSuffixMinuteTextWidth;
    protected float mSuffixSecondTextWidth;
    protected float mSuffixMillisecondTextWidth;
    protected boolean isDayLargeNinetyNine;
    protected Paint mTimeTextPaint;
    protected Paint mSuffixTextPaint;
    protected Paint mMeasureHourWidthPaint;
    protected float mLeftPaddingSize;
    protected float mSuffixDayLeftMargin;
    protected float mSuffixDayRightMargin;
    protected float mSuffixSecondLeftMargin;
    protected float mSuffixSecondRightMargin;
    protected float mSuffixHourLeftMargin;
    protected float mSuffixHourRightMargin;
    protected float mSuffixMinuteLeftMargin;
    protected float mSuffixMinuteRightMargin;
    protected float mSuffixMillisecondLeftMargin;
    protected float mSuffixDayTextBaseline;
    protected float mSuffixHourTextBaseline;
    protected float mSuffixMinuteTextBaseline;
    protected float mSuffixSecondTextBaseline;
    protected float mSuffixMillisecondTextBaseline;
    protected float mTimeTextWidth;
    protected float mTimeTextHeight;
    protected float mTimeTextBottom;
    protected int mSuffixGravity;
    private boolean hasSetSuffixDay;
    private boolean hasSetSuffixHour;
    private boolean hasSetSuffixMinute;
    private boolean hasSetSuffixSecond;
    private boolean hasSetSuffixMillisecond;
    private boolean hasCustomSomeSuffix;
    private float mSuffixLRMargin;
    private int mTimeTextColor;
    private float mTimeTextSize;
    private boolean isTimeTextBold;
    private int mSuffixTextColor;
    private float mSuffixTextSize;
    private boolean isSuffixTextBold;
    private float mDayTimeTextWidth;
    private float mHourTimeTextWidth;
    private float mTimeTextBaseline;
    private float mTempSuffixDayLeftMargin;
    private float mTempSuffixDayRightMargin;
    private float mTempSuffixHourLeftMargin;
    private float mTempSuffixHourRightMargin;
    private float mTempSuffixMinuteLeftMargin;
    private float mTempSuffixMinuteRightMargin;
    private float mTempSuffixSecondLeftMargin;
    private float mTempSuffixSecondRightMargin;
    private float mTempSuffixMillisecondLeftMargin;
    private String mTempSuffixMinute;
    private String mTempSuffixSecond;

    BaseCountdown() {
    }

    public void initStyleAttr(Context context, TypedArray ta) {
        this.mContext = context;
        this.isTimeTextBold = ta.getBoolean(R.styleable.CountdownView_isTimeTextBold, false);
        this.mTimeTextSize = ta.getDimension(R.styleable.CountdownView_timeTextSize, Utils.sp2px(this.mContext, 12.0f));
        this.mTimeTextColor = ta.getColor(R.styleable.CountdownView_timeTextColor, -16777216);
        this.isShowDay = ta.getBoolean(R.styleable.CountdownView_isShowDay, false);
        this.isShowHour = ta.getBoolean(R.styleable.CountdownView_isShowHour, false);
        this.isShowMinute = ta.getBoolean(R.styleable.CountdownView_isShowMinute, true);
        this.isShowSecond = ta.getBoolean(R.styleable.CountdownView_isShowSecond, true);
        this.isShowMillisecond = ta.getBoolean(R.styleable.CountdownView_isShowMillisecond, false);
        if (ta.getBoolean(R.styleable.CountdownView_isHideTimeBackground, true)) {
            this.isConvertDaysToHours = ta.getBoolean(R.styleable.CountdownView_isConvertDaysToHours, false);
        }
        this.isSuffixTextBold = ta.getBoolean(R.styleable.CountdownView_isSuffixTextBold, false);
        this.mSuffixTextSize = ta.getDimension(R.styleable.CountdownView_suffixTextSize, Utils.sp2px(this.mContext, 12.0f));
        this.mSuffixTextColor = ta.getColor(R.styleable.CountdownView_suffixTextColor, -16777216);
        this.mSuffix = ta.getString(R.styleable.CountdownView_suffix);
        this.mSuffixDay = ta.getString(R.styleable.CountdownView_suffixDay);
        this.mSuffixHour = ta.getString(R.styleable.CountdownView_suffixHour);
        this.mSuffixMinute = ta.getString(R.styleable.CountdownView_suffixMinute);
        this.mSuffixSecond = ta.getString(R.styleable.CountdownView_suffixSecond);
        this.mSuffixMillisecond = ta.getString(R.styleable.CountdownView_suffixMillisecond);
        this.mSuffixGravity = ta.getInt(R.styleable.CountdownView_suffixGravity, 1);
        this.mSuffixLRMargin = ta.getDimension(R.styleable.CountdownView_suffixLRMargin, -1.0f);
        this.mSuffixDayLeftMargin = ta.getDimension(R.styleable.CountdownView_suffixDayLeftMargin, -1.0f);
        this.mSuffixDayRightMargin = ta.getDimension(R.styleable.CountdownView_suffixDayRightMargin, -1.0f);
        this.mSuffixHourLeftMargin = ta.getDimension(R.styleable.CountdownView_suffixHourLeftMargin, -1.0f);
        this.mSuffixHourRightMargin = ta.getDimension(R.styleable.CountdownView_suffixHourRightMargin, -1.0f);
        this.mSuffixMinuteLeftMargin = ta.getDimension(R.styleable.CountdownView_suffixMinuteLeftMargin, -1.0f);
        this.mSuffixMinuteRightMargin = ta.getDimension(R.styleable.CountdownView_suffixMinuteRightMargin, -1.0f);
        this.mSuffixSecondLeftMargin = ta.getDimension(R.styleable.CountdownView_suffixSecondLeftMargin, -1.0f);
        this.mSuffixSecondRightMargin = ta.getDimension(R.styleable.CountdownView_suffixSecondRightMargin, -1.0f);
        this.mSuffixMillisecondLeftMargin = ta.getDimension(R.styleable.CountdownView_suffixMillisecondLeftMargin, -1.0f);
        this.mHasSetIsShowDay = ta.hasValue(R.styleable.CountdownView_isShowDay);
        this.mHasSetIsShowHour = ta.hasValue(R.styleable.CountdownView_isShowHour);
        this.initTempSuffixMargin();
        if (!(this.isShowDay || this.isShowHour || this.isShowMinute)) {
            this.isShowSecond = true;
        }
        if (!this.isShowSecond) {
            this.isShowMillisecond = false;
        }
    }

    public void initialize() {
        this.initSuffixBase();
        this.initPaint();
        this.initSuffix();
        if (!this.isShowSecond) {
            this.isShowMillisecond = false;
        }
        this.initTimeTextBaseInfo();
    }

    private void initSuffixBase() {
        this.hasSetSuffixDay = !TextUtils.isEmpty((CharSequence)this.mSuffixDay);
        this.hasSetSuffixHour = !TextUtils.isEmpty((CharSequence)this.mSuffixHour);
        this.hasSetSuffixMinute = !TextUtils.isEmpty((CharSequence)this.mSuffixMinute);
        this.hasSetSuffixSecond = !TextUtils.isEmpty((CharSequence)this.mSuffixSecond);
        boolean bl = this.hasSetSuffixMillisecond = !TextUtils.isEmpty((CharSequence)this.mSuffixMillisecond);
        if (this.isShowDay && this.hasSetSuffixDay || this.isShowHour && this.hasSetSuffixHour || this.isShowMinute && this.hasSetSuffixMinute || this.isShowSecond && this.hasSetSuffixSecond || this.isShowMillisecond && this.hasSetSuffixMillisecond) {
            this.hasCustomSomeSuffix = true;
        }
        this.mTempSuffixMinute = this.mSuffixMinute;
        this.mTempSuffixSecond = this.mSuffixSecond;
    }

    private void initTempSuffixMargin() {
        this.mTempSuffixDayLeftMargin = this.mSuffixDayLeftMargin;
        this.mTempSuffixDayRightMargin = this.mSuffixDayRightMargin;
        this.mTempSuffixHourLeftMargin = this.mSuffixHourLeftMargin;
        this.mTempSuffixHourRightMargin = this.mSuffixHourRightMargin;
        this.mTempSuffixMinuteLeftMargin = this.mSuffixMinuteLeftMargin;
        this.mTempSuffixMinuteRightMargin = this.mSuffixMinuteRightMargin;
        this.mTempSuffixSecondLeftMargin = this.mSuffixSecondLeftMargin;
        this.mTempSuffixSecondRightMargin = this.mSuffixSecondRightMargin;
        this.mTempSuffixMillisecondLeftMargin = this.mSuffixMillisecondLeftMargin;
    }

    protected void initPaint() {
        this.mTimeTextPaint = new Paint(1);
        this.mTimeTextPaint.setColor(this.mTimeTextColor);
        this.mTimeTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mTimeTextPaint.setTextSize(this.mTimeTextSize);
        if (this.isTimeTextBold) {
            this.mTimeTextPaint.setFakeBoldText(true);
        }
        this.mSuffixTextPaint = new Paint(1);
        this.mSuffixTextPaint.setColor(this.mSuffixTextColor);
        this.mSuffixTextPaint.setTextSize(this.mSuffixTextSize);
        if (this.isSuffixTextBold) {
            this.mSuffixTextPaint.setFakeBoldText(true);
        }
        this.mMeasureHourWidthPaint = new Paint();
        this.mMeasureHourWidthPaint.setTextSize(this.mTimeTextSize);
        if (this.isTimeTextBold) {
            this.mMeasureHourWidthPaint.setFakeBoldText(true);
        }
    }

    private void initSuffix() {
        boolean isSuffixNull = true;
        float mSuffixTextWidth = 0.0f;
        float mDefSuffixTextWidth = this.mSuffixTextPaint.measureText(DEFAULT_SUFFIX);
        if (!TextUtils.isEmpty((CharSequence)this.mSuffix)) {
            isSuffixNull = false;
            mSuffixTextWidth = this.mSuffixTextPaint.measureText(this.mSuffix);
        }
        if (this.isShowDay) {
            if (this.hasSetSuffixDay) {
                this.mSuffixDayTextWidth = this.mSuffixTextPaint.measureText(this.mSuffixDay);
            } else if (!isSuffixNull) {
                this.mSuffixDay = this.mSuffix;
                this.mSuffixDayTextWidth = mSuffixTextWidth;
            } else if (!this.hasCustomSomeSuffix) {
                this.mSuffixDay = DEFAULT_SUFFIX;
                this.mSuffixDayTextWidth = mDefSuffixTextWidth;
            }
        } else {
            this.mSuffixDayTextWidth = 0.0f;
        }
        if (this.isShowHour) {
            if (this.hasSetSuffixHour) {
                this.mSuffixHourTextWidth = this.mSuffixTextPaint.measureText(this.mSuffixHour);
            } else if (!isSuffixNull) {
                this.mSuffixHour = this.mSuffix;
                this.mSuffixHourTextWidth = mSuffixTextWidth;
            } else if (!this.hasCustomSomeSuffix) {
                this.mSuffixHour = DEFAULT_SUFFIX;
                this.mSuffixHourTextWidth = mDefSuffixTextWidth;
            }
        } else {
            this.mSuffixHourTextWidth = 0.0f;
        }
        if (this.isShowMinute) {
            if (this.hasSetSuffixMinute) {
                this.mSuffixMinuteTextWidth = this.mSuffixTextPaint.measureText(this.mSuffixMinute);
            } else if (this.isShowSecond) {
                if (!isSuffixNull) {
                    this.mSuffixMinute = this.mSuffix;
                    this.mSuffixMinuteTextWidth = mSuffixTextWidth;
                } else if (!this.hasCustomSomeSuffix) {
                    this.mSuffixMinute = DEFAULT_SUFFIX;
                    this.mSuffixMinuteTextWidth = mDefSuffixTextWidth;
                }
            } else {
                this.mSuffixMinuteTextWidth = 0.0f;
            }
        } else {
            this.mSuffixMinuteTextWidth = 0.0f;
        }
        if (this.isShowSecond) {
            if (this.hasSetSuffixSecond) {
                this.mSuffixSecondTextWidth = this.mSuffixTextPaint.measureText(this.mSuffixSecond);
            } else if (this.isShowMillisecond) {
                if (!isSuffixNull) {
                    this.mSuffixSecond = this.mSuffix;
                    this.mSuffixSecondTextWidth = mSuffixTextWidth;
                } else if (!this.hasCustomSomeSuffix) {
                    this.mSuffixSecond = DEFAULT_SUFFIX;
                    this.mSuffixSecondTextWidth = mDefSuffixTextWidth;
                }
            } else {
                this.mSuffixSecondTextWidth = 0.0f;
            }
        } else {
            this.mSuffixSecondTextWidth = 0.0f;
        }
        this.mSuffixMillisecondTextWidth = this.isShowMillisecond && this.hasCustomSomeSuffix && this.hasSetSuffixMillisecond ? this.mSuffixTextPaint.measureText(this.mSuffixMillisecond) : 0.0f;
        this.initSuffixMargin();
    }

    private void initSuffixMargin() {
        int defSuffixLRMargin = Utils.dp2px(this.mContext, 3.0f);
        boolean isSuffixLRMarginNull = true;
        if (this.mSuffixLRMargin >= 0.0f) {
            isSuffixLRMarginNull = false;
        }
        if (this.isShowDay && this.mSuffixDayTextWidth > 0.0f) {
            if (this.mSuffixDayLeftMargin < 0.0f) {
                this.mSuffixDayLeftMargin = !isSuffixLRMarginNull ? this.mSuffixLRMargin : (float)defSuffixLRMargin;
            }
            if (this.mSuffixDayRightMargin < 0.0f) {
                this.mSuffixDayRightMargin = !isSuffixLRMarginNull ? this.mSuffixLRMargin : (float)defSuffixLRMargin;
            }
        } else {
            this.mSuffixDayLeftMargin = 0.0f;
            this.mSuffixDayRightMargin = 0.0f;
        }
        if (this.isShowHour && this.mSuffixHourTextWidth > 0.0f) {
            if (this.mSuffixHourLeftMargin < 0.0f) {
                this.mSuffixHourLeftMargin = !isSuffixLRMarginNull ? this.mSuffixLRMargin : (float)defSuffixLRMargin;
            }
            if (this.mSuffixHourRightMargin < 0.0f) {
                this.mSuffixHourRightMargin = !isSuffixLRMarginNull ? this.mSuffixLRMargin : (float)defSuffixLRMargin;
            }
        } else {
            this.mSuffixHourLeftMargin = 0.0f;
            this.mSuffixHourRightMargin = 0.0f;
        }
        if (this.isShowMinute && this.mSuffixMinuteTextWidth > 0.0f) {
            if (this.mSuffixMinuteLeftMargin < 0.0f) {
                this.mSuffixMinuteLeftMargin = !isSuffixLRMarginNull ? this.mSuffixLRMargin : (float)defSuffixLRMargin;
            }
            if (this.isShowSecond) {
                if (this.mSuffixMinuteRightMargin < 0.0f) {
                    this.mSuffixMinuteRightMargin = !isSuffixLRMarginNull ? this.mSuffixLRMargin : (float)defSuffixLRMargin;
                }
            } else {
                this.mSuffixMinuteRightMargin = 0.0f;
            }
        } else {
            this.mSuffixMinuteLeftMargin = 0.0f;
            this.mSuffixMinuteRightMargin = 0.0f;
        }
        if (this.isShowSecond) {
            if (this.mSuffixSecondTextWidth > 0.0f) {
                if (this.mSuffixSecondLeftMargin < 0.0f) {
                    this.mSuffixSecondLeftMargin = !isSuffixLRMarginNull ? this.mSuffixLRMargin : (float)defSuffixLRMargin;
                }
                if (this.isShowMillisecond) {
                    if (this.mSuffixSecondRightMargin < 0.0f) {
                        this.mSuffixSecondRightMargin = !isSuffixLRMarginNull ? this.mSuffixLRMargin : (float)defSuffixLRMargin;
                    }
                } else {
                    this.mSuffixSecondRightMargin = 0.0f;
                }
            } else {
                this.mSuffixSecondLeftMargin = 0.0f;
                this.mSuffixSecondRightMargin = 0.0f;
            }
            if (this.isShowMillisecond && this.mSuffixMillisecondTextWidth > 0.0f) {
                if (this.mSuffixMillisecondLeftMargin < 0.0f) {
                    this.mSuffixMillisecondLeftMargin = !isSuffixLRMarginNull ? this.mSuffixLRMargin : (float)defSuffixLRMargin;
                }
            } else {
                this.mSuffixMillisecondLeftMargin = 0.0f;
            }
        } else {
            this.mSuffixSecondLeftMargin = 0.0f;
            this.mSuffixSecondRightMargin = 0.0f;
            this.mSuffixMillisecondLeftMargin = 0.0f;
        }
    }

    protected void initTimeTextBaseInfo() {
        Rect rect = new Rect();
        this.mTimeTextPaint.getTextBounds("00", 0, 2, rect);
        this.mTimeTextWidth = rect.width();
        this.mTimeTextHeight = rect.height();
        this.mTimeTextBottom = rect.bottom;
    }

    private void initTimeTextBaseline(int viewHeight, int viewPaddingTop, int viewPaddingBottom) {
        this.mTimeTextBaseline = viewPaddingTop == viewPaddingBottom ? (float)(viewHeight / 2) + this.mTimeTextHeight / 2.0f - this.mTimeTextBottom : (float)(viewHeight - (viewHeight - viewPaddingTop)) + this.mTimeTextHeight - this.mTimeTextBottom;
        if (this.isShowDay && this.mSuffixDayTextWidth > 0.0f) {
            this.mSuffixDayTextBaseline = this.getSuffixTextBaseLine(this.mSuffixDay);
        }
        if (this.isShowHour && this.mSuffixHourTextWidth > 0.0f) {
            this.mSuffixHourTextBaseline = this.getSuffixTextBaseLine(this.mSuffixHour);
        }
        if (this.isShowMinute && this.mSuffixMinuteTextWidth > 0.0f) {
            this.mSuffixMinuteTextBaseline = this.getSuffixTextBaseLine(this.mSuffixMinute);
        }
        if (this.mSuffixSecondTextWidth > 0.0f) {
            this.mSuffixSecondTextBaseline = this.getSuffixTextBaseLine(this.mSuffixSecond);
        }
        if (this.isShowMillisecond && this.mSuffixMillisecondTextWidth > 0.0f) {
            this.mSuffixMillisecondTextBaseline = this.getSuffixTextBaseLine(this.mSuffixMillisecond);
        }
    }

    private float getSuffixTextBaseLine(String suffixText) {
        float ret;
        Rect tempRect = new Rect();
        this.mSuffixTextPaint.getTextBounds(suffixText, 0, suffixText.length(), tempRect);
        switch (this.mSuffixGravity) {
            case 0: {
                ret = this.mTimeTextBaseline - this.mTimeTextHeight - (float)tempRect.top;
                break;
            }
            default: {
                ret = this.mTimeTextBaseline - this.mTimeTextHeight / 2.0f + (float)(tempRect.height() / 2);
                break;
            }
            case 2: {
                ret = this.mTimeTextBaseline - (float)tempRect.bottom;
            }
        }
        return ret;
    }

    protected final float getAllContentWidthBase(float timeWidth) {
        float width = this.mSuffixDayTextWidth + this.mSuffixHourTextWidth + this.mSuffixMinuteTextWidth + this.mSuffixSecondTextWidth + this.mSuffixMillisecondTextWidth;
        width += this.mSuffixDayLeftMargin + this.mSuffixDayRightMargin + this.mSuffixHourLeftMargin + this.mSuffixHourRightMargin + this.mSuffixMinuteLeftMargin + this.mSuffixMinuteRightMargin + this.mSuffixSecondLeftMargin + this.mSuffixSecondRightMargin + this.mSuffixMillisecondLeftMargin;
        if (this.isConvertDaysToHours) {
            width += this.getDayAndHourContentWidth();
        } else if (this.isShowHour) {
            width += timeWidth;
        }
        if (this.isShowMinute) {
            width += timeWidth;
        }
        if (this.isShowSecond) {
            width += timeWidth;
        }
        if (this.isShowMillisecond) {
            width += timeWidth;
        }
        return width;
    }

    private float getDayAndHourContentWidth() {
        float width = 0.0f;
        Rect tempRect = new Rect();
        if (this.isShowDay) {
            String tempDay = Utils.formatNum(this.mDay);
            this.mTimeTextPaint.getTextBounds(tempDay, 0, tempDay.length(), tempRect);
            this.mDayTimeTextWidth = tempRect.width();
            width += this.mDayTimeTextWidth;
        }
        if (this.isShowHour) {
            String tempHour = Utils.formatNum(this.mHour);
            this.mMeasureHourWidthPaint.getTextBounds(tempHour, 0, tempHour.length(), tempRect);
            this.mHourTimeTextWidth = tempRect.width();
            width += this.mHourTimeTextWidth;
        }
        return width;
    }

    public int getAllContentWidth() {
        float width = this.getAllContentWidthBase(this.mTimeTextWidth);
        if (!this.isConvertDaysToHours && this.isShowDay) {
            if (this.isDayLargeNinetyNine) {
                Rect rect = new Rect();
                String tempDay = String.valueOf(this.mDay);
                this.mTimeTextPaint.getTextBounds(tempDay, 0, tempDay.length(), rect);
                this.mDayTimeTextWidth = rect.width();
                width += this.mDayTimeTextWidth;
            } else {
                this.mDayTimeTextWidth = this.mTimeTextWidth;
                width += this.mTimeTextWidth;
            }
        }
        return (int)Math.ceil(width);
    }

    public int getAllContentHeight() {
        return (int)this.mTimeTextHeight;
    }

    public void onMeasure(View v, int viewWidth, int viewHeight, int allContentWidth, int allContentHeight) {
        this.initTimeTextBaseline(viewHeight, v.getPaddingTop(), v.getPaddingBottom());
        this.mLeftPaddingSize = v.getPaddingLeft() == v.getPaddingRight() ? (float)((viewWidth - allContentWidth) / 2) : (float)v.getPaddingLeft();
    }

    public void onDraw(Canvas canvas) {
        float mSecondLeft;
        float mMinuteLeft;
        float mHourLeft;
        if (this.isShowDay) {
            canvas.drawText(Utils.formatNum(this.mDay), this.mLeftPaddingSize + this.mDayTimeTextWidth / 2.0f, this.mTimeTextBaseline, this.mTimeTextPaint);
            if (this.mSuffixDayTextWidth > 0.0f) {
                canvas.drawText(this.mSuffixDay, this.mLeftPaddingSize + this.mDayTimeTextWidth + this.mSuffixDayLeftMargin, this.mSuffixDayTextBaseline, this.mSuffixTextPaint);
            }
            mHourLeft = this.mLeftPaddingSize + this.mDayTimeTextWidth + this.mSuffixDayTextWidth + this.mSuffixDayLeftMargin + this.mSuffixDayRightMargin;
        } else {
            mHourLeft = this.mLeftPaddingSize;
        }
        if (this.isShowHour) {
            float curTimeTextWidth = this.isConvertDaysToHours ? this.mHourTimeTextWidth : this.mTimeTextWidth;
            canvas.drawText(Utils.formatNum(this.mHour), mHourLeft + curTimeTextWidth / 2.0f, this.mTimeTextBaseline, this.mTimeTextPaint);
            if (this.mSuffixHourTextWidth > 0.0f) {
                canvas.drawText(this.mSuffixHour, mHourLeft + curTimeTextWidth + this.mSuffixHourLeftMargin, this.mSuffixHourTextBaseline, this.mSuffixTextPaint);
            }
            mMinuteLeft = mHourLeft + curTimeTextWidth + this.mSuffixHourTextWidth + this.mSuffixHourLeftMargin + this.mSuffixHourRightMargin;
        } else {
            mMinuteLeft = mHourLeft;
        }
        if (this.isShowMinute) {
            canvas.drawText(Utils.formatNum(this.mMinute), mMinuteLeft + this.mTimeTextWidth / 2.0f, this.mTimeTextBaseline, this.mTimeTextPaint);
            if (this.mSuffixMinuteTextWidth > 0.0f) {
                canvas.drawText(this.mSuffixMinute, mMinuteLeft + this.mTimeTextWidth + this.mSuffixMinuteLeftMargin, this.mSuffixMinuteTextBaseline, this.mSuffixTextPaint);
            }
            mSecondLeft = mMinuteLeft + this.mTimeTextWidth + this.mSuffixMinuteTextWidth + this.mSuffixMinuteLeftMargin + this.mSuffixMinuteRightMargin;
        } else {
            mSecondLeft = mMinuteLeft;
        }
        if (this.isShowSecond) {
            canvas.drawText(Utils.formatNum(this.mSecond), mSecondLeft + this.mTimeTextWidth / 2.0f, this.mTimeTextBaseline, this.mTimeTextPaint);
            if (this.mSuffixSecondTextWidth > 0.0f) {
                canvas.drawText(this.mSuffixSecond, mSecondLeft + this.mTimeTextWidth + this.mSuffixSecondLeftMargin, this.mSuffixSecondTextBaseline, this.mSuffixTextPaint);
            }
            if (this.isShowMillisecond) {
                float mMillisecondLeft = mSecondLeft + this.mTimeTextWidth + this.mSuffixSecondTextWidth + this.mSuffixSecondLeftMargin + this.mSuffixSecondRightMargin;
                canvas.drawText(Utils.formatMillisecond(this.mMillisecond), mMillisecondLeft + this.mTimeTextWidth / 2.0f, this.mTimeTextBaseline, this.mTimeTextPaint);
                if (this.mSuffixMillisecondTextWidth > 0.0f) {
                    canvas.drawText(this.mSuffixMillisecond, mMillisecondLeft + this.mTimeTextWidth + this.mSuffixMillisecondLeftMargin, this.mSuffixMillisecondTextBaseline, this.mSuffixTextPaint);
                }
            }
        }
    }

    public boolean refTimeShow(boolean isShowDay, boolean isShowHour, boolean isShowMinute, boolean isShowSecond, boolean isShowMillisecond) {
        if (!isShowSecond) {
            isShowMillisecond = false;
        }
        boolean isModCountdownInterval = false;
        if (this.isShowDay != isShowDay) {
            this.isShowDay = isShowDay;
            if (isShowDay) {
                this.mSuffixDayLeftMargin = this.mTempSuffixDayLeftMargin;
                this.mSuffixDayRightMargin = this.mTempSuffixDayRightMargin;
            }
        }
        if (this.isShowHour != isShowHour) {
            this.isShowHour = isShowHour;
            if (isShowHour) {
                this.mSuffixHourLeftMargin = this.mTempSuffixHourLeftMargin;
                this.mSuffixHourRightMargin = this.mTempSuffixHourRightMargin;
            }
        }
        if (this.isShowMinute != isShowMinute) {
            this.isShowMinute = isShowMinute;
            if (isShowMinute) {
                this.mSuffixMinuteLeftMargin = this.mTempSuffixMinuteLeftMargin;
                this.mSuffixMinuteRightMargin = this.mTempSuffixMinuteRightMargin;
                this.mSuffixMinute = this.mTempSuffixMinute;
            }
        }
        if (this.isShowSecond != isShowSecond) {
            this.isShowSecond = isShowSecond;
            isModCountdownInterval = true;
            if (isShowSecond) {
                this.mSuffixSecondLeftMargin = this.mTempSuffixSecondLeftMargin;
                this.mSuffixSecondRightMargin = this.mTempSuffixSecondRightMargin;
                this.mSuffixSecond = this.mTempSuffixSecond;
            } else {
                this.mSuffixMinute = this.mTempSuffixMinute;
            }
            this.mSuffixMinuteLeftMargin = this.mTempSuffixMinuteLeftMargin;
            this.mSuffixMinuteRightMargin = this.mTempSuffixMinuteRightMargin;
        }
        if (this.isShowMillisecond != isShowMillisecond) {
            this.isShowMillisecond = isShowMillisecond;
            isModCountdownInterval = true;
            if (isShowMillisecond) {
                this.mSuffixMillisecondLeftMargin = this.mTempSuffixMillisecondLeftMargin;
            } else {
                this.mSuffixSecond = this.mTempSuffixSecond;
            }
            this.mSuffixSecondLeftMargin = this.mTempSuffixSecondLeftMargin;
            this.mSuffixSecondRightMargin = this.mTempSuffixSecondRightMargin;
        }
        return isModCountdownInterval;
    }

    public boolean handlerAutoShowTime() {
        boolean isReLayout = false;
        if (!this.mHasSetIsShowDay) {
            if (!this.isShowDay && this.mDay > 0) {
                if (!this.mHasSetIsShowHour) {
                    this.refTimeShow(true, true, this.isShowMinute, this.isShowSecond, this.isShowMillisecond);
                } else {
                    this.refTimeShow(true, this.isShowHour, this.isShowMinute, this.isShowSecond, this.isShowMillisecond);
                }
                isReLayout = true;
            } else if (this.isShowDay && this.mDay == 0) {
                this.refTimeShow(false, this.isShowHour, this.isShowMinute, this.isShowSecond, this.isShowMillisecond);
                isReLayout = true;
            } else if (!this.mHasSetIsShowHour) {
                if (!(this.isShowHour || this.mDay <= 0 && this.mHour <= 0)) {
                    this.refTimeShow(this.isShowDay, true, this.isShowMinute, this.isShowSecond, this.isShowMillisecond);
                    isReLayout = true;
                } else if (this.isShowHour && this.mDay == 0 && this.mHour == 0) {
                    this.refTimeShow(false, false, this.isShowMinute, this.isShowSecond, this.isShowMillisecond);
                    isReLayout = true;
                }
            }
        } else if (!this.mHasSetIsShowHour) {
            if (!(this.isShowHour || this.mDay <= 0 && this.mHour <= 0)) {
                this.refTimeShow(this.isShowDay, true, this.isShowMinute, this.isShowSecond, this.isShowMillisecond);
                isReLayout = true;
            } else if (this.isShowHour && this.mDay == 0 && this.mHour == 0) {
                this.refTimeShow(this.isShowDay, false, this.isShowMinute, this.isShowSecond, this.isShowMillisecond);
                isReLayout = true;
            }
        }
        return isReLayout;
    }

    public boolean handlerDayLargeNinetyNine() {
        boolean isReLayout = false;
        if (this.isShowDay) {
            if (!this.isDayLargeNinetyNine && this.mDay > 99) {
                this.isDayLargeNinetyNine = true;
                isReLayout = true;
            } else if (this.isDayLargeNinetyNine && this.mDay <= 99) {
                this.isDayLargeNinetyNine = false;
                isReLayout = true;
            }
        }
        return isReLayout;
    }

    public void setTimes(int day, int hour, int minute, int second, int millisecond) {
        this.mDay = day;
        this.mHour = hour;
        this.mMinute = minute;
        this.mSecond = second;
        this.mMillisecond = millisecond;
    }

    public void reLayout() {
        this.initSuffix();
        this.initTimeTextBaseInfo();
    }

    public void setTimeTextSize(float textSize) {
        if (textSize > 0.0f) {
            this.mTimeTextSize = Utils.sp2px(this.mContext, textSize);
            this.mTimeTextPaint.setTextSize(this.mTimeTextSize);
        }
    }

    public void setTimeTextColor(int textColor) {
        this.mTimeTextColor = textColor;
        this.mTimeTextPaint.setColor(this.mTimeTextColor);
    }

    public void setTimeTextBold(boolean isBold) {
        this.isTimeTextBold = isBold;
        this.mTimeTextPaint.setFakeBoldText(this.isTimeTextBold);
    }

    public void setSuffixTextSize(float textSize) {
        if (textSize > 0.0f) {
            this.mSuffixTextSize = Utils.sp2px(this.mContext, textSize);
            this.mSuffixTextPaint.setTextSize(this.mSuffixTextSize);
        }
    }

    public void setSuffixTextColor(int textColor) {
        this.mSuffixTextColor = textColor;
        this.mSuffixTextPaint.setColor(this.mSuffixTextColor);
    }

    public void setSuffixTextBold(boolean isBold) {
        this.isSuffixTextBold = isBold;
        this.mSuffixTextPaint.setFakeBoldText(this.isSuffixTextBold);
    }

    public void setSuffix(String suffix) {
        this.mSuffix = suffix;
        this.setSuffix(this.mSuffix, this.mSuffix, this.mSuffix, this.mSuffix, this.mSuffix);
    }

    public boolean setConvertDaysToHours(boolean isConvertDaysToHours) {
        if (this.isConvertDaysToHours == isConvertDaysToHours) {
            return false;
        }
        this.isConvertDaysToHours = isConvertDaysToHours;
        return true;
    }

    public boolean setSuffix(String suffixDay, String suffixHour, String suffixMinute, String suffixSecond, String suffixMillisecond) {
        boolean isRef = false;
        if (null != suffixDay) {
            this.mSuffixDay = suffixDay;
            isRef = true;
        }
        if (null != suffixHour) {
            this.mSuffixHour = suffixHour;
            isRef = true;
        }
        if (null != suffixMinute) {
            this.mSuffixMinute = suffixMinute;
            isRef = true;
        }
        if (null != suffixSecond) {
            this.mSuffixSecond = suffixSecond;
            isRef = true;
        }
        if (null != suffixMillisecond) {
            this.mSuffixMillisecond = suffixMillisecond;
            isRef = true;
        }
        if (isRef) {
            this.initSuffixBase();
        }
        return isRef;
    }

    public void setSuffixLRMargin(float suffixLRMargin) {
        this.mSuffixLRMargin = Utils.dp2px(this.mContext, suffixLRMargin);
        this.setSuffixMargin(Float.valueOf(this.mSuffixDayLeftMargin), Float.valueOf(this.mSuffixDayLeftMargin), Float.valueOf(this.mSuffixDayLeftMargin), Float.valueOf(this.mSuffixDayLeftMargin), Float.valueOf(this.mSuffixDayLeftMargin), Float.valueOf(this.mSuffixDayLeftMargin), Float.valueOf(this.mSuffixDayLeftMargin), Float.valueOf(this.mSuffixDayLeftMargin), Float.valueOf(this.mSuffixDayLeftMargin));
    }

    public boolean setSuffixMargin(Float suffixDayMarginL, Float suffixDayMarginR, Float suffixHourMarginL, Float suffixHourMarginR, Float suffixMinuteMarginL, Float suffixMinuteMarginR, Float suffixSecondMarginL, Float suffixSecondMarginR, Float suffixMillisecondMarginL) {
        boolean isRef = false;
        if (null != suffixDayMarginL) {
            this.mSuffixDayLeftMargin = Utils.dp2px(this.mContext, suffixDayMarginL.floatValue());
            isRef = true;
        }
        if (null != suffixDayMarginR) {
            this.mSuffixDayRightMargin = Utils.dp2px(this.mContext, suffixDayMarginR.floatValue());
            isRef = true;
        }
        if (null != suffixHourMarginL) {
            this.mSuffixHourLeftMargin = Utils.dp2px(this.mContext, suffixHourMarginL.floatValue());
            isRef = true;
        }
        if (null != suffixHourMarginR) {
            this.mSuffixHourRightMargin = Utils.dp2px(this.mContext, suffixHourMarginR.floatValue());
            isRef = true;
        }
        if (null != suffixMinuteMarginL) {
            this.mSuffixMinuteLeftMargin = Utils.dp2px(this.mContext, suffixMinuteMarginL.floatValue());
            isRef = true;
        }
        if (null != suffixMinuteMarginR) {
            this.mSuffixMinuteRightMargin = Utils.dp2px(this.mContext, suffixMinuteMarginR.floatValue());
            isRef = true;
        }
        if (null != suffixSecondMarginL) {
            this.mSuffixSecondLeftMargin = Utils.dp2px(this.mContext, suffixSecondMarginL.floatValue());
            isRef = true;
        }
        if (null != suffixSecondMarginR) {
            this.mSuffixSecondRightMargin = Utils.dp2px(this.mContext, suffixSecondMarginR.floatValue());
            isRef = true;
        }
        if (null != suffixMillisecondMarginL) {
            this.mSuffixMillisecondLeftMargin = Utils.dp2px(this.mContext, suffixMillisecondMarginL.floatValue());
            isRef = true;
        }
        if (isRef) {
            this.initTempSuffixMargin();
        }
        return isRef;
    }

    public void setSuffixGravity(int suffixGravity) {
        this.mSuffixGravity = suffixGravity;
    }
}

