/*
 * Decompiled with CFR 0.152.
 */
package cn.iwgang.countdownview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import cn.iwgang.countdownview.BaseCountdown;
import cn.iwgang.countdownview.R;
import cn.iwgang.countdownview.Utils;

class BackgroundCountdown
extends BaseCountdown {
    private static final float DEFAULT_TIME_BG_DIVISION_LINE_SIZE = 0.5f;
    private static final float DEFAULT_TIME_BG_BORDER_SIZE = 1.0f;
    private boolean isDrawBg;
    private boolean isShowTimeBgDivisionLine;
    private int mTimeBgDivisionLineColor;
    private float mTimeBgDivisionLineSize;
    private float mTimeBgRadius;
    private float mTimeBgSize;
    private int mTimeBgColor;
    private Paint mTimeBgPaint;
    private Paint mTimeBgBorderPaint;
    private Paint mTimeBgDivisionLinePaint;
    private float mDefSetTimeBgSize;
    private float mDayTimeBgWidth;
    private RectF mDayBgRectF;
    private RectF mHourBgRectF;
    private RectF mMinuteBgRectF;
    private RectF mSecondBgRectF;
    private RectF mMillisecondBgRectF;
    private RectF mDayBgBorderRectF;
    private RectF mHourBgBorderRectF;
    private RectF mMinuteBgBorderRectF;
    private RectF mSecondBgBorderRectF;
    private RectF mMillisecondBgBorderRectF;
    private float mTimeBgDivisionLineYPos;
    private float mTimeTextBaseY;
    private boolean isShowTimeBgBorder;
    private float mTimeBgBorderSize;
    private float mTimeBgBorderRadius;
    private int mTimeBgBorderColor;

    BackgroundCountdown() {
    }

    @Override
    public void initStyleAttr(Context context, TypedArray ta) {
        super.initStyleAttr(context, ta);
        this.mTimeBgColor = ta.getColor(R.styleable.CountdownView_timeBgColor, -12303292);
        this.mTimeBgRadius = ta.getDimension(R.styleable.CountdownView_timeBgRadius, 0.0f);
        this.isShowTimeBgDivisionLine = ta.getBoolean(R.styleable.CountdownView_isShowTimeBgDivisionLine, true);
        this.mTimeBgDivisionLineColor = ta.getColor(R.styleable.CountdownView_timeBgDivisionLineColor, Color.parseColor((String)"#30FFFFFF"));
        this.mTimeBgDivisionLineSize = ta.getDimension(R.styleable.CountdownView_timeBgDivisionLineSize, (float)Utils.dp2px(context, 0.5f));
        this.mDefSetTimeBgSize = this.mTimeBgSize = ta.getDimension(R.styleable.CountdownView_timeBgSize, 0.0f);
        this.mTimeBgBorderSize = ta.getDimension(R.styleable.CountdownView_timeBgBorderSize, (float)Utils.dp2px(context, 1.0f));
        this.mTimeBgBorderRadius = ta.getDimension(R.styleable.CountdownView_timeBgBorderRadius, 0.0f);
        this.mTimeBgBorderColor = ta.getColor(R.styleable.CountdownView_timeBgBorderColor, -16777216);
        this.isShowTimeBgBorder = ta.getBoolean(R.styleable.CountdownView_isShowTimeBgBorder, false);
        this.isDrawBg = ta.hasValue(R.styleable.CountdownView_timeBgColor) || !this.isShowTimeBgBorder;
    }

    @Override
    protected void initPaint() {
        super.initPaint();
        this.mTimeBgPaint = new Paint(1);
        this.mTimeBgPaint.setStyle(Paint.Style.FILL);
        this.mTimeBgPaint.setColor(this.mTimeBgColor);
        if (this.isShowTimeBgBorder) {
            this.initTimeBgBorderPaint();
        }
        if (this.isShowTimeBgDivisionLine) {
            this.initTimeTextBgDivisionLinePaint();
        }
    }

    private void initTimeBgBorderPaint() {
        if (null != this.mTimeBgBorderPaint) {
            return;
        }
        this.mTimeBgBorderPaint = new Paint(1);
        this.mTimeBgBorderPaint.setColor(this.mTimeBgBorderColor);
        if (!this.isDrawBg) {
            this.mTimeBgBorderPaint.setStrokeWidth(this.mTimeBgBorderSize);
            this.mTimeBgBorderPaint.setStyle(Paint.Style.STROKE);
        }
    }

    private void initTimeTextBgDivisionLinePaint() {
        if (null != this.mTimeBgDivisionLinePaint) {
            return;
        }
        this.mTimeBgDivisionLinePaint = new Paint(1);
        this.mTimeBgDivisionLinePaint.setColor(this.mTimeBgDivisionLineColor);
        this.mTimeBgDivisionLinePaint.setStrokeWidth(this.mTimeBgDivisionLineSize);
    }

    @Override
    protected void initTimeTextBaseInfo() {
        super.initTimeTextBaseInfo();
        if (this.mDefSetTimeBgSize == 0.0f || this.mTimeBgSize < this.mTimeTextWidth) {
            this.mTimeBgSize = this.mTimeTextWidth + (float)(Utils.dp2px(this.mContext, 2.0f) * 4);
        }
    }

    private void initTimeBgRect(float topPaddingSize) {
        float mSecondLeft;
        float mMinuteLeft;
        float mHourLeft;
        boolean isInitHasBackgroundTextBaseY = false;
        if (this.isShowDay) {
            if (this.isShowTimeBgBorder) {
                this.mDayBgBorderRectF = new RectF(this.mLeftPaddingSize, topPaddingSize, this.mLeftPaddingSize + this.mDayTimeBgWidth + this.mTimeBgBorderSize * 2.0f, topPaddingSize + this.mTimeBgSize + this.mTimeBgBorderSize * 2.0f);
                this.mDayBgRectF = new RectF(this.mLeftPaddingSize + this.mTimeBgBorderSize, topPaddingSize + this.mTimeBgBorderSize, this.mLeftPaddingSize + this.mDayTimeBgWidth + this.mTimeBgBorderSize, topPaddingSize + this.mTimeBgSize + this.mTimeBgBorderSize);
            } else {
                this.mDayBgRectF = new RectF(this.mLeftPaddingSize, topPaddingSize, this.mLeftPaddingSize + this.mDayTimeBgWidth, topPaddingSize + this.mTimeBgSize);
            }
            mHourLeft = this.mLeftPaddingSize + this.mDayTimeBgWidth + this.mSuffixDayTextWidth + this.mSuffixDayLeftMargin + this.mSuffixDayRightMargin + this.mTimeBgBorderSize * 2.0f;
            if (!(this.isShowHour || this.isShowMinute || this.isShowSecond)) {
                isInitHasBackgroundTextBaseY = true;
                this.initHasBackgroundTextBaseY(this.mDayBgRectF);
            }
        } else {
            mHourLeft = this.mLeftPaddingSize;
        }
        if (this.isShowHour) {
            if (this.isShowTimeBgBorder) {
                this.mHourBgBorderRectF = new RectF(mHourLeft, topPaddingSize, mHourLeft + this.mTimeBgSize + this.mTimeBgBorderSize * 2.0f, topPaddingSize + this.mTimeBgSize + this.mTimeBgBorderSize * 2.0f);
                this.mHourBgRectF = new RectF(mHourLeft + this.mTimeBgBorderSize, topPaddingSize + this.mTimeBgBorderSize, mHourLeft + this.mTimeBgSize + this.mTimeBgBorderSize, topPaddingSize + this.mTimeBgSize + this.mTimeBgBorderSize);
            } else {
                this.mHourBgRectF = new RectF(mHourLeft, topPaddingSize, mHourLeft + this.mTimeBgSize, topPaddingSize + this.mTimeBgSize);
            }
            mMinuteLeft = mHourLeft + this.mTimeBgSize + this.mSuffixHourTextWidth + this.mSuffixHourLeftMargin + this.mSuffixHourRightMargin + this.mTimeBgBorderSize * 2.0f;
            if (!isInitHasBackgroundTextBaseY) {
                isInitHasBackgroundTextBaseY = true;
                this.initHasBackgroundTextBaseY(this.mHourBgRectF);
            }
        } else {
            mMinuteLeft = mHourLeft;
        }
        if (this.isShowMinute) {
            if (this.isShowTimeBgBorder) {
                this.mMinuteBgBorderRectF = new RectF(mMinuteLeft, topPaddingSize, mMinuteLeft + this.mTimeBgSize + this.mTimeBgBorderSize * 2.0f, topPaddingSize + this.mTimeBgSize + this.mTimeBgBorderSize * 2.0f);
                this.mMinuteBgRectF = new RectF(mMinuteLeft + this.mTimeBgBorderSize, topPaddingSize + this.mTimeBgBorderSize, mMinuteLeft + this.mTimeBgSize + this.mTimeBgBorderSize, topPaddingSize + this.mTimeBgSize + this.mTimeBgBorderSize);
            } else {
                this.mMinuteBgRectF = new RectF(mMinuteLeft, topPaddingSize, mMinuteLeft + this.mTimeBgSize, topPaddingSize + this.mTimeBgSize);
            }
            mSecondLeft = mMinuteLeft + this.mTimeBgSize + this.mSuffixMinuteTextWidth + this.mSuffixMinuteLeftMargin + this.mSuffixMinuteRightMargin + this.mTimeBgBorderSize * 2.0f;
            if (!isInitHasBackgroundTextBaseY) {
                isInitHasBackgroundTextBaseY = true;
                this.initHasBackgroundTextBaseY(this.mMinuteBgRectF);
            }
        } else {
            mSecondLeft = mMinuteLeft;
        }
        if (this.isShowSecond) {
            if (this.isShowTimeBgBorder) {
                this.mSecondBgBorderRectF = new RectF(mSecondLeft, topPaddingSize, mSecondLeft + this.mTimeBgSize + this.mTimeBgBorderSize * 2.0f, topPaddingSize + this.mTimeBgSize + this.mTimeBgBorderSize * 2.0f);
                this.mSecondBgRectF = new RectF(mSecondLeft + this.mTimeBgBorderSize, topPaddingSize + this.mTimeBgBorderSize, mSecondLeft + this.mTimeBgSize + this.mTimeBgBorderSize, topPaddingSize + this.mTimeBgSize + this.mTimeBgBorderSize);
            } else {
                this.mSecondBgRectF = new RectF(mSecondLeft, topPaddingSize, mSecondLeft + this.mTimeBgSize, topPaddingSize + this.mTimeBgSize);
            }
            if (this.isShowMillisecond) {
                float mMillisecondLeft = mSecondLeft + this.mTimeBgSize + this.mSuffixSecondTextWidth + this.mSuffixSecondLeftMargin + this.mSuffixSecondRightMargin + this.mTimeBgBorderSize * 2.0f;
                if (this.isShowTimeBgBorder) {
                    this.mMillisecondBgBorderRectF = new RectF(mMillisecondLeft, topPaddingSize, mMillisecondLeft + this.mTimeBgSize + this.mTimeBgBorderSize * 2.0f, topPaddingSize + this.mTimeBgSize + this.mTimeBgBorderSize * 2.0f);
                    this.mMillisecondBgRectF = new RectF(mMillisecondLeft + this.mTimeBgBorderSize, topPaddingSize + this.mTimeBgBorderSize, mMillisecondLeft + this.mTimeBgSize + this.mTimeBgBorderSize, topPaddingSize + this.mTimeBgSize + this.mTimeBgBorderSize);
                } else {
                    this.mMillisecondBgRectF = new RectF(mMillisecondLeft, topPaddingSize, mMillisecondLeft + this.mTimeBgSize, topPaddingSize + this.mTimeBgSize);
                }
            }
            if (!isInitHasBackgroundTextBaseY) {
                this.initHasBackgroundTextBaseY(this.mSecondBgRectF);
            }
        }
    }

    private float getSuffixTextBaseLine(String suffixText, float topPaddingSize) {
        float ret;
        Rect tempRect = new Rect();
        this.mSuffixTextPaint.getTextBounds(suffixText, 0, suffixText.length(), tempRect);
        switch (this.mSuffixGravity) {
            case 0: {
                ret = topPaddingSize - (float)tempRect.top;
                break;
            }
            default: {
                ret = topPaddingSize + this.mTimeBgSize - this.mTimeBgSize / 2.0f + (float)(tempRect.height() / 2) + this.mTimeBgBorderSize;
                break;
            }
            case 2: {
                ret = topPaddingSize + this.mTimeBgSize - (float)tempRect.bottom + this.mTimeBgBorderSize * 2.0f;
            }
        }
        return ret;
    }

    private void initHasBackgroundTextBaseY(RectF rectF) {
        Paint.FontMetrics timeFontMetrics = this.mTimeTextPaint.getFontMetrics();
        this.mTimeTextBaseY = rectF.top + (rectF.bottom - rectF.top - timeFontMetrics.bottom + timeFontMetrics.top) / 2.0f - timeFontMetrics.top - this.mTimeTextBottom;
        this.mTimeBgDivisionLineYPos = rectF.centerY() + (this.mTimeBgDivisionLineSize == (float)Utils.dp2px(this.mContext, 0.5f) ? this.mTimeBgDivisionLineSize : this.mTimeBgDivisionLineSize / 2.0f);
    }

    private float initTimeTextBaselineAndTimeBgTopPadding(int viewHeight, int viewPaddingTop, int viewPaddingBottom, int contentAllHeight) {
        float topPaddingSize = viewPaddingTop == viewPaddingBottom ? (float)((viewHeight - contentAllHeight) / 2) : (float)viewPaddingTop;
        if (this.isShowDay && this.mSuffixDayTextWidth > 0.0f) {
            this.mSuffixDayTextBaseline = this.getSuffixTextBaseLine(this.mSuffixDay, topPaddingSize);
        }
        if (this.isShowHour && this.mSuffixHourTextWidth > 0.0f) {
            this.mSuffixHourTextBaseline = this.getSuffixTextBaseLine(this.mSuffixHour, topPaddingSize);
        }
        if (this.isShowMinute && this.mSuffixMinuteTextWidth > 0.0f) {
            this.mSuffixMinuteTextBaseline = this.getSuffixTextBaseLine(this.mSuffixMinute, topPaddingSize);
        }
        if (this.mSuffixSecondTextWidth > 0.0f) {
            this.mSuffixSecondTextBaseline = this.getSuffixTextBaseLine(this.mSuffixSecond, topPaddingSize);
        }
        if (this.isShowMillisecond && this.mSuffixMillisecondTextWidth > 0.0f) {
            this.mSuffixMillisecondTextBaseline = this.getSuffixTextBaseLine(this.mSuffixMillisecond, topPaddingSize);
        }
        return topPaddingSize;
    }

    @Override
    public int getAllContentWidth() {
        float width = this.getAllContentWidthBase(this.mTimeBgSize + this.mTimeBgBorderSize * 2.0f);
        if (this.isShowDay) {
            if (this.isDayLargeNinetyNine) {
                Rect rect = new Rect();
                String tempDay = String.valueOf(this.mDay);
                this.mTimeTextPaint.getTextBounds(tempDay, 0, tempDay.length(), rect);
                this.mDayTimeBgWidth = rect.width() + Utils.dp2px(this.mContext, 2.0f) * 4;
                width += this.mDayTimeBgWidth;
            } else {
                this.mDayTimeBgWidth = this.mTimeBgSize;
                width += this.mTimeBgSize;
            }
            width += this.mTimeBgBorderSize * 2.0f;
        }
        return (int)Math.ceil(width);
    }

    @Override
    public int getAllContentHeight() {
        return (int)(this.mTimeBgSize + this.mTimeBgBorderSize * 2.0f);
    }

    @Override
    public void onMeasure(View v, int viewWidth, int viewHeight, int allContentWidth, int allContentHeight) {
        float retTopPaddingSize = this.initTimeTextBaselineAndTimeBgTopPadding(viewHeight, v.getPaddingTop(), v.getPaddingBottom(), allContentHeight);
        this.mLeftPaddingSize = v.getPaddingLeft() == v.getPaddingRight() ? (float)((viewWidth - allContentWidth) / 2) : (float)v.getPaddingLeft();
        this.initTimeBgRect(retTopPaddingSize);
    }

    @Override
    public void onDraw(Canvas canvas) {
        float mSecondLeft;
        float mMinuteLeft;
        float mHourLeft;
        if (this.isShowDay) {
            if (this.isShowTimeBgBorder) {
                canvas.drawRoundRect(this.mDayBgBorderRectF, this.mTimeBgBorderRadius, this.mTimeBgBorderRadius, this.mTimeBgBorderPaint);
            }
            if (this.isDrawBg) {
                canvas.drawRoundRect(this.mDayBgRectF, this.mTimeBgRadius, this.mTimeBgRadius, this.mTimeBgPaint);
                if (this.isShowTimeBgDivisionLine) {
                    canvas.drawLine(this.mLeftPaddingSize + this.mTimeBgBorderSize, this.mTimeBgDivisionLineYPos, this.mLeftPaddingSize + this.mDayTimeBgWidth + this.mTimeBgBorderSize, this.mTimeBgDivisionLineYPos, this.mTimeBgDivisionLinePaint);
                }
            }
            canvas.drawText(Utils.formatNum(this.mDay), this.mDayBgRectF.centerX(), this.mTimeTextBaseY, this.mTimeTextPaint);
            if (this.mSuffixDayTextWidth > 0.0f) {
                canvas.drawText(this.mSuffixDay, this.mLeftPaddingSize + this.mDayTimeBgWidth + this.mSuffixDayLeftMargin + this.mTimeBgBorderSize * 2.0f, this.mSuffixDayTextBaseline, this.mSuffixTextPaint);
            }
            mHourLeft = this.mLeftPaddingSize + this.mDayTimeBgWidth + this.mSuffixDayTextWidth + this.mSuffixDayLeftMargin + this.mSuffixDayRightMargin + this.mTimeBgBorderSize * 2.0f;
        } else {
            mHourLeft = this.mLeftPaddingSize;
        }
        if (this.isShowHour) {
            if (this.isShowTimeBgBorder) {
                canvas.drawRoundRect(this.mHourBgBorderRectF, this.mTimeBgBorderRadius, this.mTimeBgBorderRadius, this.mTimeBgBorderPaint);
            }
            if (this.isDrawBg) {
                canvas.drawRoundRect(this.mHourBgRectF, this.mTimeBgRadius, this.mTimeBgRadius, this.mTimeBgPaint);
                if (this.isShowTimeBgDivisionLine) {
                    canvas.drawLine(mHourLeft + this.mTimeBgBorderSize, this.mTimeBgDivisionLineYPos, this.mTimeBgSize + mHourLeft + this.mTimeBgBorderSize, this.mTimeBgDivisionLineYPos, this.mTimeBgDivisionLinePaint);
                }
            }
            canvas.drawText(Utils.formatNum(this.mHour), this.mHourBgRectF.centerX(), this.mTimeTextBaseY, this.mTimeTextPaint);
            if (this.mSuffixHourTextWidth > 0.0f) {
                canvas.drawText(this.mSuffixHour, mHourLeft + this.mTimeBgSize + this.mSuffixHourLeftMargin + this.mTimeBgBorderSize * 2.0f, this.mSuffixHourTextBaseline, this.mSuffixTextPaint);
            }
            mMinuteLeft = mHourLeft + this.mTimeBgSize + this.mSuffixHourTextWidth + this.mSuffixHourLeftMargin + this.mSuffixHourRightMargin + this.mTimeBgBorderSize * 2.0f;
        } else {
            mMinuteLeft = mHourLeft;
        }
        if (this.isShowMinute) {
            if (this.isShowTimeBgBorder) {
                canvas.drawRoundRect(this.mMinuteBgBorderRectF, this.mTimeBgBorderRadius, this.mTimeBgBorderRadius, this.mTimeBgBorderPaint);
            }
            if (this.isDrawBg) {
                canvas.drawRoundRect(this.mMinuteBgRectF, this.mTimeBgRadius, this.mTimeBgRadius, this.mTimeBgPaint);
                if (this.isShowTimeBgDivisionLine) {
                    canvas.drawLine(mMinuteLeft + this.mTimeBgBorderSize, this.mTimeBgDivisionLineYPos, this.mTimeBgSize + mMinuteLeft + this.mTimeBgBorderSize, this.mTimeBgDivisionLineYPos, this.mTimeBgDivisionLinePaint);
                }
            }
            canvas.drawText(Utils.formatNum(this.mMinute), this.mMinuteBgRectF.centerX(), this.mTimeTextBaseY, this.mTimeTextPaint);
            if (this.mSuffixMinuteTextWidth > 0.0f) {
                canvas.drawText(this.mSuffixMinute, mMinuteLeft + this.mTimeBgSize + this.mSuffixMinuteLeftMargin + this.mTimeBgBorderSize * 2.0f, this.mSuffixMinuteTextBaseline, this.mSuffixTextPaint);
            }
            mSecondLeft = mMinuteLeft + this.mTimeBgSize + this.mSuffixMinuteTextWidth + this.mSuffixMinuteLeftMargin + this.mSuffixMinuteRightMargin + this.mTimeBgBorderSize * 2.0f;
        } else {
            mSecondLeft = mMinuteLeft;
        }
        if (this.isShowSecond) {
            if (this.isShowTimeBgBorder) {
                canvas.drawRoundRect(this.mSecondBgBorderRectF, this.mTimeBgBorderRadius, this.mTimeBgBorderRadius, this.mTimeBgBorderPaint);
            }
            if (this.isDrawBg) {
                canvas.drawRoundRect(this.mSecondBgRectF, this.mTimeBgRadius, this.mTimeBgRadius, this.mTimeBgPaint);
                if (this.isShowTimeBgDivisionLine) {
                    canvas.drawLine(mSecondLeft + this.mTimeBgBorderSize, this.mTimeBgDivisionLineYPos, this.mTimeBgSize + mSecondLeft + this.mTimeBgBorderSize, this.mTimeBgDivisionLineYPos, this.mTimeBgDivisionLinePaint);
                }
            }
            canvas.drawText(Utils.formatNum(this.mSecond), this.mSecondBgRectF.centerX(), this.mTimeTextBaseY, this.mTimeTextPaint);
            if (this.mSuffixSecondTextWidth > 0.0f) {
                canvas.drawText(this.mSuffixSecond, mSecondLeft + this.mTimeBgSize + this.mSuffixSecondLeftMargin + this.mTimeBgBorderSize * 2.0f, this.mSuffixSecondTextBaseline, this.mSuffixTextPaint);
            }
            if (this.isShowMillisecond) {
                if (this.isShowTimeBgBorder) {
                    canvas.drawRoundRect(this.mMillisecondBgBorderRectF, this.mTimeBgBorderRadius, this.mTimeBgBorderRadius, this.mTimeBgBorderPaint);
                }
                float mMillisecondLeft = mSecondLeft + this.mTimeBgSize + this.mSuffixSecondTextWidth + this.mSuffixSecondLeftMargin + this.mSuffixSecondRightMargin + this.mTimeBgBorderSize * 2.0f;
                if (this.isDrawBg) {
                    canvas.drawRoundRect(this.mMillisecondBgRectF, this.mTimeBgRadius, this.mTimeBgRadius, this.mTimeBgPaint);
                    if (this.isShowTimeBgDivisionLine) {
                        canvas.drawLine(mMillisecondLeft + this.mTimeBgBorderSize, this.mTimeBgDivisionLineYPos, this.mTimeBgSize + mMillisecondLeft + this.mTimeBgBorderSize, this.mTimeBgDivisionLineYPos, this.mTimeBgDivisionLinePaint);
                    }
                }
                canvas.drawText(Utils.formatMillisecond(this.mMillisecond), this.mMillisecondBgRectF.centerX(), this.mTimeTextBaseY, this.mTimeTextPaint);
                if (this.mSuffixMillisecondTextWidth > 0.0f) {
                    canvas.drawText(this.mSuffixMillisecond, mMillisecondLeft + this.mTimeBgSize + this.mSuffixMillisecondLeftMargin + this.mTimeBgBorderSize * 2.0f, this.mSuffixMillisecondTextBaseline, this.mSuffixTextPaint);
                }
            }
        }
    }

    public void setTimeBgSize(float size) {
        this.mTimeBgSize = Utils.dp2px(this.mContext, size);
    }

    public void setTimeBgColor(int color) {
        this.mTimeBgColor = color;
        this.mTimeBgPaint.setColor(this.mTimeBgColor);
        if (color == 0 && this.isShowTimeBgBorder) {
            this.isDrawBg = false;
            this.mTimeBgBorderPaint.setStrokeWidth(this.mTimeBgBorderSize);
            this.mTimeBgBorderPaint.setStyle(Paint.Style.STROKE);
        } else {
            this.isDrawBg = true;
            if (this.isShowTimeBgBorder) {
                this.mTimeBgBorderPaint.setStrokeWidth(0.0f);
                this.mTimeBgBorderPaint.setStyle(Paint.Style.FILL);
            }
        }
    }

    public void setTimeBgRadius(float radius) {
        this.mTimeBgRadius = Utils.dp2px(this.mContext, radius);
    }

    public void setIsShowTimeBgDivisionLine(boolean isShow) {
        this.isShowTimeBgDivisionLine = isShow;
        if (this.isShowTimeBgDivisionLine) {
            this.initTimeTextBgDivisionLinePaint();
        } else {
            this.mTimeBgDivisionLinePaint = null;
        }
    }

    public void setTimeBgDivisionLineColor(int color) {
        this.mTimeBgDivisionLineColor = color;
        if (null != this.mTimeBgDivisionLinePaint) {
            this.mTimeBgDivisionLinePaint.setColor(this.mTimeBgDivisionLineColor);
        }
    }

    public void setTimeBgDivisionLineSize(float size) {
        this.mTimeBgDivisionLineSize = Utils.dp2px(this.mContext, size);
        if (null != this.mTimeBgDivisionLinePaint) {
            this.mTimeBgDivisionLinePaint.setStrokeWidth(this.mTimeBgDivisionLineSize);
        }
    }

    public void setIsShowTimeBgBorder(boolean isShow) {
        this.isShowTimeBgBorder = isShow;
        if (this.isShowTimeBgBorder) {
            this.initTimeBgBorderPaint();
        } else {
            this.mTimeBgBorderPaint = null;
            this.mTimeBgBorderSize = 0.0f;
        }
    }

    public void setTimeBgBorderColor(int color) {
        this.mTimeBgBorderColor = color;
        if (null != this.mTimeBgBorderPaint) {
            this.mTimeBgBorderPaint.setColor(this.mTimeBgBorderColor);
        }
    }

    public void setTimeBgBorderSize(float size) {
        this.mTimeBgBorderSize = Utils.dp2px(this.mContext, size);
        if (null != this.mTimeBgBorderPaint && !this.isDrawBg) {
            this.mTimeBgBorderPaint.setStrokeWidth(this.mTimeBgBorderSize);
            this.mTimeBgBorderPaint.setStyle(Paint.Style.STROKE);
        }
    }

    public void setTimeBgBorderRadius(float size) {
        this.mTimeBgBorderRadius = Utils.dp2px(this.mContext, size);
    }
}

