/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.font.FontCharacteristics;
import com.itextpdf.layout.font.FontInfo;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSet;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TextSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("text_content")) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            String xRawValue = (String)this.attributesAndStyles.get("x");
            String yRawValue = (String)this.attributesAndStyles.get("y");
            String fontSizeRawValue = (String)this.attributesAndStyles.get("font-size");
            List<String> xValuesList = SvgCssUtils.splitValueList(xRawValue);
            List<String> yValuesList = SvgCssUtils.splitValueList(yRawValue);
            float x = 0.0f;
            float y = 0.0f;
            float fontSize = 0.0f;
            if (fontSizeRawValue != null && !fontSizeRawValue.isEmpty()) {
                fontSize = CssUtils.parseAbsoluteLength((String)fontSizeRawValue, (String)"pt");
            }
            if (!xValuesList.isEmpty()) {
                x = CssUtils.parseAbsoluteLength((String)xValuesList.get(0));
            }
            if (!yValuesList.isEmpty()) {
                y = CssUtils.parseAbsoluteLength((String)yValuesList.get(0));
            }
            currentCanvas.beginText();
            FontProvider provider = context.getFontProvider();
            FontSet tempFonts = context.getTempFonts();
            PdfFont font = null;
            if (!provider.getFontSet().isEmpty() || tempFonts != null && !tempFonts.isEmpty()) {
                String fontFamily = (String)this.attributesAndStyles.get("font-family");
                String fontWeight = (String)this.attributesAndStyles.get("font-weight");
                String fontStyle = (String)this.attributesAndStyles.get("font-style");
                fontFamily = fontFamily != null ? fontFamily.trim() : "";
                FontInfo fontInfo = this.resolveFontName(fontFamily, fontWeight, fontStyle, provider, tempFonts);
                font = provider.getPdfFont(fontInfo, tempFonts);
            }
            if (font == null) {
                try {
                    font = PdfFontFactory.createFont();
                }
                catch (IOException e) {
                    throw new SvgProcessingException("The font wasn't found.", e);
                }
            }
            currentCanvas.setFontAndSize(font, fontSize);
            currentCanvas.setTextMatrix(1.0f, 0.0f, 0.0f, -1.0f, x, y);
            currentCanvas.setColor(ColorConstants.BLACK, true);
            currentCanvas.showText((String)this.attributesAndStyles.get("text_content"));
            currentCanvas.endText();
        }
    }

    private FontInfo resolveFontName(String fontFamily, String fontWeight, String fontStyle, FontProvider provider, FontSet tempFonts) {
        boolean isBold = fontWeight != null && fontWeight.equalsIgnoreCase("bold");
        boolean isItalic = fontStyle != null && fontStyle.equalsIgnoreCase("italic");
        FontCharacteristics fontCharacteristics = new FontCharacteristics();
        ArrayList<String> stringArrayList = new ArrayList<String>();
        stringArrayList.add(fontFamily);
        fontCharacteristics.setBoldFlag(isBold);
        fontCharacteristics.setItalicFlag(isItalic);
        return provider.getFontSelector(stringArrayList, fontCharacteristics, tempFonts).bestMatch();
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        TextSvgNodeRenderer copy = new TextSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }
}

