/*
 * Decompiled with CFR 0.152.
 */
package com.ismaeldivita.chipnavigation.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextPaint;
import androidx.annotation.ColorInt;
import com.ismaeldivita.chipnavigation.R;
import com.ismaeldivita.chipnavigation.view.BadgeDrawable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020\bH\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\bH\u0016J\u0010\u0010#\u001a\u00020\u001c2\b\b\u0001\u0010$\u001a\u00020\bJ\u0012\u0010%\u001a\u00020\u001c2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u000e\u0010(\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0015\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006*"}, d2={"Lcom/ismaeldivita/chipnavigation/view/BadgeDrawable;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "value", "", "count", "getCount", "()I", "setCount", "(I)V", "parentBounds", "Landroid/graphics/Rect;", "shapeDrawable", "Landroid/graphics/drawable/GradientDrawable;", "getShapeDrawable", "()Landroid/graphics/drawable/GradientDrawable;", "shapeDrawable$delegate", "Lkotlin/Lazy;", "textPaint", "Landroid/text/TextPaint;", "getTextPaint", "()Landroid/text/TextPaint;", "textPaint$delegate", "draw", "", "canvas", "Landroid/graphics/Canvas;", "drawText", "getOpacity", "setAlpha", "alpha", "setColor", "color", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "updateBadgeBounds", "Companion", "chip-navigation-bar_release"})
public final class BadgeDrawable
extends Drawable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private int count;
    @Nullable
    private Rect parentBounds;
    @NotNull
    private final Lazy shapeDrawable$delegate;
    @NotNull
    private final Lazy textPaint$delegate;
    private static final int MAX_BADGE_COUNT = 99;

    public BadgeDrawable(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.shapeDrawable$delegate = LazyKt.lazy((Function0)shapeDrawable.2.INSTANCE);
        this.textPaint$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TextPaint>(this){
            final /* synthetic */ BadgeDrawable this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TextPaint invoke() {
                TextPaint textPaint2 = new TextPaint();
                BadgeDrawable badgeDrawable = this.this$0;
                TextPaint $this$invoke_u24lambda_u2d0 = textPaint2;
                boolean bl = false;
                $this$invoke_u24lambda_u2d0.setAntiAlias(true);
                $this$invoke_u24lambda_u2d0.setColor(-1);
                $this$invoke_u24lambda_u2d0.setTextSize(badgeDrawable.getContext().getResources().getDimension(R.dimen.cnb_badge_text_size));
                $this$invoke_u24lambda_u2d0.setFakeBoldText(true);
                $this$invoke_u24lambda_u2d0.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
                return textPaint2;
            }
        }));
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final int getCount() {
        return this.count;
    }

    public final void setCount(int value) {
        this.count = value;
        Rect rect = this.parentBounds;
        if (rect != null) {
            Rect p0 = rect;
            boolean bl = false;
            this.updateBadgeBounds(p0);
        }
    }

    private final GradientDrawable getShapeDrawable() {
        Lazy lazy = this.shapeDrawable$delegate;
        return (GradientDrawable)lazy.getValue();
    }

    private final TextPaint getTextPaint() {
        Lazy lazy = this.textPaint$delegate;
        return (TextPaint)lazy.getValue();
    }

    public final void setColor(@ColorInt int color2) {
        this.getShapeDrawable().setColor(color2);
    }

    public final void updateBadgeBounds(@NotNull Rect parentBounds) {
        Intrinsics.checkNotNullParameter((Object)parentBounds, (String)"parentBounds");
        this.parentBounds = parentBounds;
        int size = this.count > 0 ? this.context.getResources().getDimensionPixelSize(R.dimen.cnb_badge_size) : this.context.getResources().getDimensionPixelSize(R.dimen.cnb_badge_size_numberless);
        double extraPadding = this.count > 99 ? 1.5 : 1.0;
        this.getShapeDrawable().setCornerRadius((float)parentBounds.height() * 0.5f);
        this.getShapeDrawable().setBounds(parentBounds.right - MathKt.roundToInt((double)((double)size * extraPadding)), 0, parentBounds.right, parentBounds.top + size);
    }

    public void setAlpha(int alpha) {
        this.getShapeDrawable().setAlpha(alpha);
    }

    public int getOpacity() {
        return -3;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.getShapeDrawable().getBounds().isEmpty()) {
            this.getShapeDrawable().draw(canvas);
            if (this.count > 0) {
                this.drawText(canvas);
            }
        }
    }

    private final void drawText(Canvas canvas) {
        Rect textBounds = new Rect();
        String countText = this.count > 99 ? "99+" : String.valueOf(this.count);
        this.getTextPaint().getTextBounds(countText, 0, countText.length(), textBounds);
        canvas.drawText(countText, this.getShapeDrawable().getBounds().exactCenterX() - textBounds.exactCenterX(), this.getShapeDrawable().getBounds().exactCenterY() + (float)(textBounds.height() / 2), (Paint)this.getTextPaint());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ismaeldivita/chipnavigation/view/BadgeDrawable$Companion;", "", "()V", "MAX_BADGE_COUNT", "", "chip-navigation-bar_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

