/*
 * Decompiled with CFR 0.152.
 */
package io.sigpipe.jbsdiff;

import io.sigpipe.jbsdiff.ControlBlock;
import io.sigpipe.jbsdiff.Header;
import io.sigpipe.jbsdiff.InvalidHeaderException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorException;

public class Patch {
    private Patch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void patch(byte[] old, byte[] patch, OutputStream out) throws CompressorException, InvalidHeaderException, IOException {
        ByteArrayInputStream headerIn = new ByteArrayInputStream(patch);
        Header header = new Header(headerIn);
        ((InputStream)headerIn).close();
        ByteArrayInputStream controlIn = new ByteArrayInputStream(patch);
        ByteArrayInputStream dataIn = new ByteArrayInputStream(patch);
        ByteArrayInputStream extraIn = new ByteArrayInputStream(patch);
        try {
            ((InputStream)controlIn).skip(32L);
            ((InputStream)dataIn).skip(32 + header.getControlLength());
            ((InputStream)extraIn).skip(32 + header.getControlLength() + header.getDiffLength());
            int newPointer = 0;
            int oldPointer = 0;
            byte[] output = new byte[header.getOutputLength()];
            while (newPointer < output.length) {
                ControlBlock control = new ControlBlock(controlIn);
                Patch.read(dataIn, output, newPointer, control.getDiffLength());
                for (int i = 0; i < control.getDiffLength(); ++i) {
                    if (oldPointer + i < 0 || oldPointer + i >= old.length) continue;
                    int n = newPointer + i;
                    output[n] = (byte)(output[n] + old[oldPointer + i]);
                }
                oldPointer += control.getDiffLength();
                Patch.read(extraIn, output, newPointer += control.getDiffLength(), control.getExtraLength());
                newPointer += control.getExtraLength();
                oldPointer += control.getSeekLength();
            }
            out.write(output);
        }
        finally {
            ((InputStream)controlIn).close();
            ((InputStream)dataIn).close();
            ((InputStream)extraIn).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void patch(File oldFile, File newFile, File patchFile) throws CompressorException, InvalidHeaderException, IOException {
        FileInputStream headerIn = new FileInputStream(patchFile);
        Header header = new Header(headerIn);
        ((InputStream)headerIn).close();
        BufferedInputStream controlIn = new BufferedInputStream(new FileInputStream(patchFile));
        BufferedInputStream dataIn = new BufferedInputStream(new FileInputStream(patchFile));
        BufferedInputStream extraIn = new BufferedInputStream(new FileInputStream(patchFile));
        try {
            ((InputStream)controlIn).skip(32L);
            ((InputStream)dataIn).skip(32 + header.getControlLength());
            ((InputStream)extraIn).skip(32 + header.getControlLength() + header.getDiffLength());
            FileInputStream oldStream = new FileInputStream(oldFile);
            byte[] old = new byte[(int)oldFile.length()];
            oldStream.read(old);
            oldStream.close();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newFile));
            int newPointer = 0;
            int oldPointer = 0;
            int outputLength = header.getOutputLength();
            while (newPointer < outputLength) {
                ControlBlock control = new ControlBlock(controlIn);
                int diffLength = control.getDiffLength();
                int extraLength = control.getExtraLength();
                byte[] output = new byte[diffLength + extraLength];
                Patch.read(dataIn, output, 0, diffLength);
                for (int i = 0; i < diffLength; ++i) {
                    if (oldPointer + i < 0 || oldPointer + i >= old.length) continue;
                    int n = i;
                    output[n] = (byte)(output[n] + old[oldPointer + i]);
                }
                newPointer += diffLength;
                oldPointer += diffLength;
                Patch.read(extraIn, output, diffLength, extraLength);
                ((OutputStream)out).write(output);
                newPointer += extraLength;
                oldPointer += control.getSeekLength();
            }
            ((OutputStream)out).close();
        }
        finally {
            ((InputStream)controlIn).close();
            ((InputStream)dataIn).close();
            ((InputStream)extraIn).close();
        }
    }

    private static void read(InputStream in, byte[] dest, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        int read = in.read(dest, off, len);
        if (read < len) {
            throw new IOException("Corrupt patch; bytes expected = " + len + " bytes read = " + read);
        }
    }
}

