/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx.Components;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.Toast;
import com.github.irshulx.EditorCore;
import com.github.irshulx.R;
import com.github.irshulx.models.EditorType;
import com.github.irshulx.models.RenderType;

public class DividerExtensions {
    private int dividerLayout = R.layout.tmpl_divider_layout;
    EditorCore editorCore;

    public DividerExtensions(EditorCore editorCore) {
        this.editorCore = editorCore;
    }

    public void setDividerLayout(int layout2) {
        this.dividerLayout = layout2;
    }

    public void insertDivider() {
        View view = ((Activity)this.editorCore.getContext()).getLayoutInflater().inflate(this.dividerLayout, null);
        view.setTag((Object)this.editorCore.createTag(EditorType.hr));
        int index = this.editorCore.determineIndex(EditorType.hr);
        if (index == 0) {
            Toast.makeText((Context)this.editorCore.getContext(), (CharSequence)"divider cannot be inserted on line zero", (int)0).show();
            return;
        }
        this.editorCore.getParentView().addView(view, index);
        if (this.editorCore.isLastRow(view) && this.editorCore.getRenderType() == RenderType.Editor) {
            this.editorCore.getInputExtensions().insertEditText(index + 1, null, null);
        } else if (this.editorCore.getRenderType() == RenderType.Editor) {
            // empty if block
        }
    }

    public boolean deleteHr(int indexOfDeleteItem) {
        View view = this.editorCore.getParentView().getChildAt(indexOfDeleteItem);
        if (view == null || this.editorCore.getControlType(view) == EditorType.hr) {
            this.editorCore.getParentView().removeView(view);
            return true;
        }
        return false;
    }
}

