/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx.Components;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.text.util.Linkify;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.irshulx.Components.CustomEditText;
import com.github.irshulx.EditorCore;
import com.github.irshulx.R;
import com.github.irshulx.models.EditorControl;
import com.github.irshulx.models.EditorType;
import com.github.irshulx.models.RenderType;
import com.squareup.picasso.Picasso;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

public class ImageExtensions {
    private EditorCore editorCore;
    private int editorImageLayout = R.layout.tmpl_image_view;

    public ImageExtensions(EditorCore editorCore) {
        this.editorCore = editorCore;
    }

    public void setEditorImageLayout(int drawable2) {
        this.editorImageLayout = drawable2;
    }

    public void executeDownloadImageTask(String url, int index, String desc) {
        new DownloadImageTask(index).execute(new String[]{url, desc});
    }

    public void openImageGallery() {
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        ((Activity)this.editorCore.getContext()).startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Select an image"), this.editorCore.PICK_IMAGE_REQUEST);
    }

    public void insertImage(Bitmap image, String url, int index, String subTitle, boolean appendTextline) {
        boolean hasUploaded = false;
        if (!TextUtils.isEmpty((CharSequence)url)) {
            hasUploaded = true;
        }
        View childLayout = ((Activity)this.editorCore.getContext()).getLayoutInflater().inflate(this.editorImageLayout, null);
        ImageView imageView = (ImageView)childLayout.findViewById(R.id.imageView);
        TextView lblStatus = (TextView)childLayout.findViewById(R.id.lblStatus);
        CustomEditText desc = (CustomEditText)childLayout.findViewById(R.id.desc);
        if (!TextUtils.isEmpty((CharSequence)url)) {
            Picasso.with((Context)this.editorCore.getContext()).load(url).into(imageView);
        } else {
            imageView.setImageBitmap(image);
        }
        String uuid = this.generateUUID();
        if (index == -1) {
            index = this.editorCore.determineIndex(EditorType.img);
        }
        this.showNextInputHint(index);
        this.editorCore.getParentView().addView(childLayout, index);
        EditorControl control = this.editorCore.createTag(EditorType.img);
        control.path = hasUploaded ? url : uuid;
        childLayout.setTag((Object)control);
        if (this.editorCore.isLastRow(childLayout) && appendTextline) {
            this.editorCore.getInputExtensions().insertEditText(index + 1, null, null);
        }
        if (!TextUtils.isEmpty((CharSequence)subTitle)) {
            desc.setText(subTitle);
        }
        if (this.editorCore.getRenderType() == RenderType.Editor) {
            this.BindEvents(childLayout);
            if (!hasUploaded) {
                lblStatus.setVisibility(0);
                childLayout.findViewById(R.id.progress).setVisibility(0);
                this.editorCore.getEditorListener().onUpload(image, uuid);
            }
        } else {
            desc.setEnabled(false);
            lblStatus.setVisibility(8);
        }
    }

    private void showNextInputHint(int index) {
        View view = this.editorCore.getParentView().getChildAt(index);
        EditorType type = this.editorCore.getControlType(view);
        if (type != EditorType.INPUT) {
            return;
        }
        TextView tv = (TextView)view;
        tv.setHint((CharSequence)this.editorCore.placeHolder);
        Linkify.addLinks((TextView)tv, (int)15);
    }

    private void hideInputHint(int index) {
        View prevView;
        EditorType prevType;
        View view = this.editorCore.getParentView().getChildAt(index);
        EditorType type = this.editorCore.getControlType(view);
        if (type != EditorType.INPUT) {
            return;
        }
        String hint = this.editorCore.placeHolder;
        if (index > 0 && (prevType = this.editorCore.getControlType(prevView = this.editorCore.getParentView().getChildAt(index - 1))) == EditorType.INPUT) {
            hint = null;
        }
        TextView tv = (TextView)view;
        tv.setHint((CharSequence)hint);
    }

    public String generateUUID() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String sdt = df.format(new Date(System.currentTimeMillis()));
        UUID x = UUID.randomUUID();
        String[] y = x.toString().split("-");
        return y[y.length - 1] + sdt;
    }

    public void loadImage(String _path, String desc) {
        View childLayout = ((Activity)this.editorCore.getContext()).getLayoutInflater().inflate(this.editorImageLayout, null);
        ImageView imageView = (ImageView)childLayout.findViewById(R.id.imageView);
        CustomEditText text = (CustomEditText)childLayout.findViewById(R.id.desc);
        EditorControl control = this.editorCore.createTag(EditorType.img);
        control.path = _path;
        childLayout.setTag((Object)control);
        if (TextUtils.isEmpty((CharSequence)desc)) {
            text.setVisibility(8);
        } else {
            text.setText(desc);
            text.setEnabled(false);
        }
        Picasso.with((Context)this.editorCore.getContext()).load(_path).into(imageView);
        this.editorCore.getParentView().addView(childLayout);
    }

    public View findImageById(String imageId) {
        for (int i = 0; i < this.editorCore.getParentChildCount(); ++i) {
            View view = this.editorCore.getParentView().getChildAt(i);
            EditorControl control = this.editorCore.getControlTag(view);
            if (TextUtils.isEmpty((CharSequence)control.path) || !control.path.equals(imageId)) continue;
            return view;
        }
        return null;
    }

    public void onPostUpload(String url, String imageId) {
        View view = this.findImageById(imageId);
        final TextView lblStatus = (TextView)view.findViewById(R.id.lblStatus);
        lblStatus.setText((CharSequence)(!TextUtils.isEmpty((CharSequence)url) ? "Upload complete" : "Upload failed"));
        if (!TextUtils.isEmpty((CharSequence)url)) {
            EditorControl control = this.editorCore.createTag(EditorType.img);
            control.path = url;
            view.setTag((Object)control);
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    ((Activity)ImageExtensions.this.editorCore.getContext()).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            lblStatus.setVisibility(8);
                        }
                    });
                }
            };
            new Timer().schedule(timerTask, 3000L);
        }
        view.findViewById(R.id.progress).setVisibility(8);
    }

    private void BindEvents(final View layout2) {
        final ImageView imageView = (ImageView)layout2.findViewById(R.id.imageView);
        final View btn_remove = layout2.findViewById(R.id.btn_remove);
        btn_remove.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int index = ImageExtensions.this.editorCore.getParentView().indexOfChild(layout2);
                ImageExtensions.this.editorCore.getParentView().removeView(layout2);
                ImageExtensions.this.hideInputHint(index);
                ImageExtensions.this.editorCore.getInputExtensions().setFocusToPrevious(index);
            }
        });
        imageView.setOnTouchListener(new View.OnTouchListener(){
            private Rect rect;

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    imageView.setColorFilter(Color.argb((int)50, (int)0, (int)0, (int)0));
                    this.rect = new Rect(v.getLeft(), v.getTop(), v.getRight(), v.getBottom());
                }
                if (event.getAction() == 1) {
                    imageView.setColorFilter(Color.argb((int)0, (int)0, (int)0, (int)0));
                }
                if (event.getAction() == 2 && !this.rect.contains(v.getLeft() + (int)event.getX(), v.getTop() + (int)event.getY())) {
                    imageView.setColorFilter(Color.argb((int)0, (int)0, (int)0, (int)0));
                }
                return false;
            }
        });
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                btn_remove.setVisibility(0);
            }
        });
        imageView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                btn_remove.setVisibility(hasFocus ? 0 : 8);
            }
        });
    }

    private class DownloadImageTask
    extends AsyncTask<String, Void, Bitmap> {
        private int InsertIndex;
        private String subTitle;
        private String url;

        public DownloadImageTask(int index) {
            this.InsertIndex = index;
        }

        protected Bitmap doInBackground(String ... urls) {
            this.url = urls[0];
            this.subTitle = urls[1];
            Bitmap mIcon11 = null;
            try {
                InputStream in = new URL(this.url).openStream();
                mIcon11 = BitmapFactory.decodeStream((InputStream)in);
            }
            catch (Exception e) {
                Log.e((String)"Error", (String)e.getMessage());
                e.printStackTrace();
            }
            return mIcon11;
        }

        protected void onPostExecute(Bitmap result) {
            ImageExtensions.this.insertImage(result, this.url, this.InsertIndex, this.subTitle, true);
        }
    }
}

