/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.text.Editable;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Display;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TableLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.github.irshulx.Components.CustomEditText;
import com.github.irshulx.Components.DividerExtensions;
import com.github.irshulx.Components.HTMLExtensions;
import com.github.irshulx.Components.ImageExtensions;
import com.github.irshulx.Components.InputExtensions;
import com.github.irshulx.Components.ListItemExtensions;
import com.github.irshulx.Components.MapExtensions;
import com.github.irshulx.EditorListener;
import com.github.irshulx.R;
import com.github.irshulx.models.EditorContent;
import com.github.irshulx.models.EditorControl;
import com.github.irshulx.models.EditorTextStyle;
import com.github.irshulx.models.EditorType;
import com.github.irshulx.models.Node;
import com.github.irshulx.models.Op;
import com.github.irshulx.models.RenderType;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;

public class EditorCore
extends LinearLayout {
    public String placeHolder = null;
    public boolean autoFocus = true;
    private final String SHAREDPREFERENCE = "QA";
    private Context __context;
    protected LinearLayout __parentView;
    private RenderType __renderType;
    private Resources __resources;
    private View __activeView;
    private Gson __gson;
    private Utilities __utilities;
    private EditorListener __listener;
    public final int MAP_MARKER_REQUEST = 20;
    public final int PICK_IMAGE_REQUEST = 1;
    private InputExtensions __inputExtensions;
    private ImageExtensions __imageExtensions;
    private ListItemExtensions __listItemExtensions;
    private DividerExtensions __dividerExtensions;
    private HTMLExtensions __htmlExtensions;
    private MapExtensions __mapExtensions;
    private boolean stateFresh;

    public EditorCore(Context _context, AttributeSet attrs) {
        super(_context, attrs);
        this.__context = _context;
        this.setOrientation(1);
        this.initialize(_context, attrs);
    }

    private void initialize(Context context, AttributeSet attrs) {
        this.loadStateFromAttrs(attrs);
        this.__utilities = new Utilities();
        this.stateFresh = true;
        this.__resources = context.getResources();
        this.__gson = new Gson();
        this.__inputExtensions = new InputExtensions(this);
        this.__imageExtensions = new ImageExtensions(this);
        this.__listItemExtensions = new ListItemExtensions(this);
        this.__dividerExtensions = new DividerExtensions(this);
        this.__mapExtensions = new MapExtensions(this);
        this.__htmlExtensions = new HTMLExtensions(this);
        this.__parentView = this;
    }

    public Activity getActivity() {
        return (Activity)this.__context;
    }

    public LinearLayout getParentView() {
        return this.__parentView;
    }

    public int getParentChildCount() {
        return this.__parentView.getChildCount();
    }

    public RenderType getRenderType() {
        return this.__renderType;
    }

    public Resources getResources() {
        return this.__resources;
    }

    public View getActiveView() {
        return this.__activeView;
    }

    public void setActiveView(View view) {
        this.__activeView = view;
    }

    public Utilities getUtilitiles() {
        return this.__utilities;
    }

    public EditorListener getEditorListener() {
        return this.__listener;
    }

    public void setEditorListener(EditorListener _listener) {
        this.__listener = _listener;
    }

    public InputExtensions getInputExtensions() {
        return this.__inputExtensions;
    }

    public ImageExtensions getImageExtensions() {
        return this.__imageExtensions;
    }

    public MapExtensions getMapExtensions() {
        return this.__mapExtensions;
    }

    public HTMLExtensions getHtmlExtensions() {
        return this.__htmlExtensions;
    }

    public ListItemExtensions getListItemExtensions() {
        return this.__listItemExtensions;
    }

    public DividerExtensions getDividerExtensions() {
        return this.__dividerExtensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStateFromAttrs(AttributeSet attributeSet) {
        if (attributeSet == null) {
            return;
        }
        TypedArray a = null;
        try {
            a = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.editor);
            this.placeHolder = a.getString(R.styleable.editor_placeholder);
            this.autoFocus = a.getBoolean(R.styleable.editor_auto_focus, true);
            String renderType = a.getString(R.styleable.editor_render_type);
            this.__renderType = TextUtils.isEmpty((CharSequence)renderType) ? RenderType.Editor : (renderType.toLowerCase().equals("renderer") ? RenderType.Renderer : RenderType.Editor);
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
    }

    public int determineIndex(EditorType type) {
        int size = this.__parentView.getChildCount();
        if (this.__renderType == RenderType.Renderer) {
            return size;
        }
        View _view = this.__activeView;
        if (_view == null) {
            return size;
        }
        int currentIndex = this.__parentView.indexOfChild(_view);
        EditorType tag = this.getControlType(_view);
        if (tag == EditorType.INPUT) {
            int length = ((EditText)this.__activeView).getText().length();
            if (length > 0) {
                return type == EditorType.UL_LI || type == EditorType.OL_LI ? currentIndex : currentIndex;
            }
            return currentIndex;
        }
        if (tag == EditorType.UL_LI || tag == EditorType.OL_LI) {
            EditText _text = (EditText)_view.findViewById(R.id.txtText);
            if (_text.getText().length() > 0) {
                // empty if block
            }
            return size;
        }
        return size;
    }

    public boolean containsStyle(List<EditorTextStyle> _Styles, EditorTextStyle style2) {
        for (EditorTextStyle item : _Styles) {
            if (item != style2) continue;
            return true;
        }
        return false;
    }

    public EditorControl updateTagStyle(EditorControl controlTag, EditorTextStyle style2, Op _op) {
        List<EditorTextStyle> styles = controlTag._ControlStyles;
        if (_op == Op.Delete) {
            int index = styles.indexOf((Object)style2);
            if (index != -1) {
                styles.remove(index);
                controlTag._ControlStyles = styles;
            }
        } else {
            int index = styles.indexOf((Object)style2);
            if (index == -1) {
                styles.add(style2);
            }
        }
        return controlTag;
    }

    public EditorType getControlType(View _view) {
        if (_view == null) {
            return null;
        }
        EditorControl _control = (EditorControl)_view.getTag();
        return _control.Type;
    }

    public EditorControl getControlTag(View view) {
        if (view == null) {
            return null;
        }
        EditorControl control = (EditorControl)view.getTag();
        return control;
    }

    public EditorControl createTag(EditorType type) {
        EditorControl control = new EditorControl();
        control.Type = type;
        control._ControlStyles = new ArrayList<EditorTextStyle>();
        switch (type) {
            default: 
        }
        return control;
    }

    public void deleteFocusedPrevious(EditText view) {
        int index = this.__parentView.indexOfChild((View)view);
        if (index == 0) {
            return;
        }
        EditorControl contentType = (EditorControl)((View)view.getParent()).getTag();
        if (contentType != null && (contentType.Type == EditorType.OL_LI || contentType.Type == EditorType.UL_LI)) {
            this.__listItemExtensions.validateAndRemoveLisNode((View)view, contentType);
            return;
        }
        View toFocus = this.__parentView.getChildAt(index - 1);
        EditorControl control = (EditorControl)toFocus.getTag();
        if (control.Type == EditorType.img || control.Type == EditorType.map) {
            return;
        }
        if (control.Type == EditorType.ol || control.Type == EditorType.ul) {
            this.__parentView.removeView((View)view);
            this.__listItemExtensions.setFocusToList(toFocus, 1);
        } else {
            this.removeParent((View)view);
        }
    }

    public int removeParent(View view) {
        int indexOfDeleteItem = this.__parentView.indexOfChild(view);
        View nextItem = null;
        this.__parentView.removeView(view);
        Log.d((String)"indexOfDeleteItem", (String)("indexOfDeleteItem : " + indexOfDeleteItem));
        if (this.__dividerExtensions.deleteHr(Math.max(0, indexOfDeleteItem - 1))) {
            --indexOfDeleteItem;
        }
        for (int i = 0; i < indexOfDeleteItem; ++i) {
            if (this.getControlType(this.__parentView.getChildAt(i)) != EditorType.INPUT) continue;
            nextItem = this.__parentView.getChildAt(i);
        }
        if (nextItem != null) {
            CustomEditText text = (CustomEditText)nextItem;
            if (text.requestFocus()) {
                text.setSelection(text.getText().length());
            }
            this.__activeView = nextItem;
        }
        return indexOfDeleteItem;
    }

    public EditorContent getStateFromString(String content) {
        if (content == null) {
            content = this.getValue("editorState", "");
        }
        EditorContent deserialized = (EditorContent)this.__gson.fromJson(content, EditorContent.class);
        return deserialized;
    }

    public String getValue(String Key, String defaultVal) {
        SharedPreferences _Preferences = this.__context.getSharedPreferences("QA", 0);
        return _Preferences.getString(Key, defaultVal);
    }

    public void putValue(String Key, String Value) {
        SharedPreferences _Preferences = this.__context.getSharedPreferences("QA", 0);
        SharedPreferences.Editor editor = _Preferences.edit();
        editor.putString(Key, Value);
        editor.apply();
    }

    public String getContentAsSerialized() {
        EditorContent state = this.getContent();
        return this.serializeContent(state);
    }

    public String getContentAsSerialized(EditorContent state) {
        return this.serializeContent(state);
    }

    public EditorContent getContentDeserialized(String EditorContentSerialized) {
        EditorContent Deserialized = (EditorContent)this.__gson.fromJson(EditorContentSerialized, EditorContent.class);
        return Deserialized;
    }

    public String serializeContent(EditorContent _state) {
        String serialized = this.__gson.toJson((Object)_state);
        return serialized;
    }

    public EditorContent getContent() {
        if (this.__renderType == RenderType.Renderer) {
            this.__utilities.toastItOut("This option only available in editor mode");
            return null;
        }
        int childCount = this.__parentView.getChildCount();
        EditorContent editorState = new EditorContent();
        ArrayList<Node> list = new ArrayList<Node>();
        block7: for (int i = 0; i < childCount; ++i) {
            EditorType type;
            Node node = new Node();
            View view = this.__parentView.getChildAt(i);
            node.type = type = this.getControlType(view);
            node.content = new ArrayList();
            switch (type) {
                case INPUT: {
                    EditText _text = (EditText)view;
                    EditorControl tag = (EditorControl)view.getTag();
                    node.contentStyles = tag._ControlStyles;
                    node.content.add(Html.toHtml((Spanned)_text.getText()));
                    list.add(node);
                    continue block7;
                }
                case img: {
                    EditorControl imgTag = (EditorControl)view.getTag();
                    if (TextUtils.isEmpty((CharSequence)imgTag.path)) continue block7;
                    node.content.add(imgTag.path);
                    Editable desc = ((EditText)view.findViewById(R.id.desc)).getText();
                    node.content.add(desc.length() > 0 ? desc.toString() : "");
                    list.add(node);
                    continue block7;
                }
                case hr: {
                    list.add(node);
                    continue block7;
                }
                case ul: 
                case ol: {
                    TableLayout table = (TableLayout)view;
                    int _rowCount = table.getChildCount();
                    for (int j = 0; j < _rowCount; ++j) {
                        View row = table.getChildAt(j);
                        EditText li = (EditText)row.findViewById(R.id.txtText);
                        node.content.add(Html.toHtml((Spanned)li.getText()));
                    }
                    list.add(node);
                    continue block7;
                }
                case map: {
                    EditorControl mapTag = (EditorControl)view.getTag();
                    Editable desc = ((CustomEditText)view.findViewById(R.id.desc)).getText();
                    node.content.add(mapTag.Cords);
                    node.content.add(desc.length() > 0 ? desc.toString() : "");
                    list.add(node);
                }
            }
        }
        editorState.nodes = list;
        return editorState;
    }

    public void renderEditor(EditorContent _state) {
        this.__parentView.removeAllViews();
        block7: for (Node item : _state.nodes) {
            switch (item.type) {
                case INPUT: {
                    String text = item.content.get(0);
                    TextView view = this.__inputExtensions.insertEditText(0, this.placeHolder, text);
                    if (item.contentStyles == null) break;
                    for (EditorTextStyle style2 : item.contentStyles) {
                        this.__inputExtensions.UpdateTextStyle(style2, view);
                    }
                    continue block7;
                }
                case hr: {
                    this.__dividerExtensions.insertDivider();
                    break;
                }
                case img: {
                    String path = item.content.get(0);
                    String desc = item.content.get(1);
                    this.__imageExtensions.loadImage(path, desc);
                    break;
                }
                case ul: 
                case ol: {
                    TableLayout _layout = null;
                    for (int i = 0; i < item.content.size(); ++i) {
                        if (i == 0) {
                            _layout = this.__listItemExtensions.insertList(_state.nodes.indexOf(item), item.type == EditorType.ol, item.content.get(i));
                            continue;
                        }
                        this.__listItemExtensions.AddListItem(_layout, item.type == EditorType.ol, item.content.get(i));
                    }
                    continue block7;
                }
                case map: {
                    this.__mapExtensions.insertMap(item.content.get(0), item.content.get(1), true);
                }
            }
        }
    }

    public boolean isLastRow(View view) {
        int index = this.__parentView.indexOfChild(view);
        int length = this.__parentView.getChildCount();
        return length - 1 == index;
    }

    public void renderEditorFromHtml(String content) {
        this.__htmlExtensions.parseHtml(content);
    }

    public void clearAllContents() {
        this.__parentView.removeAllViews();
    }

    public void onBackspace(CustomEditText editText) {
        int len = editText.getText().length();
        int selection = editText.getSelectionStart();
        if (selection == 0) {
            return;
        }
        editText.getText().delete(selection, 1);
    }

    public boolean onKey(View v, int keyCode, KeyEvent event, CustomEditText editText) {
        if (keyCode != 67) {
            return false;
        }
        if (this.__inputExtensions.isEditTextEmpty((EditText)editText)) {
            this.deleteFocusedPrevious((EditText)editText);
            int controlCount = this.getParentChildCount();
            if (controlCount == 1) {
                return this.checkLastControl();
            }
            return false;
        }
        int length = editText.getText().length();
        int selectionStart = editText.getSelectionStart();
        EditorType editorType = this.getControlType(this.__activeView);
        if (selectionStart == 0 && length > 0) {
            if (editorType == EditorType.UL_LI || editorType == EditorType.OL_LI) {
                int index = this.__listItemExtensions.getIndexOnEditorByEditText(editText);
                if (index == 0) {
                    this.deleteFocusedPrevious((EditText)editText);
                }
            } else {
                int index = this.getParentView().indexOfChild((View)editText);
                if (index == 0) {
                    return false;
                }
                CustomEditText nextFocus = this.__inputExtensions.getEditTextPrevious(index);
                this.deleteFocusedPrevious((EditText)editText);
                nextFocus.setText(nextFocus.getText().toString() + editText.getText().toString());
            }
        }
        return false;
    }

    private boolean checkLastControl() {
        EditorControl control = this.getControlTag(this.getParentView().getChildAt(0));
        if (control == null) {
            return false;
        }
        switch (control.Type) {
            case ul: 
            case ol: {
                this.__parentView.removeAllViews();
            }
        }
        return false;
    }

    public boolean isStateFresh() {
        return this.stateFresh;
    }

    public void setStateFresh(boolean stateFresh) {
        this.stateFresh = stateFresh;
    }

    public class Utilities {
        public int[] getScreenDimension() {
            Display display = ((Activity)EditorCore.this.__context).getWindowManager().getDefaultDisplay();
            Point size = new Point();
            display.getSize(size);
            int width = size.x;
            int height = size.y;
            int[] dimen2 = new int[]{width, height};
            return dimen2;
        }

        public void toastItOut(String message) {
            Toast.makeText((Context)EditorCore.this.__context, (CharSequence)message, (int)0).show();
        }
    }
}

