/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx.Components;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.github.irshulx.EditorCore;
import com.github.irshulx.R;
import com.github.irshulx.Utilities.IEditorRetrofitApi;
import com.github.irshulx.Utilities.ServiceGenerator;
import com.github.irshulx.models.EditorContent;
import com.github.irshulx.models.EditorControl;
import com.github.irshulx.models.EditorType;
import com.github.irshulx.models.ImageResponse;
import com.squareup.picasso.Picasso;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ImageExtensions {
    private EditorCore editorCore;
    private String imageUploadUri;
    private int editorImageLayout = R.layout.tmpl_image_view;

    public ImageExtensions(EditorCore editorCore) {
        this.editorCore = editorCore;
    }

    public void setEditorImageLayout(int drawable2) {
        this.editorImageLayout = drawable2;
    }

    public void executeDownloadImageTask(String url, int index) {
        new DownloadImageTask(index).execute(new String[]{url});
    }

    public void setImageUploadUri(String uri) {
        this.imageUploadUri = uri;
    }

    public void OpenImageGallery() {
        int Index = this.editorCore.determineIndex(EditorType.none);
        EditorContent state2 = this.editorCore.getContent();
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        ((Activity)this.editorCore.getContext()).startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Select an image"), this.editorCore.PICK_IMAGE_REQUEST);
    }

    public void InsertImage(Bitmap _image, int Index) {
        View childLayout = ((Activity)this.editorCore.getContext()).getLayoutInflater().inflate(this.editorImageLayout, null);
        ImageView imageView = (ImageView)childLayout.findViewById(R.id.imageView);
        imageView.setImageBitmap(_image);
        String uuid = this.GenerateUUID();
        this.BindEvents(childLayout);
        if (Index == -1) {
            Index = this.editorCore.determineIndex(EditorType.img);
        }
        this.editorCore.getParentView().addView(childLayout, Index);
        if (this.editorCore.isLastRow(childLayout)) {
            this.editorCore.getInputExtensions().InsertEditText(Index + 1, null, null);
        }
        EditorControl control = this.editorCore.CreateTag(EditorType.img);
        childLayout.setTag((Object)control);
        if (TextUtils.isEmpty((CharSequence)this.editorCore.getImageUploaderUri())) {
            String error = "You must configure a valid remote URI to be able to upload the image.This image is not persisted";
            this.editorCore.getUtilitiles().toastItOut(error);
            TextView sts = (TextView)childLayout.findViewById(R.id.lblStatus);
            sts.setBackgroundDrawable(this.editorCore.getResources().getDrawable(R.drawable.error_background));
            sts.setVisibility(0);
            sts.setText((CharSequence)error);
            return;
        }
        this.UploadImageToServer(_image, childLayout, uuid);
    }

    public String GenerateUUID() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String sdt = df.format(new Date(System.currentTimeMillis()));
        UUID x = UUID.randomUUID();
        String[] y = x.toString().split("-");
        return y[y.length - 1] + sdt;
    }

    public void loadImage(String _path) {
        ImageView imageView = new ImageView(this.editorCore.getContext());
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.setMargins(0, 25, 0, 30);
        imageView.setLayoutParams((ViewGroup.LayoutParams)params);
        Picasso.with((Context)this.editorCore.getContext()).load(_path).into(imageView);
        this.editorCore.getParentView().addView((View)imageView);
    }

    private void UploadImageToServer(Bitmap bitmap, final View view, String uuid) {
        File f = new File(this.editorCore.getContext().getCacheDir(), uuid + ".png");
        final TextView lblStatus = (TextView)view.findViewById(R.id.lblStatus);
        try {
            Retrofit.Builder customBuilder;
            f.createNewFile();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)bos);
            byte[] bitmapdata = bos.toByteArray();
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(bitmapdata);
            fos.flush();
            fos.close();
            Retrofit.Builder builder = ServiceGenerator.getRetrofitBuilder();
            if (this.editorCore.getEditorListener() != null && (customBuilder = this.editorCore.getEditorListener().onUpload(builder)) != null) {
                builder = customBuilder;
            }
            IEditorRetrofitApi service = ServiceGenerator.createService(builder, IEditorRetrofitApi.class);
            RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)f);
            MultipartBody.Part body = MultipartBody.Part.createFormData((String)"picture", (String)f.getName(), (RequestBody)requestFile);
            RequestBody description = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)"");
            view.findViewById(R.id.progress).setVisibility(0);
            lblStatus.setVisibility(0);
            if (this.editorCore.getEditorListener() != null) {
                // empty if block
            }
            Call<ImageResponse> call = service.upload(this.editorCore.getImageUploaderUri(), description, body);
            call.enqueue((Callback)new Callback<ImageResponse>(){

                public void onResponse(Call<ImageResponse> call, Response<ImageResponse> response) {
                    ((TextView)view.findViewById(R.id.lblStatus)).setText((CharSequence)"Upload complete");
                    EditorControl control = ImageExtensions.this.editorCore.CreateTag(EditorType.img);
                    control.Path = ((ImageResponse)response.body()).Uri;
                    view.setTag((Object)control);
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            ((Activity)ImageExtensions.this.editorCore.getContext()).runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    lblStatus.setVisibility(8);
                                }
                            });
                        }
                    }, 3000L);
                    view.findViewById(R.id.progress).setVisibility(8);
                }

                public void onFailure(Call<ImageResponse> call, Throwable t) {
                    lblStatus.setText((CharSequence)t.getMessage());
                    lblStatus.setBackgroundDrawable(ImageExtensions.this.editorCore.getResources().getDrawable(R.drawable.error_background));
                    view.findViewById(R.id.progress).setVisibility(8);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void BindEvents(final View layout2) {
        final ImageView imageView = (ImageView)layout2.findViewById(R.id.imageView);
        final View btn_remove = layout2.findViewById(R.id.btn_remove);
        btn_remove.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageExtensions.this.editorCore.getParentView().removeView(layout2);
            }
        });
        imageView.setOnTouchListener(new View.OnTouchListener(){
            private Rect rect;

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    imageView.setColorFilter(Color.argb((int)50, (int)0, (int)0, (int)0));
                    this.rect = new Rect(v.getLeft(), v.getTop(), v.getRight(), v.getBottom());
                }
                if (event.getAction() == 1) {
                    imageView.setColorFilter(Color.argb((int)0, (int)0, (int)0, (int)0));
                }
                if (event.getAction() == 2 && !this.rect.contains(v.getLeft() + (int)event.getX(), v.getTop() + (int)event.getY())) {
                    imageView.setColorFilter(Color.argb((int)0, (int)0, (int)0, (int)0));
                }
                return false;
            }
        });
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                btn_remove.setVisibility(0);
            }
        });
        imageView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                btn_remove.setVisibility(hasFocus ? 0 : 8);
            }
        });
    }

    private class DownloadImageTask
    extends AsyncTask<String, Void, Bitmap> {
        private int InsertIndex;

        public DownloadImageTask(int index) {
            this.InsertIndex = index;
        }

        protected Bitmap doInBackground(String ... urls) {
            String urldisplay = urls[0];
            Bitmap mIcon11 = null;
            try {
                InputStream in = new URL(urldisplay).openStream();
                mIcon11 = BitmapFactory.decodeStream((InputStream)in);
            }
            catch (Exception e) {
                Log.e((String)"Error", (String)e.getMessage());
                e.printStackTrace();
            }
            return mIcon11;
        }

        protected void onPostExecute(Bitmap result) {
            ImageExtensions.this.InsertImage(result, this.InsertIndex);
        }
    }
}

