/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx.Components;

import android.app.Activity;
import android.content.Context;
import android.graphics.Typeface;
import android.os.Handler;
import android.text.Editable;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import com.github.irshulx.BaseClass;
import com.github.irshulx.Components.CustomEditText;
import com.github.irshulx.R;
import com.github.irshulx.models.EditorControl;
import com.github.irshulx.models.EditorType;
import com.github.irshulx.models.RenderType;

public class ListItemExtensions {
    private Context context;
    BaseClass base;
    private int listItemTemplate = R.layout.tmpl_unordered_list_item;

    public ListItemExtensions(BaseClass baseClass, Context context) {
        this.base = baseClass;
        this.context = context;
    }

    public void setListItemTemplate(int drawable2) {
        this.listItemTemplate = drawable2;
    }

    public TableLayout insertList(int Index, boolean isOrdered, String text) {
        TableLayout table = this.CreateTable();
        this.base.getParentView().addView((View)table, Index);
        table.setTag((Object)this.base.CreateTag(isOrdered ? EditorType.ol : EditorType.ul));
        this.AddListItem(table, isOrdered, text);
        return table;
    }

    public TableLayout CreateTable() {
        TableLayout table = new TableLayout(this.base.getContext());
        table.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        table.setPadding(30, 10, 10, 10);
        return table;
    }

    public View AddListItem(TableLayout layout2, boolean isOrdered, String text) {
        View childLayout = ((Activity)this.base.getContext()).getLayoutInflater().inflate(this.listItemTemplate, null);
        final CustomEditText editText = (CustomEditText)childLayout.findViewById(R.id.txtText);
        editText.setTypeface(Typeface.create((String)this.base.getInputExtensions().getFontFace(), (int)0));
        if (isOrdered) {
            TextView _order = (TextView)childLayout.findViewById(R.id.lblOrder);
            int count = layout2.getChildCount();
            _order.setText((CharSequence)(String.valueOf(count + 1) + "."));
        }
        if (this.base.getRenderType() == RenderType.Editor) {
            editText.setTextColor(this.base.getResources().getColor(R.color.darkertext));
            editText.setLineSpacing(TypedValue.applyDimension((int)1, (float)this.base.getInputExtensions().getLineSpacing(), (DisplayMetrics)this.base.getResources().getDisplayMetrics()), 1.0f);
            editText.setTextSize(2, this.base.getInputExtensions().getNormtalTextSize());
            editText.setTag(this.base.CreateTag(isOrdered ? EditorType.OL_LI : EditorType.UL_LI));
            childLayout.setTag((Object)this.base.CreateTag(isOrdered ? EditorType.OL_LI : EditorType.UL_LI));
            this.base.setActiveView((View)editText);
            this.base.getInputExtensions().setText((TextView)editText, text);
            editText.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ListItemExtensions.this.base.setActiveView(v);
                }
            });
            editText.setOnKeyListener(new View.OnKeyListener(){

                public boolean onKey(View v, int keyCode, KeyEvent event) {
                    if (keyCode == 67 && ListItemExtensions.this.base.getInputExtensions().IsEditTextNull(editText)) {
                        ListItemExtensions.this.base.deleteFocusedPrevious(editText);
                    }
                    return false;
                }
            });
            editText.addTextChangedListener(new TextWatcher(){

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                }

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void afterTextChanged(Editable s) {
                    String text = Html.toHtml((Spanned)editText.getText());
                    if (s.length() > 0 && s.charAt(s.length() - 1) == '\n') {
                        text = text.replaceAll("<br>", "");
                        TableRow _row = (TableRow)editText.getParent();
                        TableLayout _table = (TableLayout)_row.getParent();
                        EditorType type = ListItemExtensions.this.base.GetControlType((View)_table);
                        if (s.length() == 0 || s.toString().equals("\n")) {
                            int index = ListItemExtensions.this.base.getParentView().indexOfChild((View)_table);
                            _table.removeView((View)_row);
                            ListItemExtensions.this.base.getInputExtensions().InsertEditText(index + 1, "", "");
                        } else {
                            Spanned __ = Html.fromHtml((String)text);
                            CharSequence toReplace = ListItemExtensions.this.base.getInputExtensions().noTrailingwhiteLines((CharSequence)__);
                            if (toReplace.length() > 0) {
                                editText.setText(toReplace);
                            } else {
                                editText.getText().clear();
                            }
                            int index = _table.indexOfChild((View)_row);
                            ListItemExtensions.this.AddListItem(_table, type == EditorType.ol, "");
                        }
                    }
                }
            });
            Handler handler = new Handler();
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    editText.requestFocus();
                    InputMethodManager mgr = (InputMethodManager)ListItemExtensions.this.base.getActivity().getSystemService("input_method");
                    mgr.showSoftInput((View)editText, 1);
                    editText.setSelection(editText.getText().length());
                }
            }, 0L);
        } else {
            TextView textView = (TextView)childLayout.findViewById(R.id.lblText);
            textView.setTypeface(Typeface.create((String)this.base.getInputExtensions().getFontFace(), (int)0));
            if (!TextUtils.isEmpty((CharSequence)text)) {
                this.base.getInputExtensions().setText(textView, text);
            }
            textView.setTextColor(this.base.getResources().getColor(R.color.darkertext));
            textView.setLineSpacing(TypedValue.applyDimension((int)1, (float)this.base.getInputExtensions().getLineSpacing(), (DisplayMetrics)this.base.getResources().getDisplayMetrics()), 1.0f);
            textView.setTextSize(2, 14.0f);
            textView.setVisibility(0);
            editText.setVisibility(8);
        }
        layout2.addView(childLayout);
        return childLayout;
    }

    public void ConvertListToNormalText(TableLayout _table, int startIndex) {
        int tableChildCount = _table.getChildCount();
        for (int i = startIndex; i < tableChildCount; --tableChildCount, ++i) {
            View _childRow = _table.getChildAt(i);
            _table.removeView(_childRow);
            String text = this.getTextFromListItem(_childRow);
            int Index = this.base.getParentView().indexOfChild((View)_table);
            this.base.getInputExtensions().InsertEditText(Index + 1, "", text);
            --i;
        }
        if (_table.getChildCount() == 0) {
            this.base.getParentView().removeView((View)_table);
        }
    }

    public void ConvertListToOrdered(TableLayout _table) {
        EditorControl type = this.base.CreateTag(EditorType.ol);
        _table.setTag((Object)type);
        for (int i = 0; i < _table.getChildCount(); ++i) {
            View _childRow = _table.getChildAt(i);
            CustomEditText editText = (CustomEditText)_childRow.findViewById(R.id.txtText);
            editText.setTag(this.base.CreateTag(EditorType.OL_LI));
            _childRow.setTag((Object)this.base.CreateTag(EditorType.OL_LI));
            TextView _bullet = (TextView)_childRow.findViewById(R.id.lblOrder);
            _bullet.setText((CharSequence)(String.valueOf(i + 1) + "."));
        }
    }

    public void ConvertListToUnordered(TableLayout _table) {
        EditorControl type = this.base.CreateTag(EditorType.ul);
        _table.setTag((Object)type);
        for (int i = 0; i < _table.getChildCount(); ++i) {
            View _childRow = _table.getChildAt(i);
            CustomEditText _EditText = (CustomEditText)_childRow.findViewById(R.id.txtText);
            _EditText.setTag(this.base.CreateTag(EditorType.UL_LI));
            _childRow.setTag((Object)this.base.CreateTag(EditorType.UL_LI));
            TextView _bullet = (TextView)_childRow.findViewById(R.id.lblOrder);
            _bullet.setText((CharSequence)"\u2022");
        }
    }

    public String getTextFromListItem(View row) {
        CustomEditText _text = (CustomEditText)row.findViewById(R.id.txtText);
        return _text.getText().toString();
    }

    public void Insertlist(boolean isOrdered) {
        View ActiveView = this.base.getActiveView();
        EditorType currentFocus = this.base.GetControlType(ActiveView);
        if (currentFocus == EditorType.UL_LI && !isOrdered) {
            TableRow _row = (TableRow)ActiveView.getParent();
            TableLayout _table = (TableLayout)_row.getParent();
            this.ConvertListToNormalText(_table, _table.indexOfChild((View)_row));
        } else if (currentFocus == EditorType.UL_LI && isOrdered) {
            TableRow _row = (TableRow)ActiveView.getParent();
            TableLayout _table = (TableLayout)_row.getParent();
            this.ConvertListToOrdered(_table);
        } else if (currentFocus == EditorType.OL_LI && isOrdered) {
            TableRow _row = (TableRow)ActiveView.getParent();
            TableLayout _table = (TableLayout)_row.getParent();
            this.ConvertListToNormalText(_table, _table.indexOfChild((View)_row));
        } else if (currentFocus == EditorType.OL_LI && !isOrdered) {
            TableRow _row = (TableRow)ActiveView.getParent();
            TableLayout _table = (TableLayout)_row.getParent();
            this.ConvertListToUnordered(_table);
        } else if (isOrdered) {
            int index_of_activeView = this.base.getParentView().indexOfChild(this.base.getActiveView());
            int Index = this.base.determineIndex(EditorType.OL_LI);
            View view = this.base.getParentView().getChildAt(Index);
            if (view != null) {
                EditorType type = this.base.GetControlType(view);
                if (type == EditorType.INPUT) {
                    String text = ((CustomEditText)view).getText().toString();
                    this.base.getParentView().removeView(view);
                    if (Index == 0) {
                        this.insertList(Index, isOrdered, text);
                    } else if (this.base.GetControlType(this.base.getParentView().getChildAt(index_of_activeView - 1)) == EditorType.ol) {
                        TableLayout _table = (TableLayout)this.base.getParentView().getChildAt(index_of_activeView - 1);
                        this.AddListItem(_table, isOrdered, text);
                    } else {
                        this.insertList(Index, isOrdered, text);
                    }
                } else {
                    this.insertList(Index, isOrdered, "");
                }
            } else {
                this.insertList(Index, isOrdered, "");
            }
        } else {
            int Index = this.base.determineIndex(EditorType.UL_LI);
            View view = this.base.getParentView().getChildAt(Index);
            if (view != null) {
                EditorType type = this.base.GetControlType(view);
                if (type == EditorType.INPUT) {
                    String text = ((EditText)view).getText().toString();
                    this.base.getParentView().removeView(view);
                    this.insertList(Index, false, text);
                } else {
                    this.insertList(Index, false, "");
                }
            } else {
                this.insertList(Index, false, "");
            }
        }
    }
}

