/*
 * Decompiled with CFR 0.152.
 */
package com.irshu.libs.Components;

import android.content.Context;
import android.content.DialogInterface;
import android.support.v7.app.AlertDialog;
import android.text.Editable;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.irshu.editor.R;
import com.irshu.libs.BaseClass;
import com.irshu.libs.Components.CustomEditText;
import com.irshu.libs.models.EditorControl;
import com.irshu.libs.models.EditorTextStyle;
import com.irshu.libs.models.EditorType;
import com.irshu.libs.models.Op;
import com.irshu.libs.models.RenderType;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class InputExtensions {
    private Context context;
    private int H1TEXTSIZE = 22;
    private int H2TEXTSIZE = 18;
    private int H3TEXTSIZE = 16;
    private int NORMALTEXTSIZE = 14;
    BaseClass base;

    public int getH1TextSize() {
        return this.H1TEXTSIZE;
    }

    public void setH1TextSize(int size) {
        this.H1TEXTSIZE = size;
    }

    public int getH2TextSize() {
        return this.H2TEXTSIZE;
    }

    public void setH2TextSize(int size) {
        this.H2TEXTSIZE = size;
    }

    public int getH3TextSize() {
        return this.H3TEXTSIZE;
    }

    public void setH3TextSize(int size) {
        this.H3TEXTSIZE = size;
    }

    public InputExtensions(BaseClass baseClass, Context context) {
        this.base = baseClass;
        this.context = context;
    }

    CharSequence GetSanitizedHtml(String text) {
        Spanned __ = Html.fromHtml((String)text);
        CharSequence toReplace = this.noTrailingwhiteLines((CharSequence)__);
        return toReplace;
    }

    public void setText(EditText editText, String text) {
        CharSequence toReplace = this.GetSanitizedHtml(text);
        editText.setText(toReplace);
    }

    public void setText(TextView textView, String text) {
        CharSequence toReplace = this.GetSanitizedHtml(text);
        textView.setText(toReplace);
    }

    private TextView GetNewTextView(String text) {
        TextView textView = new TextView(this.context);
        textView.setGravity(80);
        textView.setLineSpacing(TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)this.base.getResources().getDisplayMetrics()), 1.0f);
        textView.setTextSize(2, (float)this.NORMALTEXTSIZE);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.setMargins(0, 0, 0, 30);
        textView.setLayoutParams((ViewGroup.LayoutParams)params);
        if (!TextUtils.isEmpty((CharSequence)text)) {
            Spanned __ = Html.fromHtml((String)text);
            CharSequence toReplace = this.noTrailingwhiteLines((CharSequence)__);
            textView.setText(toReplace);
        }
        return textView;
    }

    public CustomEditText GetNewEditText(String hint, String text) {
        final CustomEditText editText = new CustomEditText(this.context);
        editText.setGravity(80);
        editText.setLineSpacing(TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)this.base.getResources().getDisplayMetrics()), 1.0f);
        editText.setTextSize(2, this.NORMALTEXTSIZE);
        editText.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        if (hint != null) {
            editText.setHint(hint);
        }
        if (text != null) {
            this.setText(editText, text);
        }
        editText.setTag(this.base.CreateTag(EditorType.INPUT));
        editText.setBackgroundDrawable(this.context.getResources().getDrawable(R.drawable.invisible_edit_text));
        editText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InputExtensions.this.base.setActiveView(v);
            }
        });
        editText.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode == 67 && InputExtensions.this.IsEditTextNull(editText)) {
                    InputExtensions.this.base.deleteFocusedPrevious(editText);
                }
                return false;
            }
        });
        editText.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                String text = Html.toHtml((Spanned)editText.getText());
                if (s.length() > 0 && s.charAt(s.length() - 1) == '\n') {
                    text = text.replaceAll("<br>", "");
                    InputExtensions.this.setText(editText, text);
                    int index = InputExtensions.this.base.getParentView().indexOfChild((View)editText);
                    if (index == 0) {
                        editText.setHint(null);
                    }
                    InputExtensions.this.InsertEditText(index + 1, null, null);
                }
                if (InputExtensions.this.base.getEditorListener() != null) {
                    InputExtensions.this.base.getEditorListener().onTextChanged(editText, s);
                }
            }
        });
        return editText;
    }

    public TextView InsertEditText(int position, String hint, String text) {
        if (this.base.getRenderType() == RenderType.Editor) {
            CustomEditText view = this.GetNewEditText(hint, text);
            this.base.getParentView().addView((View)view, position);
            this.base.setActiveView((View)view);
            if (view.requestFocus()) {
                this.base.setActiveView((View)view);
            }
            return view;
        }
        TextView view = this.GetNewTextView(text);
        view.setTag((Object)this.base.CreateTag(EditorType.INPUT));
        this.base.getParentView().addView((View)view);
        return view;
    }

    public CustomEditText InsertEditText(int position, CustomEditText editText) {
        if (position == 0) {
            this.base.getParentView().addView((View)editText);
        } else {
            this.base.getParentView().addView((View)editText, position);
        }
        if (editText.requestFocus()) {
            this.base.setActiveView((View)editText);
        }
        return editText;
    }

    public void UpdateTextStyle(EditorTextStyle style, TextView editText) {
        try {
            if (editText == null) {
                editText = (EditText)this.base.getActiveView();
            }
            EditorControl tag = this.base.GetControlTag((View)editText);
            if (style == EditorTextStyle.H1) {
                if (this.base.ContainsStyle(tag._ControlStyles, EditorTextStyle.H1)) {
                    editText.setTextSize(2, (float)this.NORMALTEXTSIZE);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H1, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H2, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H3, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.NORMAL, Op.Insert);
                } else {
                    editText.setTextSize(2, (float)this.H1TEXTSIZE);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H1, Op.Insert);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H2, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H3, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.NORMAL, Op.Delete);
                }
            } else if (style == EditorTextStyle.H2) {
                if (this.base.ContainsStyle(tag._ControlStyles, EditorTextStyle.H2)) {
                    editText.setTextSize(2, (float)this.NORMALTEXTSIZE);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H1, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H2, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H3, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.NORMAL, Op.Insert);
                } else {
                    editText.setTextSize(2, (float)this.H2TEXTSIZE);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H1, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H2, Op.Insert);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H3, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.NORMAL, Op.Delete);
                }
            } else if (style == EditorTextStyle.H3) {
                if (this.base.ContainsStyle(tag._ControlStyles, EditorTextStyle.H3)) {
                    editText.setTextSize(2, (float)this.NORMALTEXTSIZE);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H1, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H2, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H3, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.NORMAL, Op.Insert);
                } else {
                    editText.setTextSize(2, (float)this.H3TEXTSIZE);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H1, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H3, Op.Insert);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H2, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.NORMAL, Op.Delete);
                }
            } else if (style == EditorTextStyle.NORMAL) {
                editText.setTextSize(2, (float)this.NORMALTEXTSIZE);
                tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H1, Op.Delete);
                tag = this.base.UpdateTagStyle(tag, EditorTextStyle.H2, Op.Delete);
                if (!this.base.ContainsStyle(tag._ControlStyles, EditorTextStyle.NORMAL)) {
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.NORMAL, Op.Insert);
                }
            } else if (style == EditorTextStyle.BOLD) {
                if (this.base.ContainsStyle(tag._ControlStyles, EditorTextStyle.BOLD)) {
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.BOLD, Op.Delete);
                    editText.setTypeface(null, 0);
                } else if (this.base.ContainsStyle(tag._ControlStyles, EditorTextStyle.BOLDITALIC)) {
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.BOLDITALIC, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.ITALIC, Op.Insert);
                    editText.setTypeface(null, 2);
                } else if (this.base.ContainsStyle(tag._ControlStyles, EditorTextStyle.ITALIC)) {
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.BOLDITALIC, Op.Insert);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.ITALIC, Op.Delete);
                    editText.setTypeface(null, 3);
                } else {
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.BOLD, Op.Insert);
                    editText.setTypeface(null, 1);
                }
            } else if (style == EditorTextStyle.ITALIC) {
                if (this.base.ContainsStyle(tag._ControlStyles, EditorTextStyle.ITALIC)) {
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.ITALIC, Op.Delete);
                    editText.setTypeface(null, 0);
                } else if (this.base.ContainsStyle(tag._ControlStyles, EditorTextStyle.BOLDITALIC)) {
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.BOLDITALIC, Op.Delete);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.BOLD, Op.Insert);
                    editText.setTypeface(null, 1);
                } else if (this.base.ContainsStyle(tag._ControlStyles, EditorTextStyle.BOLD)) {
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.BOLDITALIC, Op.Insert);
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.BOLD, Op.Delete);
                    editText.setTypeface(null, 3);
                } else {
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.ITALIC, Op.Insert);
                    editText.setTypeface(null, 2);
                }
            } else if (style == EditorTextStyle.INDENT) {
                int pBottom = editText.getPaddingBottom();
                int pRight = editText.getPaddingRight();
                int pTop = editText.getPaddingTop();
                if (this.base.ContainsStyle(tag._ControlStyles, EditorTextStyle.INDENT)) {
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.INDENT, Op.Delete);
                    editText.setPadding(0, pTop, pRight, pBottom);
                } else {
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.INDENT, Op.Insert);
                    editText.setPadding(30, pTop, pRight, pBottom);
                }
            } else if (style == EditorTextStyle.OUTDENT) {
                int pBottom = editText.getPaddingBottom();
                int pRight = editText.getPaddingRight();
                int pTop = editText.getPaddingTop();
                if (this.base.ContainsStyle(tag._ControlStyles, EditorTextStyle.INDENT)) {
                    tag = this.base.UpdateTagStyle(tag, EditorTextStyle.INDENT, Op.Delete);
                    editText.setPadding(0, pTop, pRight, pBottom);
                }
            }
            editText.setTag((Object)tag);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void InsertLink() {
        AlertDialog.Builder inputAlert = new AlertDialog.Builder(this.context);
        inputAlert.setTitle((CharSequence)"Add a Link");
        final EditText userInput = new EditText(this.context);
        userInput.setHint((CharSequence)"type the URL here");
        userInput.setInputType(160);
        inputAlert.setView((View)userInput);
        inputAlert.setPositiveButton((CharSequence)"Insert", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                String userInputValue = userInput.getText().toString();
                InputExtensions.this.InsertLink(userInputValue);
            }
        });
        inputAlert.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        AlertDialog alertDialog = inputAlert.create();
        alertDialog.show();
    }

    private void InsertLink(String uri) {
        EditorType editorType = this.base.GetControlType(this.base.getActiveView());
        EditText editText = (EditText)this.base.getActiveView();
        if (editorType == EditorType.INPUT || editorType == EditorType.UL_LI) {
            String text = Html.toHtml((Spanned)editText.getText());
            Document _doc = Jsoup.parse((String)(text = this.trimLineEnding(text)));
            Elements x = _doc.select("p");
            if (x.size() > 0) {
                String existing = x.get(0).html();
                x.get(0).html(existing + " <a href='" + uri + "'>" + uri + "</a>");
                Spanned toTrim = Html.fromHtml((String)x.toString());
                CharSequence trimmed = this.noTrailingwhiteLines((CharSequence)toTrim);
                editText.setText(trimmed);
                editText.setSelection(editText.getText().length());
            }
        }
    }

    public CharSequence noTrailingwhiteLines(CharSequence text) {
        if (text.length() == 0) {
            return text;
        }
        while (text.charAt(text.length() - 1) == '\n') {
            text = text.subSequence(0, text.length() - 1);
        }
        return text;
    }

    boolean IsEditTextNull(EditText editText) {
        return editText.getText().toString().trim().length() == 0;
    }

    private String trimLineEnding(String s) {
        if (s.charAt(s.length() - 1) == '\n') {
            String formatted = s.toString().substring(0, s.length() - 1);
            return formatted;
        }
        return s;
    }
}

