/*
 * Decompiled with CFR 0.152.
 */
package devtools.liferay.portal.properties.plugin.task;

import devtools.liferay.portal.properties.plugin.PortalPropertiesUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

public class BuildPropertiesTask
extends DefaultTask {
    private String descFolderPath = "";
    private String originFolderPath = "";
    private String keysFolderPath = "";

    @TaskAction
    public void buildPropertiesTask() throws Exception {
        PortalPropertiesUtils.log("Build properties task..." + this.descFolderPath);
        this.printSettings();
        List<Path> originFiles = this.getFilesFromFolder(this.originFolderPath);
        List<Path> keysFiles = this.getFilesFromFolder(this.keysFolderPath);
        List<Path> destinationFolders = this.getFolderFromFolder(this.descFolderPath);
        keysFiles.stream().forEach(keysFile -> this.parseEnvironment(PortalPropertiesUtils.getFileName(keysFile.getFileName().toString()), (Path)keysFile, originFiles, destinationFolders));
    }

    private List<Path> getFilesFromFolder(String folderPath) throws IOException {
        List<Path> collect = Files.list(Paths.get(this.getProject().getProjectDir() + "/" + folderPath, new String[0])).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        return collect;
    }

    private List<Path> getFolderFromFolder(String folderPath) throws IOException {
        List<Path> collect = Files.list(Paths.get(this.getProject().getProjectDir() + "/" + folderPath, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
        return collect;
    }

    private void parseEnvironment(String environment, Path keysFilePath, List<Path> originFiles, List<Path> destinationFolders) {
        PortalPropertiesUtils.log("Parsing " + environment + " environment...");
        originFiles.stream().forEach(originFile -> destinationFolders.stream().filter(destinationFolder -> destinationFolder.toString().endsWith(environment)).forEach(destinationFolder -> {
            Path destinationFilePath = this.copyFile((Path)originFile, (Path)destinationFolder);
            this.parseDestinationFile(keysFilePath, destinationFilePath);
        }));
    }

    private void parseDestinationFile(Path keysFilePath, Path destinationFilePath) {
        if (destinationFilePath != null) {
            try {
                Properties keySet = new Properties();
                FileInputStream keysFileInputStream = null;
                keysFileInputStream = new FileInputStream(keysFilePath.toFile());
                if (keysFileInputStream != null) {
                    keySet.load(keysFileInputStream);
                }
                Enumeration<?> keyNameEnum = keySet.propertyNames();
                while (keyNameEnum.hasMoreElements()) {
                    String keyName = (String)keyNameEnum.nextElement();
                    String keyNameSearched = "\\$\\{" + keyName + "\\}";
                    String keyValue = keySet.getProperty(keyName);
                    String content = new String(Files.readAllBytes(destinationFilePath), StandardCharsets.UTF_8);
                    content = content.replaceAll(keyNameSearched, keyValue);
                    Files.write(destinationFilePath, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                this.checkBrokenProperties(destinationFilePath, PortalPropertiesUtils.getFileName(keysFilePath.getFileName().toString()));
            }
            catch (IOException exception) {
                PortalPropertiesUtils.error(null, exception);
            }
        }
    }

    private void checkBrokenProperties(Path destinationFilePath, String environment) throws IOException {
        String content = new String(Files.readAllBytes(destinationFilePath), StandardCharsets.UTF_8);
        Pattern brokenPropertyPattern = Pattern.compile("\\$\\{.*\\}");
        Matcher brokenPropertyMatcher = brokenPropertyPattern.matcher(content);
        while (brokenPropertyMatcher.find()) {
            PortalPropertiesUtils.error("WARNING: Property not found in file " + destinationFilePath.getFileName().toString() + " on " + environment + " folder (" + brokenPropertyMatcher.group() + ")", null);
        }
    }

    private Path copyFile(Path originFilePath, Path destinationFolderPath) {
        PortalPropertiesUtils.log("Copying " + originFilePath.toString() + " to " + destinationFolderPath.toString());
        Path destinationFilePath = Paths.get(destinationFolderPath.toString() + "/" + originFilePath.getFileName().toString(), new String[0]);
        try {
            Files.copy(originFilePath, destinationFilePath, StandardCopyOption.REPLACE_EXISTING);
            return destinationFilePath;
        }
        catch (IOException exception) {
            PortalPropertiesUtils.error(null, exception);
            return null;
        }
    }

    private void printSettings() {
        PortalPropertiesUtils.log("Settings: ");
        PortalPropertiesUtils.log("destination folder path: " + this.descFolderPath);
        PortalPropertiesUtils.log("origin folder path: " + this.originFolderPath);
        PortalPropertiesUtils.log("keys folder path: " + this.keysFolderPath);
    }

    public String getDescFolderPath() {
        return this.descFolderPath;
    }

    public void setDescFolderPath(String descFolderPath) {
        this.descFolderPath = descFolderPath;
    }

    public String getOriginFolderPath() {
        return this.originFolderPath;
    }

    public void setOriginFolderPath(String originFolderPath) {
        this.originFolderPath = originFolderPath;
    }

    public String getKeysFolderPath() {
        return this.keysFolderPath;
    }

    public void setKeysFolderPath(String keysFolderPath) {
        this.keysFolderPath = keysFolderPath;
    }
}

