/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.maja.validation;

import java.util.function.Function;
import java.util.stream.Stream;
import net.io_0.maja.PropertyIssue;
import net.io_0.maja.PropertyIssues;
import net.io_0.maja.validation.Validator;

public interface Validation<T> {
    public boolean isValid();

    public T getValue(Function<Invalid<T>, ? extends RuntimeException> var1);

    public PropertyIssues getPropertyIssues();

    public <U extends T> Validation<U> and(Validation<U> var1);

    default public boolean isInvalid() {
        return !this.isValid();
    }

    default public T getValue() {
        return this.getValue(Validator.ValidationException::new);
    }

    public static <T> Valid<T> valid(T value) {
        return new Valid<T>(value);
    }

    public static <T> Invalid<T> invalid(PropertyIssue ... propertyIssues) {
        return Validation.invalid(PropertyIssues.of(propertyIssues));
    }

    public static <T> Invalid<T> invalid(PropertyIssues propertyIssues) {
        return new Invalid(propertyIssues);
    }

    public static <T> Validation<T> of(T value, PropertyIssues propertyIssues) {
        return propertyIssues.isEmpty() ? Validation.valid(value) : Validation.invalid(propertyIssues);
    }

    public static final class Valid<T>
    implements Validation<T> {
        private final T value;

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public T getValue(Function<Invalid<T>, ? extends RuntimeException> orThrow) {
            return this.value;
        }

        @Override
        public PropertyIssues getPropertyIssues() {
            return PropertyIssues.of();
        }

        @Override
        public <U extends T> Validation<U> and(Validation<U> other) {
            return other;
        }

        public Valid(T value) {
            this.value = value;
        }
    }

    public static final class Invalid<T>
    implements Validation<T> {
        private final PropertyIssues propertyIssues;

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public T getValue(Function<Invalid<T>, ? extends RuntimeException> orThrow) {
            throw orThrow.apply(this);
        }

        @Override
        public <U extends T> Validation<U> and(Validation<U> other) {
            return Validation.invalid(other.isValid() ? this.propertyIssues : PropertyIssues.of((PropertyIssue[])Stream.concat(this.propertyIssues.stream(), other.getPropertyIssues().stream()).toArray(PropertyIssue[]::new)));
        }

        public Invalid(PropertyIssues propertyIssues) {
            this.propertyIssues = propertyIssues;
        }

        @Override
        public PropertyIssues getPropertyIssues() {
            return this.propertyIssues;
        }
    }
}

