/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.maja.validation;

import java.util.Arrays;
import net.io_0.maja.Property;
import net.io_0.maja.PropertyIssue;
import net.io_0.maja.validation.PropertyPredicate;
import net.io_0.maja.validation.Validation;
import net.io_0.maja.validation.Validator;

public interface PropertyValidator<T>
extends Validator<Property<T>> {
    public static <T> PropertyValidator<T> of(PropertyPredicate<T> predicate, PropertyIssue.Issue issue) {
        return property -> predicate.test((Property)property) ? Validation.valid(property) : Validation.invalid(PropertyIssue.of(property.getName(), issue.withMessage(String.format(issue.getMessage(), property.isNull() ? null : property.getValue()))));
    }

    @SafeVarargs
    public static <T> PropertyValidator<T> andAll(PropertyValidator<? extends T> ... validators) {
        return Arrays.stream(validators).map(v -> v).reduce((a, b) -> t -> a.validate(t).and(b.validate(t))).orElseThrow(IllegalArgumentException::new);
    }
}

