/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.maja.validation;

import java.math.BigDecimal;
import java.util.Collection;
import net.io_0.maja.Property;
import net.io_0.maja.validation.PropertyPredicate;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.UrlValidator;

public interface PropertyPredicates {
    public static final PropertyPredicate<?> assigned = Property::isAssigned;
    public static final PropertyPredicate<?> assignedAndNotNull = assigned.and(PropertyPredicate.not(Property::isNull));
    public static final PropertyPredicate<?> unassignedOrNull = PropertyPredicate.not(assignedAndNotNull);
    public static final PropertyPredicate<?> unassignedOrNotNull = PropertyPredicate.not(assigned).or(PropertyPredicate.not(Property::isNull));
    public static final PropertyPredicate<String> email = property -> EmailValidator.getInstance().isValid((String)property.getValue());
    public static final PropertyPredicate<String> hostname = property -> DomainValidator.getInstance().isValid((String)property.getValue());
    public static final PropertyPredicate<String> inet4Address = property -> InetAddressValidator.getInstance().isValidInet4Address((String)property.getValue());
    public static final PropertyPredicate<String> inet6Address = property -> InetAddressValidator.getInstance().isValidInet6Address((String)property.getValue());
    public static final PropertyPredicate<String> url = property -> UrlValidator.getInstance().isValid((String)property.getValue());

    public static <T> PropertyPredicate<T> unassignedOrNullOr(PropertyPredicate<T> predicate) {
        return PropertyPredicate.not(Property::isAssigned).or(Property::isNull).or(predicate);
    }

    public static PropertyPredicate<Number> lte(Number number) {
        return property -> PropertyPredicates.compare(number, (Number)property.getValue()) <= 0;
    }

    public static PropertyPredicate<Number> lt(Number number) {
        return property -> PropertyPredicates.compare(number, (Number)property.getValue()) < 0;
    }

    public static PropertyPredicate<Number> gte(Number number) {
        return property -> PropertyPredicates.compare(number, (Number)property.getValue()) >= 0;
    }

    public static PropertyPredicate<Number> gt(Number number) {
        return property -> PropertyPredicates.compare(number, (Number)property.getValue()) > 0;
    }

    public static PropertyPredicate<String> lengthGte(Integer number) {
        return property -> ((String)property.getValue()).length() >= number;
    }

    public static PropertyPredicate<String> lengthLte(Integer number) {
        return property -> ((String)property.getValue()).length() <= number;
    }

    public static PropertyPredicate<Collection<?>> sizeGte(Integer number) {
        return property -> ((Collection)property.getValue()).size() >= number;
    }

    public static PropertyPredicate<Collection<?>> sizeLte(Integer number) {
        return property -> ((Collection)property.getValue()).size() <= number;
    }

    public static PropertyPredicate<String> regexMatch(String pattern) {
        return property -> new RegexValidator(pattern).isValid((String)property.getValue());
    }

    public static PropertyPredicate<Number> multipleOf(Number number) {
        return property -> (double)new BigDecimal(((Number)property.getValue()).toString()).remainder(new BigDecimal(number.toString())).abs().floatValue() < 1.0E-7;
    }

    public static Integer compare(Number a, Number b) {
        return new BigDecimal(a.toString()).compareTo(new BigDecimal(b.toString()));
    }
}

