/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.maja.mapping.jackson;

import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.io_0.maja.WithUnconventionalName;

public class WithUnconventionalNameAnnotationIntrospector
extends NopAnnotationIntrospector {
    public List<PropertyName> findPropertyAliases(Annotated annotated) {
        if (annotated.hasAnnotation(WithUnconventionalName.class)) {
            return List.of(PropertyName.construct((String)((WithUnconventionalName)annotated.getAnnotation(WithUnconventionalName.class)).value()));
        }
        return Collections.emptyList();
    }

    public String[] findEnumValues(Class<?> enumType, Enum<?>[] enumValues, String[] names) {
        return (String[])Arrays.stream(enumType.getFields()).map(field -> field.isAnnotationPresent(WithUnconventionalName.class) ? field.getAnnotation(WithUnconventionalName.class).value() : field.getName()).toArray(String[]::new);
    }

    public String[] findEnumValues(MapperConfig<?> config, AnnotatedClass annotatedClass, Enum<?>[] enumValues, String[] names) {
        return (String[])Arrays.stream(annotatedClass.getAnnotated().getFields()).map(field -> field.isAnnotationPresent(WithUnconventionalName.class) ? field.getAnnotation(WithUnconventionalName.class).value() : field.getName()).toArray(String[]::new);
    }

    public PropertyName findNameForSerialization(Annotated annotated) {
        if (annotated.hasAnnotation(WithUnconventionalName.class)) {
            return PropertyName.construct((String)((WithUnconventionalName)annotated.getAnnotation(WithUnconventionalName.class)).value());
        }
        return null;
    }

    public String findImplicitPropertyName(AnnotatedMember member) {
        String name = member.getName();
        if (this.breaksNamingConvention(name)) {
            return Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return null;
    }

    private boolean breaksNamingConvention(String name) {
        return name.length() > 2 && Character.isLowerCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1));
    }
}

