/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.maja.mapping.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.io_0.maja.PropertyIssue;
import org.joor.Reflect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class PropertyIssueCollectingDeserializationProblemHandler
extends DeserializationProblemHandler {
    private static final Logger log = LoggerFactory.getLogger(PropertyIssueCollectingDeserializationProblemHandler.class);
    private static final TypeReference<Map<String, Object>> jsonAsMapType = new TypeReference<Map<String, Object>>(){};
    private final Consumer<PropertyIssue> propertyIssueConsumer;

    public PropertyIssueCollectingDeserializationProblemHandler(Consumer<PropertyIssue> propertyIssueConsumer) {
        this.propertyIssueConsumer = propertyIssueConsumer;
    }

    public Object handleWeirdStringValue(DeserializationContext ctx, Class<?> targetType, String valueToConvert, String failureMsg) {
        return this.addErrorAndReturnNull(ctx, "Weird String Value", PropertyIssueCollectingDeserializationProblemHandler.stringifyAndJoinWithComma(valueToConvert, failureMsg));
    }

    public Object handleInstantiationProblem(DeserializationContext ctx, Class<?> instClass, Object argument, Throwable t) {
        return this.addErrorAndReturnNull(ctx, "Instantiation Problem", PropertyIssueCollectingDeserializationProblemHandler.stringifyAndJoinWithComma(argument, t.getMessage()));
    }

    public Object handleWeirdKey(DeserializationContext ctx, Class<?> rawKeyType, String keyValue, String failureMsg) {
        return this.addErrorAndReturnNull(ctx, "Weird Key", PropertyIssueCollectingDeserializationProblemHandler.stringifyAndJoinWithComma(keyValue, failureMsg));
    }

    public Object handleWeirdNumberValue(DeserializationContext ctx, Class<?> targetType, Number valueToConvert, String failureMsg) {
        return this.addErrorAndReturnNull(ctx, "Weird Number Value", PropertyIssueCollectingDeserializationProblemHandler.stringifyAndJoinWithComma(valueToConvert, failureMsg));
    }

    public Object handleUnexpectedToken(DeserializationContext ctx, JavaType targetType, JsonToken t, JsonParser p, String failureMsg) {
        if (targetType.isTypeOrSubTypeOf(String.class) && t.isStructStart()) {
            try {
                if (p instanceof YAMLParser) {
                    return new Yaml().dump(p.readValueAs(Object.class));
                }
                return p.readValueAsTree().toString();
            }
            catch (IOException e) {
                log.debug("Failed to convert json to string", (Throwable)e);
            }
        }
        return this.addErrorAndReturnNull(ctx, "Unexpected Token", PropertyIssueCollectingDeserializationProblemHandler.stringifyAndJoinWithComma(t, failureMsg));
    }

    public Object handleMissingInstantiator(DeserializationContext ctx, Class<?> instClass, ValueInstantiator instantiator, JsonParser p, String msg) {
        Optional<?> instance;
        if (instClass.isInterface() && (instance = PropertyIssueCollectingDeserializationProblemHandler.getInstance(instClass, p)).isPresent()) {
            return instance.get();
        }
        return this.addErrorAndReturnNull(ctx, "Missing Instantiator", PropertyIssueCollectingDeserializationProblemHandler.stringifyAndJoinWithComma(instantiator, msg));
    }

    private static <T> Optional<T> getInstance(Class<T> interfaceClass, JsonParser p) {
        return Stream.of(interfaceClass.getMethods()).filter(method -> (method.isDefault() || Modifier.isStatic(method.getModifiers())) && method.getReturnType().equals(interfaceClass) && method.getParameters().length == 1 && jsonAsMapType.getType().equals(method.getParameters()[0].getParameterizedType())).findAny().map(method -> {
            try {
                Map data = (Map)p.readValueAs(jsonAsMapType);
                return method.invoke(Reflect.on((Object)new Object()).as(interfaceClass), data);
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    private static String extractAttributeName(JsonParser parser) {
        String path = parser.getParsingContext().pathAsPointer().toString();
        return path.length() > 0 ? path.substring(1).replace("/", ".") : "*";
    }

    private static String removeLineBreaks(String string) {
        return string.replaceAll("\\R+", "");
    }

    private Object addErrorAndReturnNull(DeserializationContext ctx, String code, String message) {
        this.propertyIssueConsumer.accept(PropertyIssue.of(PropertyIssueCollectingDeserializationProblemHandler.extractAttributeName(ctx.getParser()), code, PropertyIssueCollectingDeserializationProblemHandler.removeLineBreaks(message)));
        return null;
    }

    private static String stringifyAndJoinWithComma(Object a, Object b) {
        return String.format("%s, %s", a, b);
    }
}

