/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.maja;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.function.Function;
import net.io_0.maja.Property;
import net.io_0.maja.PropertyBuildingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoProperty<T>
implements Property<T> {
    private static final Logger log = LoggerFactory.getLogger(PojoProperty.class);
    private final String name;
    private final T value;

    public static <T> Property<T> from(Object pojo, String propertyName) {
        return (Property)PropertyBuildingUtils.annotatedNameToJavaName(pojo, propertyName).flatMap(javaName -> PropertyBuildingUtils.extractProperty(pojo, javaName, PojoProperty.constructWith(pojo, propertyName, javaName))).or(() -> PropertyBuildingUtils.extractProperty(pojo, propertyName, PojoProperty.constructWith(pojo, propertyName, propertyName))).orElseThrow(() -> new IllegalArgumentException(String.format("Property with name '%s' not found on %s", propertyName, pojo.getClass().getSimpleName())));
    }

    @Override
    public boolean isNull() {
        return Objects.isNull(this.value);
    }

    @Override
    public T getValue() {
        Objects.requireNonNull(this.value);
        return this.value;
    }

    @Override
    public boolean isAssigned() {
        return true;
    }

    private static <T> Function<PropertyDescriptor, Property<T>> constructWith(Object pojo, String propertyName, String javaName) {
        return propertyDescriptor -> {
            try {
                return new PojoProperty<Object>(propertyName, propertyDescriptor.getReadMethod().invoke(pojo, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException(String.format("Couldn't access property with name '%s' on %s", javaName, pojo.getClass().getSimpleName()), e);
            }
        };
    }

    public PojoProperty(String name, T value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

