/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.maja.validation;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.io_0.maja.PropertyIssues;
import net.io_0.maja.validation.NameBoundPropertyConstraint;
import net.io_0.maja.validation.PropertyConstraint;
import net.io_0.maja.validation.Validation;

@FunctionalInterface
public interface Validator<T> {
    public Validation<T> validate(T var1);

    public static <T> Validator<T> of(PropertyIssues propertyIssues) {
        return model -> Validation.of(model, propertyIssues);
    }

    public static <T> Validator<T> of(NameBoundPropertyConstraint<?> ... nameBoundPropertyConstraints) {
        return model -> Arrays.stream(nameBoundPropertyConstraints).map(nameBoundPropertyConstraint -> (PropertyConstraint)nameBoundPropertyConstraint.apply(model)).map(PropertyConstraint::check).filter(Validation::isInvalid).reduce(Validation::and).map(validation -> Validation.of(model, validation.getPropertyIssues())).orElse(Validation.valid(model));
    }

    default public T ensureValidity(T t) {
        return this.ensureValidity(t, ValidationException::new);
    }

    default public T ensureValidity(T t, Function<Validation.Invalid<T>, ? extends RuntimeException> orThrow) {
        return this.validate(t).getValue(orThrow);
    }

    default public <U extends T> Validator<U> and(Validator<? extends U> other) {
        return u -> this.validate(u).and(other.validate((Object)u));
    }

    public static class ValidationException
    extends RuntimeException {
        private final Validation.Invalid validation;

        public ValidationException(Validation.Invalid validation) {
            super(ValidationException.toFullMessage(validation.getPropertyIssues().stream().map(propertyIssue -> String.format("%s -> %s", propertyIssue.getPropertyName(), propertyIssue.getIssue())).collect(Collectors.joining(", "))));
            this.validation = validation;
        }

        private static String toFullMessage(String issues) {
            return issues.isBlank() ? "Validation failed." : "Validation failed. Issues: " + issues;
        }

        public Validation.Invalid getValidation() {
            return this.validation;
        }
    }
}

