/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.maja.validation;

import net.io_0.maja.Property;
import net.io_0.maja.validation.NameBoundPropertyConstraint;
import net.io_0.maja.validation.PropertyValidator;
import net.io_0.maja.validation.Validation;

public class PropertyConstraint<T> {
    private final Property<T> property;
    private final PropertyValidator<T> validator;

    public static <T> NameBoundPropertyConstraint<T> on(String propertyName, PropertyValidator<T> validator) {
        return model -> new PropertyConstraint(Property.from(model, propertyName), validator);
    }

    @SafeVarargs
    public static <T> NameBoundPropertyConstraint<T> on(String propertyName, PropertyValidator<? extends T> ... validators) {
        return model -> new PropertyConstraint(Property.from(model, propertyName), PropertyValidator.andAll(validators));
    }

    public Validation<Property<T>> check() {
        return this.validator.validate(this.property);
    }

    public PropertyConstraint(Property<T> property, PropertyValidator<T> validator) {
        this.property = property;
        this.validator = validator;
    }
}

