/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.maja.mapping;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.pivovarit.function.ThrowingFunction;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.io_0.maja.PropertyIssue;
import net.io_0.maja.PropertyIssues;
import net.io_0.maja.mapping.jackson.FirstCharCaseIgnoredPropertyNamingStrategy;
import net.io_0.maja.mapping.jackson.PropertyBundleBeanSerializerModifier;
import net.io_0.maja.mapping.jackson.PropertyIssueCollectingDeserializationProblemHandler;
import net.io_0.maja.mapping.jackson.WithUnconventionalNameAnnotationIntrospector;

public class Mapper {
    public static <T> T fromJson(String json, Class<T> type, Class<?> ... subTypes) {
        return Mapper.fromJson(json, Context.of(), type, subTypes);
    }

    public static <T> T fromJson(String json, Consumer<PropertyIssue> propertyIssueConsumer, Class<T> type, Class<?> ... subTypes) {
        return Mapper.fromJson(json, Context.ofPropertyIssueConsumer(propertyIssueConsumer), type, subTypes);
    }

    public static <T> T fromJson(String json, Context context, Class<T> type, Class<?> ... subTypes) {
        return (T)Mapper.throwMappingExceptionIfIssuesAndNoIssueConsumer(context, ctx -> Mapper.mapWithJsonObjectMapper(oM -> Mapper.prepForJsonOrYamlMapping(oM, ctx).readValue(json, oM.getTypeFactory().constructParametricType(type, subTypes))));
    }

    public static <T> T readJson(Reader reader, Class<T> type, Class<?> ... subTypes) {
        return Mapper.readJson(reader, Context.of(), type, subTypes);
    }

    public static <T> T readJson(Reader reader, Consumer<PropertyIssue> propertyIssueConsumer, Class<T> type, Class<?> ... subTypes) {
        return Mapper.readJson(reader, Context.ofPropertyIssueConsumer(propertyIssueConsumer), type, subTypes);
    }

    public static <T> T readJson(Reader reader, Context context, Class<T> type, Class<?> ... subTypes) {
        return (T)Mapper.throwMappingExceptionIfIssuesAndNoIssueConsumer(context, ctx -> Mapper.mapWithJsonObjectMapper(oM -> Mapper.prepForJsonOrYamlMapping(oM, ctx).readValue(reader, oM.getTypeFactory().constructParametricType(type, subTypes))));
    }

    public static <T> T fromYaml(String yaml, Class<T> type, Class<?> ... subTypes) {
        return Mapper.fromYaml(yaml, Context.of(), type, subTypes);
    }

    public static <T> T fromYaml(String yaml, Consumer<PropertyIssue> propertyIssueConsumer, Class<T> type, Class<?> ... subTypes) {
        return Mapper.fromYaml(yaml, Context.ofPropertyIssueConsumer(propertyIssueConsumer), type, subTypes);
    }

    public static <T> T fromYaml(String yaml, Context context, Class<T> type, Class<?> ... subTypes) {
        return (T)Mapper.throwMappingExceptionIfIssuesAndNoIssueConsumer(context, ctx -> Mapper.mapWithYamlObjectMapper(oM -> Mapper.prepForJsonOrYamlMapping(oM, ctx).readValue(yaml, oM.getTypeFactory().constructParametricType(type, subTypes))));
    }

    public static <T> T readYaml(Reader reader, Class<T> type, Class<?> ... subTypes) {
        return Mapper.readYaml(reader, Context.of(), type, subTypes);
    }

    public static <T> T readYaml(Reader reader, Consumer<PropertyIssue> propertyIssueConsumer, Class<T> type, Class<?> ... subTypes) {
        return Mapper.readYaml(reader, Context.ofPropertyIssueConsumer(propertyIssueConsumer), type, subTypes);
    }

    public static <T> T readYaml(Reader reader, Context context, Class<T> type, Class<?> ... subTypes) {
        return (T)Mapper.throwMappingExceptionIfIssuesAndNoIssueConsumer(context, ctx -> Mapper.mapWithYamlObjectMapper(oM -> Mapper.prepForJsonOrYamlMapping(oM, ctx).readValue(reader, oM.getTypeFactory().constructParametricType(type, subTypes))));
    }

    public static <T> T fromMap(Map<String, ?> map, Class<T> type, Class<?> ... subTypes) {
        return Mapper.fromMap(map, Context.of(), type, subTypes);
    }

    public static <T> T fromMap(Map<String, ?> map, Consumer<PropertyIssue> propertyIssueConsumer, Class<T> type, Class<?> ... subTypes) {
        return Mapper.fromMap(map, Context.ofPropertyIssueConsumer(propertyIssueConsumer), type, subTypes);
    }

    public static <T> T fromMap(Map<String, ?> map, Context context, Class<T> type, Class<?> ... subTypes) {
        return (T)Mapper.throwMappingExceptionIfIssuesAndNoIssueConsumer(context, ctx -> Mapper.mapWithYamlObjectMapper(oM -> Mapper.prepForJsonOrYamlMapping(oM, ctx).convertValue((Object)map, oM.getTypeFactory().constructParametricType(type, subTypes))));
    }

    public static <T> String toJson(T obj) {
        return (String)Mapper.mapWithJsonObjectMapper(oM -> Mapper.prepForPojoMapping(oM).writeValueAsString(obj));
    }

    public static <T> void writeJson(Writer writer, T obj) {
        Mapper.mapWithJsonObjectMapper(oM -> {
            Mapper.prepForPojoMapping(oM).writeValue(writer, obj);
            return null;
        });
    }

    public static <T> String toYaml(T obj) {
        return (String)Mapper.mapWithYamlObjectMapper(oM -> Mapper.prepForPojoMapping(oM).writeValueAsString(obj));
    }

    public static <T> void writeYaml(Writer writer, T obj) {
        Mapper.mapWithYamlObjectMapper(oM -> {
            Mapper.prepForPojoMapping(oM).writeValue(writer, obj);
            return null;
        });
    }

    public static <T> Map<String, Object> toMap(T obj) {
        return (Map)Mapper.mapWithJsonObjectMapper(oM -> (Map)Mapper.prepForPojoMapping(oM).convertValue(obj, (TypeReference)new TypeReference<Map<String, Object>>(){}));
    }

    @Deprecated(forRemoval=true)
    public static <T> T fromJson(String json, Class<T> type, Consumer<PropertyIssue> propertyIssueConsumer) {
        return Mapper.fromJson(json, propertyIssueConsumer, type, new Class[0]);
    }

    @Deprecated(forRemoval=true)
    public static <T> T readJson(Reader reader, Class<T> type, Consumer<PropertyIssue> propertyIssueConsumer) {
        return Mapper.readJson(reader, propertyIssueConsumer, type, new Class[0]);
    }

    @Deprecated(forRemoval=true)
    public static <T> T fromMap(Map<String, ?> map, Class<T> type, Consumer<PropertyIssue> propertyIssueConsumer) {
        return Mapper.fromMap(map, propertyIssueConsumer, type, new Class[0]);
    }

    private static ObjectMapper prepForJsonOrYamlMapping(ObjectMapper oM, Context ctx) {
        if (Objects.nonNull(ctx.instantiators)) {
            oM.registerModule((Module)Instantiator.toModule(ctx.instantiators));
        }
        return oM.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES}).addHandler((DeserializationProblemHandler)new PropertyIssueCollectingDeserializationProblemHandler(ctx.propertyIssueConsumer));
    }

    private static ObjectMapper prepForPojoMapping(ObjectMapper oM) {
        return oM.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).setSerializationInclusion(JsonInclude.Include.NON_ABSENT).setSerializerFactory(oM.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)new PropertyBundleBeanSerializerModifier()));
    }

    private static <T> T mapWithJsonObjectMapper(ThrowingFunction<ObjectMapper, T, IOException> cb) {
        return Mapper.mapWithObjectMapper(new JsonFactory(), cb);
    }

    private static <T> T mapWithYamlObjectMapper(ThrowingFunction<ObjectMapper, T, IOException> cb) {
        return Mapper.mapWithObjectMapper((JsonFactory)new YAMLFactory(), cb);
    }

    private static <T> T mapWithObjectMapper(JsonFactory factory, ThrowingFunction<ObjectMapper, T, IOException> cb) {
        try {
            return (T)cb.apply((Object)Mapper.getPreConfiguredObjectMapper(factory));
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }

    private static ObjectMapper getPreConfiguredObjectMapper(JsonFactory factory) {
        ObjectMapper mapper = new ObjectMapper(factory).registerModule((Module)new JavaTimeModule()).setAnnotationIntrospector((AnnotationIntrospector)new WithUnconventionalNameAnnotationIntrospector()).disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
        return Mapper.circumventJacksonBeanNamingConventionProblems(mapper);
    }

    private static ObjectMapper circumventJacksonBeanNamingConventionProblems(ObjectMapper mapper) {
        return mapper.enable(new MapperFeature[]{MapperFeature.USE_STD_BEAN_NAMING}).setPropertyNamingStrategy((PropertyNamingStrategy)new FirstCharCaseIgnoredPropertyNamingStrategy());
    }

    private static <T> T throwMappingExceptionIfIssuesAndNoIssueConsumer(Context context, Function<Context, T> cb) {
        return (T)(Objects.isNull(context.propertyIssueConsumer) ? Mapper.throwMappingExceptionIfIssues(pIC -> cb.apply(context.withPropertyIssueConsumer((Consumer<PropertyIssue>)pIC))) : cb.apply(context));
    }

    private static <T> T throwMappingExceptionIfIssues(Function<Consumer<PropertyIssue>, T> cb) {
        PropertyIssues propertyIssues = PropertyIssues.of();
        T t = cb.apply(propertyIssues::add);
        if (!propertyIssues.isEmpty()) {
            throw new MappingException(new IllegalStateException(propertyIssues.toString()));
        }
        return t;
    }

    private Mapper() {
    }

    public static class MappingException
    extends RuntimeException {
        public MappingException(Throwable cause) {
            super(cause);
        }
    }

    public static class Instantiator {
        private final Class<?> target;
        private final Function<Map<String, Object>, ?> constructor;

        private <T> Instantiator(Class<T> target, Function<Map<String, Object>, ? extends T> constructor) {
            this.target = target;
            this.constructor = constructor;
        }

        public static <T> Instantiator of(Class<T> target, Function<Map<String, Object>, ? extends T> constructor) {
            return new Instantiator(target, constructor);
        }

        private static SimpleModule toModule(List<Instantiator> instantiators) {
            SimpleModule sm = new SimpleModule();
            instantiators.forEach(i -> sm.addDeserializer(i.target, new JsonDeserializer((Instantiator)i){
                final /* synthetic */ Instantiator val$i;
                {
                    this.val$i = instantiator;
                }

                public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                    return this.val$i.constructor.apply((Map)p.readValueAs((TypeReference)new TypeReference<Map<String, Object>>(){}));
                }
            }));
            return sm;
        }
    }

    public static class Context {
        private final Consumer<PropertyIssue> propertyIssueConsumer;
        private final List<Instantiator> instantiators;

        public static Context of() {
            return Context.builder().build();
        }

        public static Context ofPropertyIssueConsumer(Consumer<PropertyIssue> pIC) {
            return Context.builder().propertyIssueConsumer(pIC).build();
        }

        public static Context ofInstantiators(Instantiator ... instantiators) {
            return Context.builder().instantiators(Arrays.asList(instantiators)).build();
        }

        public Context withPropertyIssueConsumer(Consumer<PropertyIssue> pIC) {
            return this.toBuilder().propertyIssueConsumer(pIC).build();
        }

        Context(Consumer<PropertyIssue> propertyIssueConsumer, List<Instantiator> instantiators) {
            this.propertyIssueConsumer = propertyIssueConsumer;
            this.instantiators = instantiators;
        }

        public static ContextBuilder builder() {
            return new ContextBuilder();
        }

        public ContextBuilder toBuilder() {
            return new ContextBuilder().propertyIssueConsumer(this.propertyIssueConsumer).instantiators(this.instantiators);
        }

        public static class ContextBuilder {
            private Consumer<PropertyIssue> propertyIssueConsumer;
            private List<Instantiator> instantiators;

            ContextBuilder() {
            }

            public ContextBuilder propertyIssueConsumer(Consumer<PropertyIssue> propertyIssueConsumer) {
                this.propertyIssueConsumer = propertyIssueConsumer;
                return this;
            }

            public ContextBuilder instantiators(List<Instantiator> instantiators) {
                this.instantiators = instantiators;
                return this;
            }

            public Context build() {
                return new Context(this.propertyIssueConsumer, this.instantiators);
            }

            public String toString() {
                return "Mapper.Context.ContextBuilder(propertyIssueConsumer=" + this.propertyIssueConsumer + ", instantiators=" + this.instantiators + ")";
            }
        }
    }
}

