/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.maja;

import java.util.function.Consumer;
import net.io_0.maja.PojoProperty;
import net.io_0.maja.PropertyBundle;

public interface Property<T> {
    public String getName();

    public T getValue();

    public boolean isAssigned();

    public boolean isNull();

    @Deprecated(forRemoval=true)
    default public boolean isEmpty() {
        return this.isNull();
    }

    public static <T> Property<T> from(Object model, String propertyName) {
        return model instanceof PropertyBundle ? ((PropertyBundle)model).getProperty(propertyName) : PojoProperty.from(model, propertyName);
    }

    default public void ifUnassigned(Runnable onAbsent) {
        if (!this.isAssigned()) {
            onAbsent.run();
        }
    }

    default public void ifAssigned(Consumer<T> onValueOrNull) {
        if (this.isAssigned()) {
            onValueOrNull.accept(this.isNull() ? null : (Object)this.getValue());
        }
    }

    default public void ifAssigned(Consumer<T> onValue, Runnable onNull) {
        if (!this.isAssigned()) {
            return;
        }
        if (this.isNull()) {
            onNull.run();
        } else {
            onValue.accept(this.getValue());
        }
    }
}

