/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.caja.redis;

import io.lettuce.core.api.sync.RedisCommands;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.io_0.caja.redis.KeyOrWildcard;
import net.io_0.caja.sync.Cache;

public class RedisSyncWrapper {
    public static <K, V> Cache<K, V> wrap(final RedisCommands<KeyOrWildcard<K>, V> cache, final Integer ttlInSeconds) {
        return new Cache<K, V>(){

            @Override
            public V get(K key) {
                Objects.requireNonNull(key);
                return cache.get(KeyOrWildcard.key(key));
            }

            @Override
            public void put(K key, V value) {
                Objects.requireNonNull(key);
                cache.setex(KeyOrWildcard.key(key), (long)ttlInSeconds.intValue(), value);
            }

            @Override
            public boolean containsKey(K key) {
                Objects.requireNonNull(key);
                return cache.exists((Object[])new KeyOrWildcard[]{KeyOrWildcard.key(key)}) > 0L;
            }

            @Override
            public List<K> keys() {
                return this.fetchKeys().stream().map(KeyOrWildcard::getKey).collect(Collectors.toList());
            }

            private List<KeyOrWildcard<K>> fetchKeys() {
                return cache.keys(KeyOrWildcard.wildcard());
            }

            @Override
            public void remove(K key) {
                Objects.requireNonNull(key);
                cache.del((Object[])new KeyOrWildcard[]{KeyOrWildcard.key(key)});
            }

            @Override
            public void clear() {
                this.fetchKeys().forEach(xva$0 -> cache.del((Object[])new KeyOrWildcard[]{xva$0}));
            }
        };
    }

    private RedisSyncWrapper() {
    }
}

