/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.caja.async;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public interface Cache<K, V> {
    public CompletableFuture<V> get(K var1);

    public CompletableFuture<Void> put(K var1, V var2);

    public CompletableFuture<Boolean> containsKey(K var1);

    public CompletableFuture<List<K>> keys();

    public CompletableFuture<Void> remove(K var1);

    public CompletableFuture<Void> clear();

    default public CompletableFuture<V> getThrough(K key, Supplier<V> valueSupplier) {
        return this.getThroughFuture(key, () -> CompletableFuture.completedFuture(valueSupplier.get()));
    }

    default public CompletableFuture<V> getThroughFuture(K key, Supplier<CompletableFuture<V>> valueSupplier) {
        return this.get(key).thenCompose(value -> Objects.nonNull(value) ? CompletableFuture.completedFuture(value) : ((CompletableFuture)valueSupplier.get()).thenCompose(newValue -> this.put(key, newValue).thenApply(nothing -> newValue)));
    }
}

