/*
 * Decompiled with CFR 0.152.
 */
package com.instacart.library.truetime;

import android.os.SystemClock;
import com.instacart.library.truetime.CacheInterface;
import com.instacart.library.truetime.SntpClient;
import com.instacart.library.truetime.TrueLog;

class DiskCacheClient {
    private static final String TAG = DiskCacheClient.class.getSimpleName();
    private CacheInterface _cacheInterface = null;

    DiskCacheClient() {
    }

    void enableCacheInterface(CacheInterface cacheInterface) {
        this._cacheInterface = cacheInterface;
    }

    void clearCachedInfo() {
        this.clearCachedInfo(this._cacheInterface);
    }

    void clearCachedInfo(CacheInterface cacheInterface) {
        if (cacheInterface != null) {
            cacheInterface.clear();
        }
    }

    void cacheTrueTimeInfo(SntpClient sntpClient) {
        if (this.cacheUnavailable()) {
            return;
        }
        long cachedSntpTime = sntpClient.getCachedSntpTime();
        long cachedDeviceUptime = sntpClient.getCachedDeviceUptime();
        long bootTime = cachedSntpTime - cachedDeviceUptime;
        TrueLog.d(TAG, String.format("Caching true time info to disk sntp [%s] device [%s] boot [%s]", cachedSntpTime, cachedDeviceUptime, bootTime));
        this._cacheInterface.put("com.instacart.library.truetime.cached_boot_time", bootTime);
        this._cacheInterface.put("com.instacart.library.truetime.cached_device_uptime", cachedDeviceUptime);
        this._cacheInterface.put("com.instacart.library.truetime.cached_sntp_time", cachedSntpTime);
    }

    boolean isTrueTimeCachedFromAPreviousBoot() {
        if (this.cacheUnavailable()) {
            return false;
        }
        long cachedBootTime = this._cacheInterface.get("com.instacart.library.truetime.cached_boot_time", 0L);
        if (cachedBootTime == 0L) {
            return false;
        }
        boolean bootTimeChanged = SystemClock.elapsedRealtime() < this.getCachedDeviceUptime();
        TrueLog.i(TAG, "---- boot time changed " + bootTimeChanged);
        return !bootTimeChanged;
    }

    long getCachedDeviceUptime() {
        if (this.cacheUnavailable()) {
            return 0L;
        }
        return this._cacheInterface.get("com.instacart.library.truetime.cached_device_uptime", 0L);
    }

    long getCachedSntpTime() {
        if (this.cacheUnavailable()) {
            return 0L;
        }
        return this._cacheInterface.get("com.instacart.library.truetime.cached_sntp_time", 0L);
    }

    private boolean cacheUnavailable() {
        if (this._cacheInterface == null) {
            TrueLog.w(TAG, "Cannot use disk caching strategy for TrueTime. CacheInterface unavailable");
            return true;
        }
        return false;
    }
}

