/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.sero.log;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SimpleLog {
    private final PrintWriter out;
    private final SimpleDateFormat sdf = new SimpleDateFormat("MM/dd HH:mm:ss.SSS");
    private final StringBuilder sb = new StringBuilder();
    private final Date date = new Date();

    public SimpleLog() {
        this(new PrintWriter(System.out));
    }

    public SimpleLog(PrintWriter out) {
        this.out = out;
    }

    public void out(String message) {
        this.out(message, null);
    }

    public void out(Throwable t) {
        this.out(null, t);
    }

    public void out(Object o) {
        if (o instanceof Throwable) {
            this.out(null, (Throwable)o);
        } else if (o == null) {
            this.out(null, null);
        } else {
            this.out(o.toString(), null);
        }
    }

    public void close() {
        this.out.close();
    }

    public synchronized void out(String message, Throwable t) {
        this.sb.delete(0, this.sb.length());
        this.date.setTime(System.currentTimeMillis());
        this.sb.append(this.sdf.format(this.date)).append(" ");
        if (message != null) {
            this.sb.append(message);
        }
        if (t != null) {
            if (t.getMessage() != null) {
                this.sb.append(" - ").append(t.getMessage());
            }
            this.out.println(this.sb.toString());
            t.printStackTrace(this.out);
        } else {
            this.out.println(this.sb.toString());
        }
        this.out.flush();
    }
}

