/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.serial.rtu;

import com.serotonin.modbus4j.exception.ModbusInitException;
import com.serotonin.modbus4j.exception.ModbusTransportException;
import com.serotonin.modbus4j.msg.ModbusRequest;
import com.serotonin.modbus4j.msg.ModbusResponse;
import com.serotonin.modbus4j.serial.SerialMaster;
import com.serotonin.modbus4j.serial.SerialPortWrapper;
import com.serotonin.modbus4j.serial.SerialWaitingRoomKeyFactory;
import com.serotonin.modbus4j.serial.rtu.RtuMessageParser;
import com.serotonin.modbus4j.serial.rtu.RtuMessageRequest;
import com.serotonin.modbus4j.serial.rtu.RtuMessageResponse;
import com.serotonin.modbus4j.sero.ShouldNeverHappenException;
import com.serotonin.modbus4j.sero.messaging.MessageControl;
import com.serotonin.modbus4j.sero.messaging.StreamTransport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RtuMaster
extends SerialMaster {
    private final Log LOG = LogFactory.getLog(RtuMaster.class);
    private MessageControl conn;

    public RtuMaster(SerialPortWrapper wrapper) {
        super(wrapper, true);
    }

    public RtuMaster(SerialPortWrapper wrapper, boolean validateResponse) {
        super(wrapper, validateResponse);
    }

    @Override
    public void init() throws ModbusInitException {
        try {
            this.openConnection(null);
        }
        catch (Exception e) {
            throw new ModbusInitException(e);
        }
        this.initialized = true;
    }

    @Override
    protected void openConnection(MessageControl toClose) throws Exception {
        super.openConnection(toClose);
        RtuMessageParser rtuMessageParser = new RtuMessageParser(true);
        this.conn = this.getMessageControl();
        this.conn.start(this.transport, rtuMessageParser, null, new SerialWaitingRoomKeyFactory());
        if (this.getePoll() == null) {
            ((StreamTransport)this.transport).start("Modbus RTU master");
        }
    }

    @Override
    public void destroy() {
        this.closeMessageControl(this.conn);
        super.close();
        this.initialized = false;
    }

    @Override
    public ModbusResponse sendImpl(ModbusRequest request) throws ModbusTransportException {
        RtuMessageRequest rtuRequest = new RtuMessageRequest(request);
        try {
            RtuMessageResponse rtuResponse = (RtuMessageResponse)this.conn.send(rtuRequest);
            if (rtuResponse == null) {
                return null;
            }
            return rtuResponse.getModbusResponse();
        }
        catch (Exception e) {
            try {
                this.LOG.debug((Object)"Connection may have been reset. Attempting to re-open.");
                this.openConnection(this.conn);
                RtuMessageResponse rtuResponse = (RtuMessageResponse)this.conn.send(rtuRequest);
                if (rtuResponse == null) {
                    return null;
                }
                return rtuResponse.getModbusResponse();
            }
            catch (Exception e2) {
                this.closeConnection(this.conn);
                this.LOG.debug((Object)"Failed to re-connect", (Throwable)e);
                throw new ModbusTransportException(e2, request.getSlaveId());
            }
        }
    }

    public static long computeMessageFrameSpacing(SerialPortWrapper wrapper) {
        if (wrapper.getBaudRate() > 19200) {
            return 1750000L;
        }
        float charTime = RtuMaster.computeCharacterTime(wrapper);
        return (long)(charTime * 3.5f);
    }

    public static long computeCharacterSpacing(SerialPortWrapper wrapper) {
        if (wrapper.getBaudRate() > 19200) {
            return 750000L;
        }
        float charTime = RtuMaster.computeCharacterTime(wrapper);
        return (long)(charTime * 1.5f);
    }

    public static float computeCharacterTime(SerialPortWrapper wrapper) {
        float charBits = wrapper.getDataBits();
        switch (wrapper.getStopBits()) {
            case 1: {
                break;
            }
            case 2: {
                charBits += 2.0f;
                break;
            }
            case 3: {
                charBits += 1.5f;
                break;
            }
            default: {
                throw new ShouldNeverHappenException("Unknown stop bit size: " + wrapper.getStopBits());
            }
        }
        if (wrapper.getParity() > 0) {
            charBits += 1.0f;
        }
        return charBits / (float)wrapper.getBaudRate() * 1.0E9f;
    }
}

