/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.serial.ascii;

import com.serotonin.modbus4j.exception.ModbusInitException;
import com.serotonin.modbus4j.exception.ModbusTransportException;
import com.serotonin.modbus4j.msg.ModbusRequest;
import com.serotonin.modbus4j.msg.ModbusResponse;
import com.serotonin.modbus4j.serial.SerialMaster;
import com.serotonin.modbus4j.serial.SerialPortWrapper;
import com.serotonin.modbus4j.serial.SerialWaitingRoomKeyFactory;
import com.serotonin.modbus4j.serial.ascii.AsciiMessageParser;
import com.serotonin.modbus4j.serial.ascii.AsciiMessageRequest;
import com.serotonin.modbus4j.serial.ascii.AsciiMessageResponse;
import com.serotonin.modbus4j.sero.messaging.MessageControl;
import com.serotonin.modbus4j.sero.messaging.StreamTransport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsciiMaster
extends SerialMaster {
    private final Log LOG = LogFactory.getLog(SerialMaster.class);
    private MessageControl conn;

    public AsciiMaster(SerialPortWrapper wrapper) {
        super(wrapper, true);
    }

    public AsciiMaster(SerialPortWrapper wrapper, boolean validateResponse) {
        super(wrapper, validateResponse);
    }

    @Override
    public void init() throws ModbusInitException {
        try {
            this.openConnection(null);
        }
        catch (Exception e) {
            throw new ModbusInitException(e);
        }
        this.initialized = true;
    }

    @Override
    protected void openConnection(MessageControl toClose) throws Exception {
        super.openConnection(toClose);
        AsciiMessageParser asciiMessageParser = new AsciiMessageParser(true);
        this.conn = this.getMessageControl();
        this.conn.start(this.transport, asciiMessageParser, null, new SerialWaitingRoomKeyFactory());
        if (this.getePoll() == null) {
            ((StreamTransport)this.transport).start("Modbus ASCII master");
        }
    }

    @Override
    public void destroy() {
        this.closeMessageControl(this.conn);
        super.close();
        this.initialized = false;
    }

    @Override
    public ModbusResponse sendImpl(ModbusRequest request) throws ModbusTransportException {
        AsciiMessageRequest asciiRequest = new AsciiMessageRequest(request);
        try {
            AsciiMessageResponse asciiResponse = (AsciiMessageResponse)this.conn.send(asciiRequest);
            if (asciiResponse == null) {
                return null;
            }
            return asciiResponse.getModbusResponse();
        }
        catch (Exception e) {
            try {
                this.LOG.debug((Object)"Connection may have been reset. Attempting to re-open.");
                this.openConnection(this.conn);
                AsciiMessageResponse asciiResponse = (AsciiMessageResponse)this.conn.send(asciiRequest);
                if (asciiResponse == null) {
                    return null;
                }
                return asciiResponse.getModbusResponse();
            }
            catch (Exception e2) {
                this.closeConnection(this.conn);
                this.LOG.debug((Object)"Failed to re-connect", (Throwable)e);
                throw new ModbusTransportException(e2, request.getSlaveId());
            }
        }
    }
}

